/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.classpath.PhpSourcePathImplementation;
import org.netbeans.modules.php.project.classpath.SourcePathImplementation;
import org.netbeans.modules.php.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathProviderImpl
implements ClassPathProvider,
PhpSourcePathImplementation,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sources;
    private final SourceRoots tests;
    private final SourceRoots selenium;
    private final Map<String, List<FileObject>> dirCache = new HashMap<String, List<FileObject>>();
    private final Map<ClassPathCache, ClassPath> cache = new EnumMap<ClassPathCache, ClassPath>(ClassPathCache.class);

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, SourceRoots sourceRoots3) {
        assert (antProjectHelper != null);
        assert (propertyEvaluator != null);
        assert (sourceRoots != null);
        assert (sourceRoots2 != null);
        assert (sourceRoots3 != null);
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sources = sourceRoots;
        this.tests = sourceRoots2;
        this.selenium = sourceRoots3;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileObject> getDirs(String string) {
        Map<String, List<FileObject>> map = this.dirCache;
        synchronized (map) {
            List<FileObject> list = this.dirCache.get(string);
            if (!this.checkDirs(list)) {
                String string2 = this.evaluator.getProperty(string);
                if (string2 == null) {
                    return Collections.emptyList();
                }
                String[] stringArray = PropertyUtils.tokenizePath((String)string2);
                list = new ArrayList<FileObject>(stringArray.length);
                for (String string3 : stringArray) {
                    FileObject fileObject = this.helper.resolveFileObject(string3);
                    if (fileObject == null) continue;
                    list.add(fileObject);
                }
                this.dirCache.put(string, list);
            }
            return list;
        }
    }

    private boolean checkDirs(List<FileObject> list) {
        if (list == null) {
            return false;
        }
        for (FileObject fileObject : list) {
            if (fileObject.isValid()) continue;
            return false;
        }
        return true;
    }

    private List<FileObject> getPlatformPath() {
        return this.getDirs("include.path");
    }

    @Override
    public PhpSourcePath.FileType getFileType(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        for (FileObject fileObject2 : CommonPhpSourcePath.getInternalPath()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.INTERNAL;
        }
        for (FileObject fileObject2 : this.getPlatformPath()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.INCLUDE;
        }
        for (FileObject fileObject3 : this.tests.getRoots()) {
            if (!fileObject3.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.TEST;
        }
        for (FileObject fileObject3 : this.selenium.getRoots()) {
            if (!fileObject3.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.TEST;
        }
        for (FileObject fileObject3 : this.sources.getRoots()) {
            if (!fileObject3.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.SOURCE;
        }
        return PhpSourcePath.FileType.UNKNOWN;
    }

    @Override
    public List<FileObject> getIncludePath() {
        return new ArrayList<FileObject>(this.getPlatformPath());
    }

    @Override
    public FileObject resolveFile(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            return fileObject2;
        }
        for (FileObject fileObject3 : this.getPlatformPath()) {
            fileObject2 = fileObject3.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private ClassPath getSourcePath(FileObject fileObject) {
        return this.getSourcePath(this.getFileType(fileObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getSourcePath(PhpSourcePath.FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case SOURCE: {
                Map<ClassPathCache, ClassPath> map = this.cache;
                synchronized (map) {
                    classPath = this.cache.get((Object)ClassPathCache.SOURCE);
                    if (classPath == null) {
                        classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sources));
                        this.cache.put(ClassPathCache.SOURCE, classPath);
                    }
                    break;
                }
            }
            case TEST: {
                Map<ClassPathCache, ClassPath> map = this.cache;
                synchronized (map) {
                    classPath = this.cache.get((Object)ClassPathCache.TEST);
                    if (classPath == null) {
                        ClassPath classPath2 = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.tests));
                        ClassPath classPath3 = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.selenium));
                        ClassPath classPath4 = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sources));
                        classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath3, classPath4});
                        this.cache.put(ClassPathCache.TEST, classPath);
                    }
                    break;
                }
            }
        }
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getBootClassPath() {
        ClassPath classPath;
        Map<ClassPathCache, ClassPath> map = this.cache;
        synchronized (map) {
            classPath = this.cache.get((Object)ClassPathCache.PLATFORM);
            if (classPath == null) {
                List<FileObject> list = CommonPhpSourcePath.getInternalPath();
                ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])list.toArray(new FileObject[list.size()]));
                ClassPath classPath3 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation(this.projectDirectory, this.evaluator, new String[]{"include.path"}));
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath3});
                this.cache.put(ClassPathCache.PLATFORM, classPath);
            }
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/php-boot")) {
            return this.getBootClassPath();
        }
        if (string.equals("classpath/php-source")) {
            return this.getSourcePath(fileObject);
        }
        if (string.equals("js/library")) {
            return this.getSourcePath(PhpSourcePath.FileType.SOURCE);
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/php-boot".equals(string)) {
            PhpOptions.getInstance().getPhpGlobalIncludePath();
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/php-source".equals(string)) {
            return new ClassPath[]{this.getSourcePath(PhpSourcePath.FileType.SOURCE), this.getSourcePath(PhpSourcePath.FileType.TEST)};
        }
        assert (false) : "Unknown classpath type requested: " + string;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Map<String, List<FileObject>> map = this.dirCache;
        synchronized (map) {
            this.dirCache.remove(propertyChangeEvent.getPropertyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        PLATFORM,
        SOURCE,
        TEST;

    }
}

