/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.ExportDiffPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ExportDiffSupport {
    private AbstractExportDiffPanel panel;
    private DialogDescriptor dd;
    private Preferences preferences;
    private Dialog dialog;
    private ExportDiffProvider exportDiffProvider;
    private File[] files;

    public ExportDiffSupport(File[] fileArray, Preferences preferences) {
        this.preferences = preferences;
        this.files = fileArray;
    }

    protected void createComplexDialog(AbstractExportDiffPanel abstractExportDiffPanel) {
        this.dd = new DialogDescriptor((Object)abstractExportDiffPanel, NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
    }

    protected AbstractExportDiffPanel createSimpleDialog(String string) {
        this.dd = new DialogDescriptor((Object)this.createFileChooser(new File(string)), NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        this.dd.setOptions(new Object[0]);
        this.panel = new ExportDiffPanel(new JPanel());
        this.panel.setOutputFileText("");
        return this.panel;
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dd;
    }

    private void initializePanels() {
        this.exportDiffProvider = (ExportDiffProvider)Lookup.getDefault().lookup(ExportDiffProvider.class);
        String string = this.preferences.get("ExportDiff.saveFolder", System.getProperty("user.home"));
        if (this.exportDiffProvider == null) {
            this.panel = this.createSimpleDialog(string);
            this.dd = this.getDialogDescriptor();
        } else {
            this.exportDiffProvider.setContext(this.files);
            ExportDiffPanel exportDiffPanel = new ExportDiffPanel(this.exportDiffProvider.createComponent());
            exportDiffPanel.setOutputFileText(string);
            this.exportDiffProvider.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("ExportDiff.data.changed")) {
                        ExportDiffSupport.this.validate();
                    }
                }
            });
            exportDiffPanel.asFileRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExportDiffSupport.this.validate();
                }
            });
            exportDiffPanel.attachRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExportDiffSupport.this.validate();
                }
            });
            this.panel = exportDiffPanel;
            this.createComplexDialog(this.panel);
            this.dd = this.getDialogDescriptor();
        }
        this.panel.addOutputFileTextDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ExportDiffSupport.this.validate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExportDiffSupport.this.validate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ExportDiffSupport.this.validate();
            }
        });
        this.panel.addBrowseActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportDiffSupport.this.onChooseFile(new File(ExportDiffSupport.this.panel.getOutputFileText()));
            }
        });
    }

    private void validate() {
        assert (this.panel != null);
        if (this.exportDiffProvider == null || this.panel.isFileOutputSelected()) {
            this.dd.setValid(!this.panel.getOutputFileText().trim().equals(""));
        } else {
            this.dd.setValid(this.exportDiffProvider.isValid());
        }
    }

    public void export() {
        this.initializePanels();
        this.validate();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dd);
        this.dialog.setVisible(true);
        if (this.dd.getValue() == DialogDescriptor.OK_OPTION) {
            if (this.exportDiffProvider == null || ((ExportDiffPanel)this.panel).asFileRadioButton.isSelected()) {
                final File file = new File(this.panel.getOutputFileText());
                Utils.createTask(new Runnable(){

                    public void run() {
                        ExportDiffSupport.this.writeDiffFile(FileUtil.normalizeFile((File)file));
                    }
                }).schedule(0);
            } else {
                final RequestProcessor.Task[] taskArray = new RequestProcessor.Task[1];
                Cancellable cancellable = new Cancellable(){

                    public boolean cancel() {
                        if (taskArray[0] != null) {
                            return taskArray[0].cancel();
                        }
                        return true;
                    }
                };
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Attaching"), (Cancellable)cancellable);
                progressHandle.start();
                taskArray[0] = Utils.createTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            File file;
                            try {
                                file = File.createTempFile("vcs-diff", ".patch");
                            }
                            catch (IOException iOException) {
                                progressHandle.finish();
                                return;
                            }
                            file.deleteOnExit();
                            ExportDiffSupport.this.writeDiffFile(file);
                            ExportDiffSupport.this.exportDiffProvider.handleDiffFile(file);
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                });
                taskArray[0].schedule(0);
            }
        }
    }

    public abstract void writeDiffFile(File var1);

    private void onChooseFile(File file) {
        JFileChooser jFileChooser = this.createFileChooser(file);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jFileChooser, NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        dialogDescriptor.setOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setVisible(true);
    }

    private JFileChooser createFileChooser(File file) {
        final AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ExportDiffSupport.class, (String)"ACSD_Export"));
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.setCurrentDirectory(file);
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3002");
            }
        });
        accessibleJFileChooser.setDialogType(1);
        accessibleJFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffSupport.class, (String)"MNE_Export_ExportAction").charAt(0));
        accessibleJFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    File file;
                    File file2 = accessibleJFileChooser.getSelectedFile();
                    String string2 = file2.getName();
                    boolean bl = false;
                    bl |= string2.endsWith(".diff");
                    bl |= string2.endsWith(".dif");
                    if (!(bl |= string2.endsWith(".patch"))) {
                        file = file2.getParentFile();
                        file2 = new File(file, string2 + ".patch");
                    }
                    if (file2.exists()) {
                        file = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3005", (Object)file2.getAbsolutePath()));
                        file.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
                        if (!file.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    ExportDiffSupport.this.preferences.put("ExportDiff.saveFolder", file2.getParent());
                    ExportDiffSupport.this.panel.setOutputFileText(file2.getAbsolutePath());
                } else {
                    ExportDiffSupport.this.dd.setValue(null);
                }
                if (ExportDiffSupport.this.dialog != null) {
                    ExportDiffSupport.this.dialog.dispose();
                }
            }
        });
        return accessibleJFileChooser;
    }

    public static abstract class AbstractExportDiffPanel
    extends JPanel {
        public abstract String getOutputFileText();

        public abstract void setOutputFileText(String var1);

        public abstract void addOutputFileTextDocumentListener(DocumentListener var1);

        public abstract void addBrowseActionListener(ActionListener var1);

        public boolean isFileOutputSelected() {
            return true;
        }
    }

    public static abstract class ExportDiffProvider {
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private static final String EVENT_DATA_CHANGED = "ExportDiff.data.changed";

        protected abstract void setContext(File[] var1);

        public abstract void handleDiffFile(File var1);

        public abstract JComponent createComponent();

        public abstract boolean isValid();

        protected void fireDataChanged() {
            this.support.firePropertyChange(EVENT_DATA_CHANGED, null, null);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }
}

