/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfStatementList {
    public long total_length;
    public int version;
    public long prologue_length;
    public int minimum_instruction_length;
    public int default_is_stmt;
    public int line_base;
    public int line_range;
    public int opcode_base;
    public long[] standard_opcode_lengths;
    public ArrayList<String> includeDirs = new ArrayList();
    public ArrayList<FileEntry> fileEntries = new ArrayList();
    private long offset;

    public DwarfStatementList(long l) {
        this.offset = l;
    }

    public ArrayList<String> getIncludeDirectories() {
        return this.includeDirs;
    }

    public ArrayList<String> getFilePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= this.fileEntries.size(); ++i) {
            String string = this.getFilePath(i);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList<FileEntry> getFileEntries() {
        return this.fileEntries;
    }

    public void dump(PrintStream printStream) {
        int n;
        printStream.printf("\nPrologue Statement List (offset = %d [0x%08x]):\n\n", this.offset, this.offset);
        printStream.printf("  %-28s %s\n", "Length:", this.total_length);
        printStream.printf("  %-28s %s\n", "DWARF Version:", this.version);
        printStream.printf("  %-28s %s\n", "Prologue Length:", this.prologue_length);
        printStream.printf("  %-28s %s\n", "Minimum Instruction Length:", this.minimum_instruction_length);
        printStream.printf("  %-28s %s\n", "Initial value of 'is_stmt':", this.default_is_stmt);
        printStream.printf("  %-28s %s\n", "Line Base:", this.line_base);
        printStream.printf("  %-28s %s\n", "Line Range:", this.line_range);
        printStream.printf("  %-28s %s\n", "Opcode Base:", this.opcode_base);
        printStream.println("\n Opcodes:");
        for (n = 0; n < this.standard_opcode_lengths.length; ++n) {
            printStream.printf("  Opcode %d has %d args\n", n + 1, this.standard_opcode_lengths[n]);
        }
        printStream.println("\n The Directory Table:\n");
        n = 0;
        printStream.println(" Entry Path");
        for (String object : this.includeDirs) {
            printStream.printf(" %-6d%s\n", ++n, object);
        }
        printStream.println("\n The File Name Table:\n");
        printStream.println(" Entry Dir   Time  Size  Name");
        n = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            printStream.printf(" %-6d%-6d%-6d%-6d%s\n", ++n, fileEntry.dirIndex, fileEntry.modifiedTime, fileEntry.fileSize, fileEntry.fileName);
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }

    public int getDirectoryIndex(String string) {
        int n = 0;
        if (string == null) {
            return 0;
        }
        for (String string2 : this.includeDirs) {
            ++n;
            if (!string2.equals(string)) continue;
            return n;
        }
        return 0;
    }

    public int getFileEntryIdx(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        String string3 = file.getName();
        return this.getFileEntryIdx(this.getDirectoryIndex(string2), string3);
    }

    private int getFileEntryIdx(int n, String string) {
        int n2 = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            ++n2;
            if (fileEntry.dirIndex != n || !fileEntry.fileName.equals(string)) continue;
            return n2;
        }
        return 0;
    }

    public String getFilePath(int n) {
        FileEntry fileEntry = this.fileEntries.get(n - 1);
        if (fileEntry == null || fileEntry.fileName.equals("<internal>") || fileEntry.fileName.equals("<built-in>")) {
            return null;
        }
        String string = fileEntry.dirIndex == 0 ? "." + File.separator + fileEntry.fileName : this.includeDirs.get(fileEntry.dirIndex - 1) + File.separator + fileEntry.fileName;
        return string;
    }

    public ArrayList<String> getPathsForFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = File.separator + string;
        StringBuilder stringBuilder = new StringBuilder(100);
        for (FileEntry fileEntry : this.fileEntries) {
            if (fileEntry.fileName.equals(string)) {
                String string3 = fileEntry.dirIndex == 0 ? "." : this.includeDirs.get(fileEntry.dirIndex - 1);
                arrayList.add(string3);
                continue;
            }
            if (!fileEntry.fileName.endsWith(string2)) continue;
            stringBuilder.setLength(0);
            stringBuilder.append(fileEntry.dirIndex == 0 ? "." : this.includeDirs.get(fileEntry.dirIndex - 1));
            stringBuilder.append(File.separator);
            stringBuilder.append(fileEntry.fileName.substring(0, fileEntry.fileName.length() - string.length() - 1));
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

