/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfMacinfoTable {
    private long baseSourceTableOffset = -1L;
    private long fileSourceTableOffset = -1L;
    private DwarfMacroInfoSection section;
    ArrayList<DwarfMacinfoEntry> baseSourceTable = new ArrayList();
    ArrayList<DwarfMacinfoEntry> fileSourceTable = new ArrayList();
    private boolean baseSourceTableRead;
    private boolean fileSourceTableRead;

    public DwarfMacinfoTable(DwarfMacroInfoSection dwarfMacroInfoSection, long l) {
        this.section = dwarfMacroInfoSection;
        this.baseSourceTableRead = false;
        this.fileSourceTableRead = false;
        this.baseSourceTableOffset = this.fileSourceTableOffset = l;
    }

    public void addEntry(DwarfMacinfoEntry dwarfMacinfoEntry) {
        if (dwarfMacinfoEntry.fileIdx == -1) {
            this.baseSourceTable.add(dwarfMacinfoEntry);
        } else {
            this.fileSourceTable.add(dwarfMacinfoEntry);
        }
    }

    private ArrayList<DwarfMacinfoEntry> getBaseSourceTable() {
        if (this.baseSourceTableRead) {
            return this.baseSourceTable;
        }
        try {
            this.readBaseSourceTable();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.baseSourceTable;
    }

    private ArrayList<DwarfMacinfoEntry> getFileSourceTable() {
        if (this.fileSourceTableRead) {
            return this.fileSourceTable;
        }
        try {
            this.readFileSourceTable();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.fileSourceTable;
    }

    private void readBaseSourceTable() throws IOException {
        long l = this.section.readMacinfoTable(this, this.baseSourceTableOffset, true);
        this.fileSourceTableOffset = this.baseSourceTableOffset + l;
        this.baseSourceTableRead = true;
    }

    private void readFileSourceTable() throws IOException {
        this.section.readMacinfoTable(this, this.fileSourceTableOffset, false);
        this.fileSourceTableRead = true;
    }

    public ArrayList<DwarfMacinfoEntry> getCommandLineMarcos() {
        ArrayList<DwarfMacinfoEntry> arrayList = this.getBaseSourceTable();
        int n = arrayList.size();
        if (n == 0 || arrayList.get((int)0).lineNum == 0) {
            return arrayList;
        }
        ArrayList<DwarfMacinfoEntry> arrayList2 = new ArrayList<DwarfMacinfoEntry>();
        int n2 = 0;
        int n3 = arrayList.get((int)0).lineNum;
        int n4 = -1;
        int n5 = 0;
        while (n3 > n4 && n2 < n) {
            n4 = n3;
            if (n2 == n - 1) {
                return arrayList2;
            }
            n3 = arrayList.get((int)(++n2)).lineNum;
            ++n5;
        }
        if (n5 < 10 && n3 == 1) {
            n2 = 0;
            DwarfMacinfoEntry dwarfMacinfoEntry = arrayList.get(n2);
            do {
                arrayList2.add(dwarfMacinfoEntry);
                n3 = dwarfMacinfoEntry.lineNum;
                if (++n2 >= n) break;
                dwarfMacinfoEntry = arrayList.get(n2);
            } while (dwarfMacinfoEntry.lineNum == 1);
            return arrayList2;
        }
        DwarfMacinfoEntry dwarfMacinfoEntry = arrayList.get(n2);
        do {
            arrayList2.add(dwarfMacinfoEntry);
            n3 = dwarfMacinfoEntry.lineNum;
            if (++n2 >= n) break;
            dwarfMacinfoEntry = arrayList.get(n2);
        } while (dwarfMacinfoEntry.lineNum - n3 == 1);
        return arrayList2;
    }

    public ArrayList<String> getCommandLineDefines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<DwarfMacinfoEntry> arrayList2 = this.getCommandLineMarcos();
        for (DwarfMacinfoEntry dwarfMacinfoEntry : arrayList2) {
            arrayList.add(dwarfMacinfoEntry.definition.replaceFirst(" ", "="));
        }
        return arrayList;
    }

    public ArrayList<DwarfMacinfoEntry> getMacros(int n) {
        ArrayList<DwarfMacinfoEntry> arrayList = new ArrayList<DwarfMacinfoEntry>();
        for (DwarfMacinfoEntry dwarfMacinfoEntry : this.getFileSourceTable()) {
            if (dwarfMacinfoEntry.fileIdx != n || !dwarfMacinfoEntry.type.equals((Object)MACINFO.DW_MACINFO_define) && !dwarfMacinfoEntry.type.equals((Object)MACINFO.DW_MACINFO_undef)) continue;
            arrayList.add(dwarfMacinfoEntry);
        }
        return arrayList;
    }

    public void dump(PrintStream printStream) {
        printStream.printf("\nMACRO Table (offset = %d [0x%08x]):\n\n", this.baseSourceTableOffset, this.baseSourceTableOffset);
        for (DwarfMacinfoEntry dwarfMacinfoEntry : this.getBaseSourceTable()) {
            dwarfMacinfoEntry.dump(printStream);
        }
        for (DwarfMacinfoEntry dwarfMacinfoEntry : this.getFileSourceTable()) {
            dwarfMacinfoEntry.dump(printStream);
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }
}

