/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.FileMagic;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.MemberHeader;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.trace.TraceDwarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dwarf {
    private DwarfReader dwarfReader;
    private List<MemberHeader> offsets;
    private FileMagic magic;
    private String fileName;
    private final Mode mode;

    public Dwarf(String string) throws FileNotFoundException, WrongFileFormatException, IOException {
        if (TraceDwarf.TRACED) {
            System.out.println("\n**** Dwarfing " + string + "\n");
        }
        this.fileName = string;
        this.magic = new FileMagic(string);
        if (this.magic.getMagic() == Magic.Arch) {
            this.skipFirstHeader(this.magic.getReader());
            this.offsets = this.getObjectTable(this.magic.getReader());
            if (this.offsets.size() == 0) {
                throw new WrongFileFormatException("Not an ELF file");
            }
            this.mode = Mode.Archive;
        } else {
            this.dwarfReader = new DwarfReader(string, this.magic.getReader(), this.magic.getMagic(), 0L, this.magic.getReader().length());
            this.mode = this.dwarfReader.getLinkedObjectFiles().size() > 0 ? Mode.MachoLOF : Mode.Normal;
        }
    }

    private void skipFirstHeader(RandomAccessFile randomAccessFile) throws IOException {
        byte by;
        randomAccessFile.seek(8L);
        byte[] byArray = new byte[60];
        randomAccessFile.readFully(byArray);
        int n = 0;
        for (int i = 0; i < 10 && (by = byArray[i + 48]) != 32; ++i) {
            n *= 10;
            n += by - 48;
        }
        randomAccessFile.skipBytes(n);
    }

    private List<MemberHeader> getObjectTable(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[60];
        ArrayList<MemberHeader> arrayList = new ArrayList<MemberHeader>();
        while (randomAccessFile.getFilePointer() + 60L < randomAccessFile.length()) {
            randomAccessFile.readFully(byArray);
            int n = this.readNumber(byArray, 48);
            int n2 = 0;
            if (byArray[0] == 47 && byArray[1] == 47) {
                randomAccessFile.skipBytes(n);
                continue;
            }
            if (byArray[0] == 35 && byArray[1] == 49 && byArray[2] == 47) {
                n2 = this.readNumber(byArray, 3);
                randomAccessFile.skipBytes(n2);
            } else if (byArray[0] == 10) break;
            long l = randomAccessFile.getFilePointer();
            byte[] byArray2 = new byte[8];
            randomAccessFile.readFully(byArray2);
            if (FileMagic.isElfMagic(byArray2) || FileMagic.isCoffMagic(byArray2) || FileMagic.isMachoMagic(byArray2)) {
                arrayList.add(new MemberHeader(l, n));
            }
            randomAccessFile.skipBytes(n - 8 - n2);
            if (n % 2 != 1) continue;
            randomAccessFile.skipBytes(1);
        }
        return arrayList;
    }

    private int readNumber(byte[] byArray, int n) {
        byte by;
        int n2 = 0;
        for (int i = 0; i < 10 && (by = byArray[i + n]) != 32; ++i) {
            n2 *= 10;
            n2 += by - 48;
        }
        return n2;
    }

    public void dispose() {
        if (this.magic != null) {
            try {
                this.magic.getReader().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.magic = null;
        }
    }

    public CompilationUnit getCompilationUnit(String string) throws IOException {
        for (CompilationUnit compilationUnit : this.getCompilationUnits()) {
            String string2 = string.substring(string.lastIndexOf(File.separatorChar));
            String string3 = compilationUnit.getSourceFileFullName();
            if (!(string3 = string3.substring(string3.lastIndexOf(File.separatorChar))).equals(string2)) continue;
            return compilationUnit;
        }
        return null;
    }

    public ElfSection getSection(String string) {
        return this.dwarfReader.getSection(string);
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<CompilationUnit> getCompilationUnits() throws IOException {
        if (this.mode == Mode.Archive) {
            return this.getArchiveCompilationUnits(this.magic.getReader());
        }
        if (this.mode == Mode.Normal) {
            return this.getFileCompilationUnits();
        }
        return this.getMachoLOFCompilationUnits();
    }

    private List<CompilationUnit> getFileCompilationUnits() throws IOException {
        DwarfDebugInfoSection dwarfDebugInfoSection = (DwarfDebugInfoSection)this.dwarfReader.getSection(".debug_info");
        List<CompilationUnit> list = null;
        list = dwarfDebugInfoSection != null ? dwarfDebugInfoSection.getCompilationUnits() : new LinkedList<CompilationUnit>();
        return list;
    }

    private List<CompilationUnit> getMachoLOFCompilationUnits() throws IOException {
        LinkedList<CompilationUnit> linkedList = new LinkedList<CompilationUnit>();
        for (String string : this.dwarfReader.getLinkedObjectFiles()) {
            Dwarf dwarf = new Dwarf(string);
            linkedList.addAll(dwarf.getCompilationUnits());
        }
        return linkedList;
    }

    private List<CompilationUnit> getArchiveCompilationUnits(RandomAccessFile randomAccessFile) throws IOException {
        LinkedList<CompilationUnit> linkedList = new LinkedList<CompilationUnit>();
        for (MemberHeader memberHeader : this.offsets) {
            long l = memberHeader.getOffset();
            int n = memberHeader.getLength();
            randomAccessFile.seek(l);
            byte[] byArray = new byte[8];
            randomAccessFile.readFully(byArray);
            if (FileMagic.isElfMagic(byArray)) {
                this.dwarfReader = new DwarfReader(this.fileName, randomAccessFile, Magic.Elf, l, n);
            } else if (FileMagic.isCoffMagic(byArray)) {
                this.dwarfReader = new DwarfReader(this.fileName, randomAccessFile, Magic.Coff, l, n);
            } else if (FileMagic.isMachoMagic(byArray)) {
                this.dwarfReader = new DwarfReader(this.fileName, randomAccessFile, Magic.Macho, l, n);
            }
            linkedList.addAll(this.getFileCompilationUnits());
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        Normal,
        Archive,
        MachoLOF;

    }
}

