/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTableEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfNameLookupTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.FORM;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAbbriviationTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfNameLookupTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfRelaDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnit {
    private DwarfReader reader;
    public long debugInfoSectionOffset;
    public long unit_offset;
    public long unit_length;
    public long unit_total_length;
    public int version;
    public long debug_abbrev_offset;
    public long info_offset;
    public byte address_size;
    public DwarfEntry root = null;
    private DwarfAbbriviationTable abbr_table = null;
    private DwarfStatementList statement_list = null;
    private DwarfMacinfoTable macrosTable = null;
    private DwarfNameLookupTable pubnamesTable = null;
    private long debugInfoOffset;
    private Map<Long, Long> specifications = new HashMap<Long, Long>();
    private Map<Long, DwarfEntry> entries = new HashMap<Long, DwarfEntry>();
    private DwarfRelaDebugInfoSection rela;

    public CompilationUnit(DwarfReader dwarfReader, long l, long l2) throws IOException {
        this.reader = dwarfReader;
        this.debugInfoSectionOffset = l;
        this.unit_offset = l2;
        this.readCompilationUnitHeader();
        this.root = this.getDebugInfo(false);
    }

    public String getProducer() {
        return (String)this.root.getAttributeValue(ATTR.DW_AT_producer);
    }

    public String getCompilationDir() {
        return (String)this.root.getAttributeValue(ATTR.DW_AT_comp_dir);
    }

    public String getSourceFileName() {
        return (String)this.root.getAttributeValue(ATTR.DW_AT_name);
    }

    public String getCommandLine() {
        Object object = this.root.getAttributeValue(ATTR.DW_AT_SUN_command_line);
        return object == null ? null : (String)object;
    }

    public String getSourceFileFullName() {
        String string = null;
        try {
            String string2 = this.getCompilationDir();
            String string3 = this.getSourceFileName();
            if (string3 != null) {
                string = string2 != null ? (string3.startsWith("/") ? new File(string3).getCanonicalPath() : new File(string2 + File.separator + string3).getCanonicalPath()) : new File(string3).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String getSourceFileAbsolutePath() {
        String string = null;
        String string2 = this.getCompilationDir();
        String string3 = this.getSourceFileName();
        string = string2 != null ? (string3.startsWith("/") ? new File(string3).getAbsolutePath() : new File(string2 + File.separator + string3).getAbsolutePath()) : new File(string3).getAbsolutePath();
        return string;
    }

    public String getSourceLanguage() {
        Object object;
        if (this.root != null && (object = this.root.getAttributeValue(ATTR.DW_AT_language)) != null) {
            return object.toString();
        }
        return null;
    }

    public String getType(DwarfEntry dwarfEntry) {
        TAG tAG = dwarfEntry.getKind();
        if (tAG.equals((Object)TAG.DW_TAG_unspecified_parameters)) {
            return "null";
        }
        Integer n = (Integer)dwarfEntry.getAttributeValue(ATTR.DW_AT_type);
        if (n == null) {
            return "void";
        }
        DwarfEntry dwarfEntry2 = this.getEntry(n.intValue());
        TAG tAG2 = dwarfEntry2.getKind();
        if (tAG2.equals((Object)TAG.DW_TAG_base_type)) {
            String string = dwarfEntry2.getName();
            if (string.equals("long unsigned int")) {
                string = "unsigned long";
            } else if (string.equals("long int")) {
                string = "long";
            }
            return string;
        }
        if (tAG2.equals((Object)TAG.DW_TAG_structure_type) || tAG2.equals((Object)TAG.DW_TAG_enumeration_type) || tAG2.equals((Object)TAG.DW_TAG_union_type) || tAG2.equals((Object)TAG.DW_TAG_typedef) || tAG2.equals((Object)TAG.DW_TAG_class_type)) {
            return dwarfEntry2.getName();
        }
        if (tAG2.equals((Object)TAG.DW_TAG_const_type)) {
            Object object = dwarfEntry2.getAttributeValue(ATTR.DW_AT_type);
            if (object == null) {
                return "const void";
            }
            if (object instanceof Integer) {
                Integer n2 = (Integer)dwarfEntry2.getAttributeValue(ATTR.DW_AT_type);
                DwarfEntry dwarfEntry3 = this.getEntry(n2.intValue());
                dwarfEntry2.getKind();
                if (dwarfEntry3.getKind().equals((Object)TAG.DW_TAG_reference_type) || dwarfEntry3.getKind().equals((Object)TAG.DW_TAG_array_type)) {
                    return this.getType(dwarfEntry2);
                }
                if (dwarfEntry3.getKind() == TAG.DW_TAG_pointer_type) {
                    return this.getType(dwarfEntry2) + " const";
                }
                return "const " + this.getType(dwarfEntry2);
            }
        }
        if (tAG2.equals((Object)TAG.DW_TAG_reference_type)) {
            return this.getType(dwarfEntry2) + "&";
        }
        if (tAG2.equals((Object)TAG.DW_TAG_array_type)) {
            return this.getType(dwarfEntry2) + "[]";
        }
        if (tAG2.equals((Object)TAG.DW_TAG_pointer_type) || tAG2.equals((Object)TAG.DW_TAG_ptr_to_member_type)) {
            return this.getType(dwarfEntry2) + "*";
        }
        if (tAG2.equals((Object)TAG.DW_TAG_subroutine_type)) {
            return this.getType(dwarfEntry2);
        }
        if (tAG2.equals((Object)TAG.DW_TAG_volatile_type)) {
            return this.getType(dwarfEntry2);
        }
        if (tAG2.equals((Object)TAG.DW_TAG_union_type)) {
            return this.getType(dwarfEntry2);
        }
        return "<" + (Object)((Object)tAG2) + ">";
    }

    public DwarfEntry getEntry(long l) {
        DwarfEntry dwarfEntry = this.entries.get(l);
        if (dwarfEntry == null) {
            dwarfEntry = this.entryLookup(this.getDebugInfo(true), l);
            this.entries.put(l, dwarfEntry);
        }
        return dwarfEntry;
    }

    public DwarfEntry getDefinition(DwarfEntry dwarfEntry) {
        Long l = this.specifications.get(dwarfEntry.getRefference());
        if (l != null) {
            return this.getEntry(l);
        }
        return null;
    }

    private DwarfEntry entryLookup(DwarfEntry dwarfEntry, long l) {
        if (dwarfEntry == null) {
            return null;
        }
        if (dwarfEntry.getRefference() == l) {
            return dwarfEntry;
        }
        for (DwarfEntry dwarfEntry2 : dwarfEntry.getChildren()) {
            DwarfEntry dwarfEntry3 = this.entryLookup(dwarfEntry2, l);
            if (dwarfEntry3 == null) continue;
            return dwarfEntry3;
        }
        return null;
    }

    public DwarfEntry getRoot() {
        return this.root;
    }

    public DwarfEntry getTypedefFor(Integer n) {
        for (DwarfEntry dwarfEntry : this.getDebugInfo(true).getChildren()) {
            Object object;
            if (!dwarfEntry.getKind().equals((Object)TAG.DW_TAG_typedef) || (object = dwarfEntry.getAttributeValue(ATTR.DW_AT_type)) == null || !((Integer)object).equals(n)) continue;
            return dwarfEntry;
        }
        return null;
    }

    public long getUnitTotalLength() {
        return this.unit_total_length;
    }

    private void readCompilationUnitHeader() throws IOException {
        this.reader.seek(this.debugInfoSectionOffset + this.unit_offset);
        this.unit_length = this.reader.readDWlen();
        long l = this.reader.getFilePointer();
        this.unit_total_length = this.unit_length + l - (this.debugInfoSectionOffset + this.unit_offset);
        this.version = this.reader.readShort();
        this.debug_abbrev_offset = this.reader.read3264();
        this.address_size = (byte)(0xFF & this.reader.readByte());
        if (this.address_size != 4 && this.address_size != 8 && this.reader.is64Bit()) {
            this.reader.setFileClass(1);
            this.reader.seek(this.reader.getFilePointer() - 9L);
            this.debug_abbrev_offset = this.reader.read3264();
            this.address_size = (byte)(0xFF & this.reader.readByte());
        }
        this.debugInfoOffset = this.reader.getFilePointer();
        this.reader.setAddressSize(this.address_size);
        DwarfAbbriviationTableSection dwarfAbbriviationTableSection = (DwarfAbbriviationTableSection)this.reader.getSection(".debug_abbrev");
        this.abbr_table = dwarfAbbriviationTableSection.getAbbriviationTable(this.debug_abbrev_offset);
        this.rela = (DwarfRelaDebugInfoSection)this.reader.getSection(".rela.debug_info");
    }

    public DwarfStatementList getStatementList() {
        if (this.statement_list == null) {
            this.initStatementList();
        }
        return this.statement_list;
    }

    public DwarfMacinfoTable getMacrosTable() {
        if (this.macrosTable == null) {
            this.initMacrosTable();
        }
        return this.macrosTable;
    }

    private DwarfNameLookupTable getPubnamesTable() {
        if (this.pubnamesTable == null) {
            this.initPubnamesTable();
        }
        return this.pubnamesTable;
    }

    private DwarfEntry getDebugInfo(boolean bl) {
        if (this.root == null || bl && this.root.getChildren().size() == 0) {
            try {
                long l = this.reader.getFilePointer();
                this.reader.seek(this.debugInfoOffset);
                this.root = this.readEntry(0, bl);
                this.reader.seek(l);
                if (bl) {
                    this.setSpecializations(this.root);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.root;
    }

    private void setSpecializations(DwarfEntry dwarfEntry) {
        Object object = dwarfEntry.getAttributeValue(ATTR.DW_AT_specification);
        if (object instanceof Integer) {
            this.specifications.put((long)((Integer)object), dwarfEntry.getRefference());
        }
        for (DwarfEntry dwarfEntry2 : dwarfEntry.getChildren()) {
            this.setSpecializations(dwarfEntry2);
        }
    }

    private DwarfEntry readEntry(int n, boolean bl) throws IOException {
        long l = this.reader.getFilePointer() - this.debugInfoSectionOffset - this.unit_offset;
        long l2 = this.reader.readUnsignedLEB128();
        if (l2 == 0L) {
            return null;
        }
        DwarfAbbriviationTableEntry dwarfAbbriviationTableEntry = this.abbr_table.getEntry(l2);
        if (dwarfAbbriviationTableEntry == null) {
            return null;
        }
        DwarfEntry dwarfEntry = new DwarfEntry(this, dwarfAbbriviationTableEntry, l, n);
        this.entries.put(l, dwarfEntry);
        for (int i = 0; i < dwarfAbbriviationTableEntry.getAttributesCount(); ++i) {
            DwarfAttribute dwarfAttribute = dwarfAbbriviationTableEntry.getAttribute(i);
            long l3 = this.reader.getFilePointer() - this.debugInfoSectionOffset;
            Long l4 = null;
            if (this.rela != null) {
                l4 = this.rela.getAddend(l3);
            }
            if (l4 != null && dwarfAttribute.valueForm.equals((Object)FORM.DW_FORM_strp)) {
                this.reader.readAttrValue(dwarfAttribute);
                String string = ((StringTableSection)this.reader.getSection(".debug_str")).getString(l4);
                dwarfEntry.addValue(string);
                continue;
            }
            dwarfEntry.addValue(this.reader.readAttrValue(dwarfAttribute));
        }
        if (bl && dwarfEntry.hasChildren()) {
            DwarfEntry dwarfEntry2;
            while ((dwarfEntry2 = this.readEntry(n + 1, true)) != null) {
                dwarfEntry.addChild(dwarfEntry2);
            }
        }
        return dwarfEntry;
    }

    private void initStatementList() {
        DwarfLineInfoSection dwarfLineInfoSection = (DwarfLineInfoSection)this.reader.getSection(".debug_line");
        if (this.root == null) {
            return;
        }
        Number number = (Number)this.root.getAttributeValue(ATTR.DW_AT_stmt_list);
        if (number != null) {
            this.statement_list = dwarfLineInfoSection.getStatementList(number.longValue());
        }
    }

    private void initMacrosTable() {
        DwarfMacroInfoSection dwarfMacroInfoSection = (DwarfMacroInfoSection)this.reader.getSection(".debug_macinfo");
        if (dwarfMacroInfoSection == null) {
            return;
        }
        Integer n = (Integer)this.root.getAttributeValue(ATTR.DW_AT_macro_info);
        if (n == null) {
            return;
        }
        this.macrosTable = dwarfMacroInfoSection.getMacinfoTable(n.intValue());
    }

    private void initPubnamesTable() {
        DwarfNameLookupTableSection dwarfNameLookupTableSection = (DwarfNameLookupTableSection)this.reader.getSection(".debug_pubnames");
        if (dwarfNameLookupTableSection != null) {
            this.pubnamesTable = dwarfNameLookupTableSection.getNameLookupTableFor(this.unit_offset);
        }
    }

    public List<DwarfEntry> getDeclarations() {
        return this.getDeclarations(true);
    }

    public List<DwarfEntry> getEntries() {
        this.getPubnamesTable();
        return this.getDebugInfo(true).getChildren();
    }

    public List<DwarfEntry> getDeclarations(boolean bl) {
        boolean bl2 = false;
        int n = 0;
        this.getPubnamesTable();
        ArrayList<DwarfEntry> arrayList = new ArrayList<DwarfEntry>();
        if (bl) {
            n = this.getStatementList().getFileEntryIdx(this.getSourceFileName());
        }
        for (DwarfEntry dwarfEntry : this.getEntries()) {
            if (bl && (!bl || !dwarfEntry.isEntryDefinedInFile(n)) || dwarfEntry.hasAbastractOrigin()) continue;
            String string = dwarfEntry.getQualifiedName();
            if (string != null && !string.startsWith("_GLOBAL__")) {
                arrayList.add(dwarfEntry);
                continue;
            }
            if (!bl2) continue;
            System.out.println("Exclude declaration: " + dwarfEntry.getDeclaration());
        }
        return arrayList;
    }

    public void dump(PrintStream printStream) {
        DwarfMacinfoTable dwarfMacinfoTable;
        if (this.root == null) {
            printStream.println("*** No compilation units for " + this.reader.getFileName());
            return;
        }
        printStream.println("*** " + this.getSourceFileFullName() + " ***");
        printStream.println("  Compilation Unit @ offset " + Long.toHexString(this.unit_offset) + ":");
        printStream.println("    Length: " + this.unit_length);
        printStream.println("    Version: " + this.version);
        printStream.println("    Abbrev Offset: " + this.debug_abbrev_offset);
        printStream.println("    Pointer Size: " + this.address_size);
        this.getPubnamesTable();
        this.getDebugInfo(true).dump(printStream);
        DwarfStatementList dwarfStatementList = this.getStatementList();
        if (dwarfStatementList != null) {
            dwarfStatementList.dump(printStream);
        }
        if (this.pubnamesTable != null) {
            this.pubnamesTable.dump(printStream);
        }
        if ((dwarfMacinfoTable = this.getMacrosTable()) != null) {
            dwarfMacinfoTable.dump(printStream);
        }
        printStream.println();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }
}

