/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactoryManager;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmFileTaskFactory {
    private final Map<FileObject, TaskData> fobj2task = new HashMap<FileObject, TaskData>();
    private final ProgressListener progressListener = new ProgressListener();
    private final ModelListener modelListener = new ModelListener();
    public static final String USE_OWN_CARET_POSITION = "use-own-caret-position";
    private static final int IMMEDIATELY = 0;
    private static RequestProcessor WORKER = new RequestProcessor("CsmFileTaskFactory", 1);
    private static RequestProcessor HIGH_PRIORITY_WORKER = new RequestProcessor("CsmHighPriorityFileTaskFactory", 1);
    private static RequestProcessor DECISION_WORKER = new RequestProcessor("CsmDecisionFileTaskFactory", 1);

    protected CsmFileTaskFactory() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.progressListener);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.modelListener);
    }

    protected abstract PhaseRunner createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected abstract int taskDelay();

    protected abstract int rescheduleDelay();

    protected final void fileObjectsChanged() {
        final HashSet<FileObject> hashSet = new HashSet<FileObject>(this.getFileObjects());
        final long l = Math.round(100.0 * Math.random());
        final String string = this.getClass().getName();
        if (OpenedEditors.SHOW_TIME) {
            System.err.println("CsmFileTaskFactory: POST worker " + l);
        }
        DECISION_WORKER.post(new Runnable(){

            public void run() {
                long l2 = System.currentTimeMillis();
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: RUN worker " + l + " [" + string + "]");
                }
                CsmFileTaskFactory.this.stateChangedImpl(hashSet);
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: DONE worker " + l + " after " + (System.currentTimeMillis() - l2) + "ms.");
                }
            }
        });
    }

    private boolean checkMimeType(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        return MIMENames.isHeaderOrCppOrC((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(Collection<FileObject> collection) {
        Object object;
        Object object22;
        CsmFile csmFile;
        HashMap<FileObject, TaskData> hashMap = new HashMap<FileObject, TaskData>();
        HashMap<FileObject, TaskData> hashMap2 = new HashMap<FileObject, TaskData>();
        Iterator iterator = this;
        synchronized (iterator) {
            Object object3;
            Object object4;
            CsmFile csmFile2;
            ArrayList<FileObject> entry = new ArrayList<FileObject>(collection);
            csmFile = new ArrayList(this.fobj2task.keySet());
            entry.removeAll(this.fobj2task.keySet());
            csmFile.removeAll(collection);
            for (Object object22 : csmFile) {
                hashMap.put((FileObject)object22, this.fobj2task.remove(object22));
            }
            object = new ArrayList<FileObject>(this.fobj2task.keySet());
            object22 = object.iterator();
            while (object22.hasNext()) {
                FileObject fileObject = (FileObject)object22.next();
                if (fileObject == null || !fileObject.isValid() || !this.checkMimeType(fileObject) || (csmFile2 = CsmFileTaskFactory.getCsmFile(fileObject, true)) == null || csmFile2.equals(((TaskData)(object4 = this.fobj2task.get(fileObject))).file)) continue;
                hashMap.put(fileObject, this.fobj2task.remove(fileObject));
                object3 = this.createTask(fileObject);
                TaskData taskData = new TaskData((PhaseRunner)object3, csmFile2);
                hashMap2.put(fileObject, taskData);
                this.fobj2task.put(fileObject, taskData);
            }
            for (FileObject fileObject : entry) {
                if (fileObject == null || !fileObject.isValid() || !this.checkMimeType(fileObject) || (csmFile2 = CsmFileTaskFactory.getCsmFile(fileObject, true)) == null) continue;
                object4 = this.createTask(fileObject);
                object3 = new TaskData((PhaseRunner)object4, csmFile2);
                hashMap2.put(fileObject, (TaskData)object3);
                this.fobj2task.put(fileObject, (TaskData)object3);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            csmFile = CsmFileTaskFactory.getCsmFile((FileObject)entry.getKey(), false);
            if (csmFile != null && OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: removing " + csmFile.getAbsolutePath());
            }
            if (entry != null && entry.getValue() != null) {
                object = ((TaskData)entry.getValue()).runner;
                object22 = ((TaskData)entry.getValue()).task;
                object.cancel();
                if (object22 != null) {
                    object22.cancel();
                }
                this.post((TaskData)entry.getValue(), (FileObject)entry.getKey(), PhaseRunner.Phase.CLEANUP, 0);
            }
            if (csmFile == null) continue;
            CsmStandaloneFileProvider.getDefault().notifyClosed(csmFile);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            csmFile = CsmFileTaskFactory.getCsmFile((FileObject)entry.getKey(), false);
            if (csmFile == null) continue;
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: adding " + (Object)((Object)(csmFile.isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT)) + " " + ((TaskData)entry.getValue()).runner.toString() + " " + csmFile.getAbsolutePath());
            }
            this.post((TaskData)entry.getValue(), (FileObject)entry.getKey(), csmFile.isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT, this.taskDelay());
        }
    }

    private static CsmFile getCsmFile(FileObject fileObject, boolean bl) {
        CsmFile csmFile = null;
        Document document = CsmUtilities.getDocument((FileObject)fileObject);
        if (document != null) {
            csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false);
        }
        if (csmFile == null) {
            csmFile = CsmUtilities.getCsmFile((FileObject)fileObject, (boolean)false);
        }
        if (bl && csmFile == null) {
            csmFile = CsmStandaloneFileProvider.getDefault().getCsmFile(fileObject);
        }
        return csmFile;
    }

    public final synchronized void reschedule(FileObject fileObject) throws IllegalArgumentException {
        this.runTask(fileObject, PhaseRunner.Phase.PARSED, this.rescheduleDelay(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAllTasks(PhaseRunner.Phase phase, int n) {
        Set<FileObject> set;
        CsmFileTaskFactory csmFileTaskFactory = this;
        synchronized (csmFileTaskFactory) {
            set = this.fobj2task.keySet();
        }
        for (FileObject fileObject : set) {
            this.runTask(fileObject, phase, n, false);
        }
    }

    private final void runTask(FileObject fileObject, PhaseRunner.Phase phase, int n, boolean bl) {
        ArrayList<TaskData> arrayList = new ArrayList<TaskData>();
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        TaskData taskData = this.fobj2task.get(fileObject);
        if (taskData != null) {
            arrayList.add(taskData);
            arrayList2.add(fileObject);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            FileObject fileObject2;
            Document document;
            Object object;
            TaskData taskData2 = (TaskData)arrayList.get(i);
            FileObject fileObject3 = (FileObject)arrayList2.get(i);
            taskData2.runner.cancel();
            if (taskData2.task != null) {
                taskData2.task.cancel();
            }
            if (!taskData2.runner.isValid()) {
                object = this.createTask(fileObject3);
                assert (object.isValid());
                taskData2 = new TaskData((PhaseRunner)object, CsmFileTaskFactory.getCsmFile(fileObject3, false));
                this.fobj2task.put(fileObject3, taskData2);
            }
            if ((object = CsmUtilities.getDocument((FileObject)fileObject3)) != null && (document = (Document)object.getProperty(Document.class)) != null && (fileObject2 = CsmUtilities.getFileObject((Document)document)) != null) {
                PhaseRunner phaseRunner = this.createTask(fileObject2);
                TaskData taskData3 = new TaskData(phaseRunner, CsmFileTaskFactory.getCsmFile(fileObject2, false));
                document.putProperty(USE_OWN_CARET_POSITION, false);
                object.putProperty(USE_OWN_CARET_POSITION, true);
                if (taskData3 != null) {
                    this.post(taskData3, fileObject2, phase, n);
                }
            }
            this.post(taskData2, fileObject3, phase, n);
        }
    }

    private final void post(TaskData taskData, FileObject fileObject, PhaseRunner.Phase phase, int n) {
        if (taskData.runner.isHighPriority()) {
            taskData.task = CsmFileTaskFactory.HIGH_PRIORITY_WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(taskData.runner, phase), fileObject), n, 5);
        } else {
            taskData.task = CsmFileTaskFactory.WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(taskData.runner, phase), fileObject), n);
        }
    }

    private static final Runnable getRunnable(final PhaseRunner phaseRunner, final PhaseRunner.Phase phase) {
        return new Runnable(){

            public void run() {
                phaseRunner.run(phase);
            }
        };
    }

    protected static PhaseRunner lazyRunner() {
        return new PhaseRunner(){

            public void run(PhaseRunner.Phase phase) {
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
            }

            public boolean isHighPriority() {
                return false;
            }
        };
    }

    static {
        CsmFileTaskFactoryManager.ACCESSOR = new CsmFileTaskFactoryManager.Accessor(){

            public void fireChangeEvent(CsmFileTaskFactory csmFileTaskFactory) {
                csmFileTaskFactory.fileObjectsChanged();
            }
        };
    }

    private static final class CsmSafeRunnable
    implements Runnable {
        private FileObject fileObject;
        private Runnable run;

        public CsmSafeRunnable(Runnable runnable, FileObject fileObject) {
            this.run = runnable;
            this.fileObject = fileObject;
        }

        public void run() {
            CsmFile csmFile = CsmFileTaskFactory.getCsmFile(this.fileObject, false);
            if (csmFile != null && csmFile.isValid()) {
                this.run.run();
            }
        }
    }

    private static final class TaskData {
        private final PhaseRunner runner;
        private final CsmFile file;
        private RequestProcessor.Task task;

        private TaskData(PhaseRunner phaseRunner, CsmFile csmFile) {
            this.runner = phaseRunner;
            this.file = csmFile;
        }
    }

    public static interface PhaseRunner {
        public void run(Phase var1);

        public boolean isValid();

        public void cancel();

        public boolean isHighPriority();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Phase {
            INIT,
            PARSING_STARTED,
            PARSED,
            PROJECT_PARSED,
            CLEANUP;

        }
    }

    private class ModelListener
    implements CsmModelListener {
        private ModelListener() {
        }

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                Document document;
                FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
                if (fileObject == null || CsmFileTaskFactory.this.fobj2task.get(fileObject) == null || (document = CsmUtilities.getDocument((FileObject)fileObject)) == null) continue;
                ModelListener modelListener = this;
                synchronized (modelListener) {
                    CsmFileTaskFactory.this.runTask(fileObject, PhaseRunner.Phase.CLEANUP, 0, true);
                    CsmFileTaskFactory.this.fobj2task.put(fileObject, new TaskData(CsmFileTaskFactory.lazyRunner(), CsmUtilities.getCsmFile((Document)document, (boolean)false)));
                }
            }
            if (!csmChangeEvent.getNewFiles().isEmpty()) {
                CsmFileTaskFactory.this.fileObjectsChanged();
            }
        }
    }

    private class ProgressListener
    extends CsmProgressAdapter {
        private ProgressListener() {
        }

        public void fileParsingFinished(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(CsmUtilities.getFileObject((CsmFile)csmFile), PhaseRunner.Phase.PARSED, 0, true);
        }

        public void fileParsingStarted(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(CsmUtilities.getFileObject((CsmFile)csmFile), PhaseRunner.Phase.PARSING_STARTED, 0, true);
        }

        public void projectParsingFinished(CsmProject csmProject) {
            CsmFileTaskFactory.this.runAllTasks(PhaseRunner.Phase.PROJECT_PARSED, 0);
        }
    }
}

