/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.AntiLoop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmInheritanceUtilities {
    private static final int PRIVATE = 1;
    private static final int PROTECTED = 2;
    private static final int PUBLIC = 4;
    private static final int NONE = 8;
    public static final CsmVisibility MAX_VISIBILITY = CsmVisibility.PRIVATE;

    private CsmInheritanceUtilities() {
    }

    private static int visToInt(CsmVisibility csmVisibility) {
        if (csmVisibility == CsmVisibility.NONE) {
            return 8;
        }
        if (csmVisibility == CsmVisibility.PRIVATE) {
            return 1;
        }
        if (csmVisibility == CsmVisibility.PROTECTED) {
            return 2;
        }
        assert (csmVisibility == CsmVisibility.PUBLIC);
        return 4;
    }

    private static CsmVisibility intToVis(int n) {
        switch (n) {
            case 8: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PRIVATE;
            }
            case 2: {
                return CsmVisibility.PROTECTED;
            }
        }
        assert (n == 4);
        return CsmVisibility.PUBLIC;
    }

    public static boolean matchVisibility(CsmMember csmMember, CsmVisibility csmVisibility) {
        assert (csmMember.getVisibility() != null) : "can't be null visibility";
        return CsmInheritanceUtilities.matchVisibility(csmMember.getVisibility(), csmVisibility);
    }

    private static boolean matchVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        assert (csmVisibility != null && csmVisibility2 != null);
        if (csmVisibility2 == CsmVisibility.NONE) {
            return false;
        }
        int n = CsmInheritanceUtilities.visToInt(csmVisibility);
        int n2 = CsmInheritanceUtilities.visToInt(csmVisibility2);
        return n2 <= n;
    }

    private static CsmVisibility getInheritanceVisibility(CsmVisibility csmVisibility) {
        return CsmVisibility.PROTECTED;
    }

    private static CsmVisibility getExtInheritanceVisibility(CsmVisibility csmVisibility) {
        if (csmVisibility == CsmVisibility.PUBLIC) {
            return CsmVisibility.PUBLIC;
        }
        return CsmVisibility.NONE;
    }

    private static CsmVisibility getChildInheritanceVisibility(CsmVisibility csmVisibility) {
        if (csmVisibility == CsmVisibility.PUBLIC || csmVisibility == CsmVisibility.PROTECTED) {
            return CsmVisibility.PROTECTED;
        }
        return CsmVisibility.NONE;
    }

    public static CsmVisibility mergeInheritedVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        return CsmInheritanceUtilities.getMinVisibility(csmVisibility, CsmInheritanceUtilities.getInheritanceVisibility(csmVisibility2));
    }

    public static CsmVisibility mergeExtInheritedVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        return CsmInheritanceUtilities.getMinVisibility(csmVisibility, CsmInheritanceUtilities.getExtInheritanceVisibility(csmVisibility2));
    }

    public static CsmVisibility mergeChildInheritanceVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        return CsmInheritanceUtilities.getMinVisibility(csmVisibility, CsmInheritanceUtilities.getChildInheritanceVisibility(csmVisibility2));
    }

    private static CsmVisibility getMinVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        assert (csmVisibility != null && csmVisibility2 != null);
        int n = CsmInheritanceUtilities.visToInt(csmVisibility);
        int n2 = CsmInheritanceUtilities.visToInt(csmVisibility2);
        int n3 = Math.max(n, n2);
        return CsmInheritanceUtilities.intToVis(n3);
    }

    private static CsmVisibility getMaxVisibility(CsmVisibility csmVisibility, CsmVisibility csmVisibility2) {
        assert (csmVisibility != null && csmVisibility2 != null);
        int n = CsmInheritanceUtilities.visToInt(csmVisibility);
        int n2 = CsmInheritanceUtilities.visToInt(csmVisibility2);
        int n3 = Math.min(n, n2);
        return CsmInheritanceUtilities.intToVis(n3);
    }

    public static CsmVisibility getContextVisibility(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return CsmInheritanceUtilities.getContextVisibility(csmClass, csmOffsetableDeclaration, CsmVisibility.PUBLIC, false);
    }

    public static CsmVisibility getContextVisibility(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmVisibility csmVisibility, boolean bl) {
        return CsmInheritanceUtilities.getContextVisibilityInfo((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)csmVisibility, (boolean)bl).visibility;
    }

    public static ContextVisibilityInfo getContextVisibilityInfo(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmVisibility csmVisibility, boolean bl) {
        assert (csmClass != null);
        CsmClass csmClass2 = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)csmOffsetableDeclaration);
        if (CsmInheritanceUtilities.areEqualClasses(csmClass, csmClass2)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, false);
        }
        if (CsmFriendResolver.getDefault().isFriend(csmOffsetableDeclaration, csmClass)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, true);
        }
        if (CsmInheritanceUtilities.isNestedClass(csmClass2, csmClass)) {
            return new ContextVisibilityInfo(MAX_VISIBILITY, false);
        }
        if (csmClass2 == null || !bl) {
            return new ContextVisibilityInfo(csmVisibility, false);
        }
        List<CsmInheritance> list = CsmInheritanceUtilities.findInheritanceChain(csmClass2, csmClass);
        if (list != null) {
            assert (list.size() > 0);
            CsmVisibility csmVisibility2 = CsmVisibility.PROTECTED;
            for (int i = 0; i < list.size(); ++i) {
                CsmInheritance csmInheritance = list.get(i);
                csmVisibility2 = i == 0 ? CsmInheritanceUtilities.mergeInheritedVisibility(csmVisibility2, csmInheritance.getVisibility()) : CsmInheritanceUtilities.mergeChildInheritanceVisibility(csmVisibility2, csmInheritance.getVisibility());
            }
            return new ContextVisibilityInfo(csmVisibility2, false);
        }
        return new ContextVisibilityInfo(csmVisibility, false);
    }

    private static List<CsmInheritance> findInheritanceChain(CsmClass csmClass, CsmClass csmClass2) {
        ArrayList<CsmInheritance> arrayList = new ArrayList<CsmInheritance>();
        AntiLoop antiLoop = new AntiLoop();
        if (CsmInheritanceUtilities.findInheritanceChain(csmClass, csmClass2, arrayList, antiLoop)) {
            return arrayList;
        }
        return null;
    }

    public static boolean isAssignableFrom(CsmClass csmClass, CsmClass csmClass2) {
        assert (csmClass2 != null);
        if (CsmInheritanceUtilities.areEqualClasses(csmClass2, csmClass)) {
            return true;
        }
        List<CsmInheritance> list = CsmInheritanceUtilities.findInheritanceChain(csmClass, csmClass2);
        return list != null;
    }

    private static boolean findInheritanceChain(CsmClass csmClass, CsmClass csmClass2, List<CsmInheritance> list, AntiLoop antiLoop) {
        if (csmClass == null || !antiLoop.add((CsmClassifier)csmClass)) {
            return false;
        }
        Collection collection = csmClass.getBaseClasses();
        if (collection == null || collection.size() == 0) {
            return false;
        }
        CsmInheritance csmInheritance = CsmInheritanceUtilities.findDirectInheritance(csmClass, csmClass2);
        if (csmInheritance != null) {
            list.add(csmInheritance);
            return true;
        }
        ArrayList<CsmInheritance> arrayList = null;
        CsmInheritance csmInheritance2 = null;
        for (CsmInheritance csmInheritance3 : collection) {
            ArrayList<CsmInheritance> arrayList2 = new ArrayList<CsmInheritance>();
            if (!CsmInheritanceUtilities.findInheritanceChain(CsmInheritanceUtilities.getCsmClass(csmInheritance3), csmClass2, arrayList2, antiLoop)) continue;
            arrayList = arrayList2;
            csmInheritance2 = csmInheritance3;
            break;
        }
        if (arrayList != null) {
            assert (arrayList.size() > 0);
            list.add(csmInheritance2);
            list.addAll((Collection<CsmInheritance>)arrayList);
            return true;
        }
        return false;
    }

    public static CsmClass getCsmClass(CsmInheritance csmInheritance) {
        CsmClassifier csmClassifier = csmInheritance.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier, (CsmFile)csmInheritance.getContainingFile())))) {
            return (CsmClass)csmClassifier;
        }
        return null;
    }

    private static CsmInheritance findDirectInheritance(CsmClass csmClass, CsmClass csmClass2) {
        assert (csmClass2 != null);
        Collection collection = csmClass.getBaseClasses();
        if (collection != null && collection.size() > 0) {
            for (CsmInheritance csmInheritance : collection) {
                if (!CsmInheritanceUtilities.areEqualClasses(csmClass2, CsmInheritanceUtilities.getCsmClass(csmInheritance))) continue;
                return csmInheritance;
            }
        }
        return null;
    }

    private static boolean areEqualClasses(CsmClass csmClass, CsmClass csmClass2) {
        assert (csmClass != null);
        if (csmClass.equals(csmClass2)) {
            return true;
        }
        if (csmClass2 != null && (CsmKindUtilities.isTemplate((CsmObject)csmClass) || CsmKindUtilities.isTemplateInstantiation((CsmObject)csmClass))) {
            return csmClass.getUniqueName().equals(csmClass2.getUniqueName());
        }
        return false;
    }

    private static boolean isNestedClass(CsmClass csmClass, CsmClass csmClass2) {
        return csmClass != null && csmClass2 != null && ((Object)csmClass.getQualifiedName()).toString().startsWith(((Object)csmClass2.getQualifiedName()).toString());
    }

    public static final class ContextVisibilityInfo {
        public final CsmVisibility visibility;
        public final boolean friend;

        public ContextVisibilityInfo(CsmVisibility csmVisibility, boolean bl) {
            this.visibility = csmVisibility;
            this.friend = bl;
        }
    }
}

