/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indent;

import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.formatting.api.support.MarkupAbstractIndenter;
import org.netbeans.modules.editor.indent.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlIndenter
extends MarkupAbstractIndenter<HTMLTokenId> {
    private DTD dtd = HtmlSyntaxSupport.get((Document)this.getDocument()).getDTD();
    private static final String[] TAGS_WITH_UNFORMATTABLE_CONTENT = new String[]{"pre", "textarea"};

    public HtmlIndenter(Context context) {
        super(HTMLTokenId.language(), context);
        assert (this.dtd != null) : "cannot find any DTD - perhaps NbReaderProvider.setupReaders() was not called?";
    }

    private DTD getDTD() {
        return this.dtd;
    }

    protected boolean isWhiteSpaceToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.TEXT && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected boolean isOpenTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().toUpperCase().startsWith("<!");
    }

    protected boolean isCloseTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE;
    }

    protected boolean isStartTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("<");
    }

    protected boolean isStartTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("</");
    }

    protected boolean isEndTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals(">");
    }

    protected boolean isEndTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals("/>") || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().startsWith(">");
    }

    protected boolean isTagArgumentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.ARGUMENT;
    }

    protected boolean isBlockCommentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.BLOCK_COMMENT;
    }

    protected boolean isTagContentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TEXT;
    }

    protected boolean isClosingTagOptional(String string) {
        DTD.Element element = this.getDTD().getElement(string.toUpperCase());
        if (element == null) {
            return false;
        }
        return element.hasOptionalEnd();
    }

    protected boolean isOpeningTagOptional(String string) {
        DTD.Element element = this.getDTD().getElement(string.toUpperCase());
        if (element == null) {
            return false;
        }
        return element.hasOptionalStart();
    }

    protected Boolean isEmptyTag(String string) {
        DTD.Element element = this.getDTD().getElement(string.toUpperCase());
        if (element == null) {
            return false;
        }
        return element.isEmpty();
    }

    protected boolean isTagContentUnformattable(String string) {
        for (String string2 : TAGS_WITH_UNFORMATTABLE_CONTENT) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getTagChildren(String string) {
        DTD.Element element = this.getDTD().getElement(string.toUpperCase());
        if (element == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (DTD.Element element2 : element.getContentModel().getIncludes()) {
            if (element2 == null) continue;
            treeSet.add(element2.getName());
        }
        for (DTD.Element element2 : element.getContentModel().getExcludes()) {
            if (element2 == null) continue;
            treeSet.remove(element2.getName());
        }
        for (DTD.Element element2 : element.getContentModel().getContent().getPossibleElements()) {
            if (element2 == null) continue;
            treeSet.add(element2.getName());
        }
        if (string.equalsIgnoreCase("HTML")) {
            treeSet.add("BODY");
        }
        return treeSet;
    }

    protected boolean isPreservedLine(Token<HTMLTokenId> token, IndenterContextData<HTMLTokenId> indenterContextData) {
        String string;
        return this.isBlockCommentToken(token) && !(string = ((Object)token.text()).toString().trim()).startsWith("<!--") && !string.startsWith("-->");
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<HTMLTokenId> joinedTokenSequence) throws BadLocationException {
        int n = joinedTokenSequence.index();
        boolean bl = false;
        while (this.isBlockCommentToken((Token<HTMLTokenId>)joinedTokenSequence.token())) {
            String string = ((Object)joinedTokenSequence.token().text()).toString().trim();
            if (string.startsWith("<!--")) {
                bl = true;
                break;
            }
            if (joinedTokenSequence.movePrevious()) continue;
        }
        int n2 = 0;
        if (bl) {
            int n3 = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)joinedTokenSequence.offset());
            int n4 = joinedTokenSequence.offset();
            n2 = n4 - n3;
        }
        joinedTokenSequence.moveIndex(n);
        joinedTokenSequence.moveNext();
        return n2;
    }

    private boolean isOpeningTag(JoinedTokenSequence<HTMLTokenId> joinedTokenSequence) {
        int n = joinedTokenSequence.index();
        boolean bl = false;
        while (joinedTokenSequence.moveNext()) {
            if (this.isEndTagSymbol((Token<HTMLTokenId>)joinedTokenSequence.currentTokenSequence().token())) {
                bl = true;
                break;
            }
            if (!this.isEndTagClosingSymbol((Token<HTMLTokenId>)joinedTokenSequence.currentTokenSequence().token())) continue;
        }
        joinedTokenSequence.moveIndex(n);
        joinedTokenSequence.moveNext();
        return bl;
    }

    protected boolean isForeignLanguageStartToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> joinedTokenSequence) {
        return this.isOpenTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script")) && this.isOpeningTag(joinedTokenSequence);
    }

    protected boolean isForeignLanguageEndToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> joinedTokenSequence) {
        return this.isCloseTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script"));
    }
}

