/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.gsf.embedding.CssHtmlTranslator;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(CssEmbeddingProvider.class.getName());
    private String sourceMimeType;
    private Translator translator;

    private CssEmbeddingProvider(String string, Translator translator) {
        this.sourceMimeType = string;
        this.translator = translator;
    }

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            List<Embedding> list = this.translator.getEmbeddings(snapshot);
            if (list.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(Embedding.create(list));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + this.sourceMimeType + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Translator {
        public List<Embedding> getEmbeddings(Snapshot var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends TaskFactory {
        private static final String JSP_MIME_TYPE = "text/x-jsp";
        private static final String JSP_TAG_MIME_TYPE = "text/x-tag";
        private static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
        private static final String HTML_MIME_TYPE = "text/html";
        private static final String PHP_MIME_TYPE = "text/x-php5";
        private static final String GSP_TAG_MIME_TYPE = "application/x-gsp";
        private static final Map<String, Translator> translators = new HashMap<String, Translator>();

        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            Translator translator = translators.get(snapshot.getMimeType());
            if (translator != null) {
                return Collections.singleton(new CssEmbeddingProvider(snapshot.getMimeType(), translator));
            }
            return Collections.emptyList();
        }

        static {
            translators.put(HTML_MIME_TYPE, new CssHtmlTranslator());
        }
    }
}

