/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.javadoc.HelpManager;
import org.netbeans.modules.html.editor.NbReaderProvider;
import org.netbeans.modules.html.editor.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.completion.HtmlCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class HtmlCompletionProvider
implements CompletionProvider {
    public HtmlCompletionProvider() {
        NbReaderProvider.setupReaders();
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        int n;
        Document document = jTextComponent.getDocument();
        boolean bl = HtmlSyntaxSupport.checkOpenCompletion((Document)document, (int)(n = jTextComponent.getCaret().getDot()), (String)string);
        return bl ? 3 : 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        AsyncCompletionTask asyncCompletionTask = null;
        if ((n & 1 & 9) != 0) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
        } else if (n == 2) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
        }
        return asyncCompletionTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkHideCompletion(BaseDocument baseDocument, int n) {
        baseDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n == 0 ? 0 : n - 1);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == HTMLTokenId.TEXT && !((Object)token.text()).toString().startsWith("<") && !((Object)token.text()).toString().startsWith("&")) {
                HtmlCompletionProvider.hideCompletion();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    public static class DocItem
    implements CompletionDocumentation {
        HtmlCompletionItem item;

        public DocItem(HtmlCompletionItem htmlCompletionItem) {
            this.item = htmlCompletionItem;
        }

        public String getText() {
            return this.item.getHelp();
        }

        public URL getURL() {
            return this.item.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String string) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(HelpManager.getDefault().getHelpURL(this.item.getHelpId()), string));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    public static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LinkDocItem(URL uRL) {
            this.url = uRL;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String string) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, string));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            HtmlCompletionProvider.checkHideCompletion((BaseDocument)document, n);
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            this.doQuery(completionResultSet, document, n);
            completionResultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    public static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private CompletionItem item;

        DocQuery(HtmlCompletionItem htmlCompletionItem) {
            this.item = htmlCompletionItem;
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            Object object;
            Object var4_4 = null;
            if (this.item == null && (object = HtmlCompletionQuery.getDefault().query(this.component, n)) != null && ((HtmlCompletionQuery.CompletionResult)object).getItems().size() > 0) {
                this.item = ((HtmlCompletionQuery.CompletionResult)object).getItems().get(0);
            }
            if ((object = (HtmlCompletionItem)this.item) != null && ((HtmlCompletionItem)object).getHelp() != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new DocItem((HtmlCompletionItem)object));
            }
        }
    }

    static class Query
    extends AbstractQuery {
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            HtmlCompletionQuery.CompletionResult completionResult = HtmlCompletionQuery.getDefault().query(this.component, n);
            if (completionResult == null) {
                return;
            }
            completionResultSet.addAllItems(completionResult.getItems());
            completionResultSet.setAnchorOffset(completionResult.getAnchor());
        }
    }
}

