/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.netbeans.modules.db.sql.history.SQLHistoryModel;
import org.netbeans.modules.db.sql.history.SQLHistoryModelImpl;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SQLHistoryPanel
extends JPanel {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history";
    public static final String SAVE_STATEMENTS_MAX_LIMIT_ENTERED = "10000";
    public static final String SAVE_STATEMENTS_CLEARED = "";
    public static final int SAVE_STATEMENTS_MAX_LIMIT = 10000;
    public static final int TABLE_DATA_WIDTH_SQL = 125;
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPanel.class.getName());
    private static final FileObject USERDIR = FileUtil.getConfigRoot();
    private static final FileObject historyRoot = USERDIR.getFileObject("Databases/SQLHISTORY");
    private static String historyFilePath;
    private static Object[][] data;
    private List<String> currentUrlList;
    private Object[] comboData;
    private SQLHistoryView view;
    private JEditorPane editorPane;
    private String currentUrl;
    private JComboBox connectionUrlComboBox;
    private JLabel inputWarningLabel;
    private JButton insertSQLButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField searchTextField;
    private JTable sqlHistoryTable;
    private JButton sqlLimitButton;
    private JLabel sqlLimitLabel;
    private JTextField sqlLimitTextField;

    public SQLHistoryPanel(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
        historyFilePath = FileUtil.getFileDisplayName((FileObject)historyRoot) + File.separator + SQL_HISTORY_FILE_NAME + ".xml";
        this.view = new SQLHistoryView(new SQLHistoryModelImpl());
        this.initSQLHistoryTableData();
        this.initComponents();
        this.initComponentData();
        this.setupSQLSaveLimit();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SQLHistoryPanel.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
            }
        });
    }

    private void setupSQLSaveLimit() {
        String string = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
        if (null != string && !string.equals(SAVE_STATEMENTS_CLEARED)) {
            this.sqlLimitTextField.setText(string);
        } else {
            this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
            string = SAVE_STATEMENTS_MAX_LIMIT_ENTERED;
            NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
        }
    }

    private void initComponentData() {
        this.searchTextField.getDocument().addDocumentListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.sqlHistoryTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SQLTableTitle"));
        this.sqlHistoryTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DateTableTitle"));
        JTableHeader jTableHeader = this.sqlHistoryTable.getTableHeader();
        jTableHeader.addMouseListener(new ColumnListener());
        this.sqlHistoryTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n = SQLHistoryPanel.this.sqlHistoryTable.rowAtPoint(point);
                    int n2 = SQLHistoryPanel.this.sqlHistoryTable.columnAtPoint(point);
                    if (n == -1 || n2 != 0) {
                        return;
                    }
                    SQLHistoryPanel.this.insertSQL();
                }
            }
        });
        this.connectionUrlComboBox.addActionListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.currentUrlList = new ArrayList<String>();
        List<String> list = this.view.getUrlList();
        String string = NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
        list.add(string);
        this.comboData = new Object[list.size()];
        int n = 0;
        for (String string2 : list) {
            this.comboData[n] = string2;
            ++n;
        }
        this.currentUrl = string;
        this.connectionUrlComboBox.setSelectedItem(string);
    }

    private void initSQLHistoryTableData() {
        List<String> list = this.view.getSQLList(null);
        List<String> list2 = this.view.getDateList(null);
        data = new Object[list.size()][2];
        int n = 0;
        for (String string : list) {
            int n2 = string.trim().length();
            int n3 = n2 > 125 ? 125 : n2;
            SQLHistoryPanel.data[n][0] = string.trim().substring(0, n3);
            ++n;
        }
        n = 0;
        for (String string : list2) {
            SQLHistoryPanel.data[n][1] = string;
            ++n;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.connectionUrlComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.searchTextField = new JTextField();
        this.insertSQLButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sqlHistoryTable = new JTable(){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(SQLHistoryPanel.this.view.getSQLHistoryTooltipValue(n, n2));
                }
                return component;
            }
        };
        this.sqlLimitLabel = new JLabel();
        this.sqlLimitTextField = new JTextField();
        this.sqlLimitButton = new JButton();
        this.inputWarningLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Connection"));
        this.connectionUrlComboBox.setModel(new UrlComboBoxModel());
        this.connectionUrlComboBox.setRenderer(new ConnectionUrlRenderer());
        this.jLabel2.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Match"));
        this.searchTextField.setMinimumSize(new Dimension(20, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.insertSQLButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Insert"));
        this.insertSQLButton.setEnabled(false);
        this.insertSQLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLHistoryPanel.this.insertSQLButtonActionPerformed(actionEvent);
            }
        });
        this.sqlHistoryTable.setModel(new HistoryTableModel());
        this.sqlHistoryTable.setGridColor(Color.lightGray);
        this.jScrollPane1.setViewportView(this.sqlHistoryTable);
        this.sqlHistoryTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_History"));
        this.sqlHistoryTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_History"));
        this.sqlLimitLabel.setLabelFor(this.sqlLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.sqlLimitLabel, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SqlLimit"));
        this.sqlLimitTextField.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InitialLimit"));
        this.sqlLimitTextField.setMinimumSize(new Dimension(18, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.sqlLimitButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ApplyButton"));
        this.sqlLimitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLHistoryPanel.this.sqlLimitButtonActionPerformed(actionEvent);
            }
        });
        this.inputWarningLabel.setForeground(Color.red);
        this.inputWarningLabel.setFocusable(false);
        this.inputWarningLabel.setRequestFocusEnabled(false);
        this.inputWarningLabel.setVerifyInputWhenFocusTarget(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 569, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.connectionUrlComboBox, 0, 212, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.searchTextField, -2, 147, -2))).addPreferredGap(0).add((Component)this.insertSQLButton).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.inputWarningLabel, -1, 164, Short.MAX_VALUE).add(493, 493, 493)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sqlLimitLabel).addPreferredGap(0).add((Component)this.sqlLimitTextField, -2, 62, -2).addPreferredGap(0).add((Component)this.sqlLimitButton)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.searchTextField, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.connectionUrlComboBox, -2, 27, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.insertSQLButton).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 168, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sqlLimitTextField, -2, -1, -2).add((Component)this.sqlLimitButton).add((Component)this.sqlLimitLabel)).addPreferredGap(0).add((Component)this.inputWarningLabel, -2, 26, -2))).addContainerGap()));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ASCN_ConnectionCombo"));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_ConnectionCombo"));
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Match"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Match"));
        this.insertSQLButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Insert"));
        this.insertSQLButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Insert"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Save"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Save"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Apply"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Apply"));
    }

    private void insertSQLButtonActionPerformed(ActionEvent actionEvent) {
        this.insertSQL();
    }

    private void sqlLimitButtonActionPerformed(ActionEvent actionEvent) {
        this.verifySQLLimit();
    }

    private void insertSQL() {
        try {
            List<SQLHistory> list = this.view.getCurrentSQLHistoryList();
            int n = 0;
            String string = SAVE_STATEMENTS_CLEARED;
            InsertSQLUtility insertSQLUtility = new InsertSQLUtility();
            for (SQLHistory sQLHistory : list) {
                if (this.sqlHistoryTable.isRowSelected(n)) {
                    string = sQLHistory.getSql().trim();
                    JEditorPane jEditorPane = (JEditorPane)EditorRegistry.lastFocusedComponent();
                    String string2 = jEditorPane.getContentType();
                    if (string2.equals("text/x-sql")) {
                        this.editorPane = jEditorPane;
                    }
                    insertSQLUtility.insert(string, this.editorPane);
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void verifySQLLimit() {
        String string = this.sqlLimitTextField.getText();
        int n = 0;
        if (string.equals(SAVE_STATEMENTS_CLEARED)) {
            this.updateSaveLimitUponClear(n);
            this.inputWarningLabel.setText(SAVE_STATEMENTS_CLEARED);
        } else {
            this.updateSaveLimitUponReset(string);
        }
    }

    private void updateSaveLimitUponClear(int n) {
        n = 10000;
        List<SQLHistory> list = new ArrayList<SQLHistory>();
        try {
            this.view.setSQLHistoryList(SQLHistoryPersistenceManager.getInstance().updateSQLSaved(n, historyRoot));
            list = SQLHistoryPersistenceManager.getInstance().retrieve(historyFilePath, historyRoot);
            this.view.setCurrentSQLHistoryList(list);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (SQLHistoryException sQLHistoryException) {
            this.handleSQLHistoryException();
        }
        ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(list);
        NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(n));
        this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
    }

    private void updateSaveLimitUponReset(String string) {
        try {
            int n = Integer.parseInt(string);
            String string2 = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
            if (n < 0 || n > 10000) {
                this.sqlLimitButton.setEnabled(true);
                this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_NumberInputWarningLabel"));
                if (string2 != null) {
                    this.sqlLimitTextField.setText(string2);
                } else {
                    this.sqlLimitTextField.setText(SAVE_STATEMENTS_CLEARED);
                    this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
                }
            } else {
                this.inputWarningLabel.setText(SAVE_STATEMENTS_CLEARED);
                if (SQLHistoryPersistenceManager.getInstance().updateSQLSaved(n, historyRoot).size() > 0) {
                    List<SQLHistory> list = SQLHistoryPersistenceManager.getInstance().retrieve(historyFilePath, historyRoot);
                    this.view.setCurrentSQLHistoryList(list);
                    ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(list);
                    this.view.updateConnectionUrl();
                    NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(n));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (SQLHistoryException sQLHistoryException) {
            this.handleSQLHistoryException();
        }
        catch (NumberFormatException numberFormatException) {
            this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_TextInputWarningLabel"));
            String string3 = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
            if (string3 != null) {
                this.sqlLimitTextField.setText(string3);
            }
            this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
        }
    }

    private void handleSQLHistoryException() {
        LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ErrorParsingSQLHistory"));
        List<SQLHistory> list = SQLHistoryPersistenceManager.getInstance().retrieve();
        this.view.setCurrentSQLHistoryList(list);
        ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(list);
        this.view.updateConnectionUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Document document) throws InterruptedException, Exception {
        Renderer renderer = new Renderer(document);
        document.render(renderer);
        Renderer renderer2 = renderer;
        synchronized (renderer2) {
            while (!renderer.done) {
                renderer.wait();
                if (renderer.err == null) continue;
                throw new Exception(renderer.err);
            }
        }
        return renderer.result;
    }

    private static void adjustColumnPreferredWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Object object = jTable.getValueAt(j, i);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                n = Math.max(component.getPreferredSize().width, n);
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n);
        }
    }

    private TableCellRenderer createDefaultRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? SQLHistoryPanel.SAVE_STATEMENTS_CLEARED : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }

    static /* synthetic */ Object[] access$1402(SQLHistoryPanel sQLHistoryPanel, Object[] objectArray) {
        sQLHistoryPanel.comboData = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][] access$1802(Object[][] objectArray) {
        data = objectArray;
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SQLComparator
    implements Comparator<SQLHistory> {
        protected int sortCol;
        protected boolean sortAsc;

        public SQLComparator(int n, boolean bl) {
            this.sortCol = n;
            this.sortAsc = bl;
        }

        @Override
        public int compare(SQLHistory sQLHistory, SQLHistory sQLHistory2) {
            int n = 0;
            if (!(sQLHistory instanceof SQLHistory) || !(sQLHistory2 instanceof SQLHistory)) {
                return n;
            }
            SQLHistory sQLHistory3 = sQLHistory;
            SQLHistory sQLHistory4 = sQLHistory2;
            switch (this.sortCol) {
                case 0: {
                    String string = sQLHistory3.getSql().trim().toLowerCase();
                    String string2 = sQLHistory4.getSql().trim().toLowerCase();
                    n = string.compareTo(string2);
                    break;
                }
                case 1: {
                    Date date = sQLHistory3.getDate();
                    Date date2 = sQLHistory4.getDate();
                    n = date.compareTo(date2);
                }
            }
            if (!this.sortAsc) {
                n = -n;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SQLComparator) {
                SQLComparator sQLComparator = (SQLComparator)object;
                return sQLComparator.sortCol == this.sortCol && sQLComparator.sortAsc == this.sortAsc;
            }
            return false;
        }

        public int hashCode() {
            int n = 3;
            n = 17 * n + this.sortCol;
            n = 17 * n + (this.sortAsc ? 1 : 0);
            return n;
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private ColumnListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            HistoryTableModel historyTableModel = (HistoryTableModel)SQLHistoryPanel.this.sqlHistoryTable.getModel();
            TableColumnModel tableColumnModel = SQLHistoryPanel.this.sqlHistoryTable.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 < 0) {
                return;
            }
            if (historyTableModel.sortCol == n2) {
                historyTableModel.sortAsc = !historyTableModel.sortAsc;
            } else {
                historyTableModel.sortCol = n2;
            }
            historyTableModel.sortData();
            SQLHistoryPanel.this.sqlHistoryTable.tableChanged(new TableModelEvent(historyTableModel));
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
        }
    }

    private static final class ConnectionUrlRenderer
    extends DefaultListCellRenderer {
        private ConnectionUrlRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setToolTipText((String)object);
            return jLabel;
        }
    }

    private class InsertSQLUtility {
        public void insert(String string, JEditorPane jEditorPane) throws BadLocationException {
            this.insert(string, jEditorPane, false);
        }

        public void insert(String string, JEditorPane jEditorPane, boolean bl) throws BadLocationException {
            Document document;
            if (string == null) {
                string = SQLHistoryPanel.SAVE_STATEMENTS_CLEARED;
            }
            if ((document = jEditorPane.getDocument()) != null) {
                this.insert(string, jEditorPane, document);
            }
        }

        private int insert(String string, JEditorPane jEditorPane, Document document) throws BadLocationException {
            int n = -1;
            try {
                Caret caret = jEditorPane.getCaret();
                int n2 = Math.min(caret.getDot(), caret.getMark());
                int n3 = Math.max(caret.getDot(), caret.getMark());
                document.remove(n2, n3 - n2);
                n = caret.getDot();
                document.insertString(n, string + ";\n", null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InsertAtLocationError") + badLocationException);
            }
            return n;
        }
    }

    private static class Renderer
    implements Runnable {
        Document doc;
        String result;
        Throwable err;
        boolean done;

        Renderer(Document document) {
            this.doc = document;
        }

        public synchronized void run() {
            try {
                this.result = this.doc.getText(0, this.doc.getLength());
            }
            catch (Throwable throwable) {
                this.err = throwable;
                Exceptions.printStackTrace((Throwable)throwable);
            }
            this.done = true;
            this.notify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HistoryTableModel
    extends DefaultTableModel
    implements ActionListener,
    DocumentListener {
        List<String> sqlList;
        List<String> dateList;
        int sortCol = 1;
        boolean sortAsc = false;

        private HistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            if (SQLHistoryPanel.this.sqlHistoryTable.getSelectedRow() == -1) {
                SQLHistoryPanel.this.insertSQLButton.setEnabled(false);
            }
            return data.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object == null) {
                return String.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (SQLHistoryPanel.this.sqlHistoryTable.isRowSelected(n)) {
                SQLHistoryPanel.this.insertSQLButton.setEnabled(true);
            }
            return data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public void adjustColumnPreferredWidths(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                int n = 0;
                for (int j = 0; j < jTable.getRowCount(); ++j) {
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                    Object object = jTable.getValueAt(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                    n = Math.max(component.getPreferredSize().width, n);
                }
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(n);
                tableColumn.setHeaderRenderer(SQLHistoryPanel.this.createDefaultRenderer());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.processUpdate();
        }

        public void refreshTable(List<SQLHistory> list) {
            int n;
            int n2;
            String string = list.size() > 0 ? SQLHistoryPanel.this.connectionUrlComboBox.getSelectedItem().toString() : NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
            this.sqlList = new ArrayList<String>();
            this.dateList = new ArrayList<String>();
            SQLHistoryPanel.this.connectionUrlComboBox.setToolTipText(string);
            for (SQLHistory iterator : list) {
                if (!string.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem")) && !string.equals(iterator.getUrl())) continue;
                n2 = iterator.getSql().trim().length();
                n = n2 > 125 ? 125 : n2;
                this.sqlList.add(iterator.getSql().trim().substring(0, n));
                this.dateList.add(DateFormat.getInstance().format(iterator.getDate()));
            }
            SQLHistoryPanel.access$1802(null);
            SQLHistoryPanel.access$1802(new Object[this.sqlList.size()][2]);
            int n3 = 0;
            for (String string2 : this.sqlList) {
                n2 = string2.trim().length();
                n = n2 > 125 ? 125 : n2;
                data[n3][0] = string2.trim().substring(0, n);
                ++n3;
            }
            n3 = 0;
            for (String string2 : this.dateList) {
                data[n3++][1] = string2;
            }
            if (data.length > 0) {
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
            } else {
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
                SQLHistoryPanel.this.insertSQLButton.setEnabled(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            SQLHistoryPanel.this.view.setCurrentSQLHistoryList(SQLHistoryPanel.this.view.filterSQLHistoryList());
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
            SQLHistoryPanel.this.sqlHistoryTable.clearSelection();
            this.refreshTable(SQLHistoryPanel.this.view.getCurrentSQLHistoryList());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void cleanTable() {
            List<SQLHistory> list = SQLHistoryPanel.this.view.getSQLHistoryList();
            SQLHistoryPanel.access$1802(null);
            SQLHistoryPanel.access$1802(new Object[list.size()][2]);
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
        }

        public List<SQLHistory> sortData() {
            List list = SQLHistoryPanel.this.view.filterSQLHistoryList();
            SQLComparator sQLComparator = new SQLComparator(this.sortCol, this.sortAsc);
            Collections.sort(list, sQLComparator);
            SQLHistoryPanel.this.view.setCurrentSQLHistoryList(list);
            this.refreshTable(list);
            return list;
        }
    }

    private final class UrlComboBoxModel
    extends DefaultComboBoxModel
    implements ActionListener {
        private UrlComboBoxModel() {
        }

        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
        }

        public Object getSelectedItem() {
            return super.getSelectedItem();
        }

        public int getSize() {
            return SQLHistoryPanel.this.comboData.length;
        }

        public Object getElementAt(int n) {
            return SQLHistoryPanel.this.comboData[n];
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SQLHistoryPanel.this.currentUrl = ((JComboBox)actionEvent.getSource()).getSelectedItem().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SQLHistoryView {
        private SQLHistoryModel model;
        List<SQLHistory> sqlHistoryList = new ArrayList<SQLHistory>();
        List<SQLHistory> currentSQLHistoryList = new ArrayList<SQLHistory>();
        public static final String MATCH_EMPTY = "";
        public static final String NO_MATCH = "";

        public SQLHistoryView(SQLHistoryModel sQLHistoryModel) {
            this.model = sQLHistoryModel;
            this.init();
        }

        private void init() {
            try {
                this.sqlHistoryList = this.model.getSQLHistoryList();
                this.currentSQLHistoryList = this.model.getSQLHistoryList();
            }
            catch (SQLHistoryException sQLHistoryException) {
                LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ErrorParsingSQLHistory"), sQLHistoryException);
                this.sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve();
                this.setCurrentSQLHistoryList(this.sqlHistoryList);
            }
        }

        public void setCurrentSQLHistoryList(List<SQLHistory> list) {
            this.currentSQLHistoryList = list;
        }

        public List<SQLHistory> getCurrentSQLHistoryList() {
            return this.currentSQLHistoryList;
        }

        public List<SQLHistory> getSQLHistoryList() {
            return this.sqlHistoryList;
        }

        public void setSQLHistoryList(List<SQLHistory> list) {
            this.sqlHistoryList = list;
        }

        public String getSQLHistoryTooltipValue(int n, int n2) {
            List<SQLHistory> list = SQLHistoryPanel.this.view.getCurrentSQLHistoryList();
            if (n < list.size()) {
                if (n2 == 0) {
                    String string = list.get(n).getSql().trim();
                    while (string.indexOf("\n") != -1) {
                        string = this.replace(string, "\n", "<br>");
                    }
                    return "<html>" + string + "</html>";
                }
                return DateFormat.getInstance().format(list.get(n).getDate());
            }
            return "";
        }

        public String replace(String string, String string2, String string3) {
            int n = string.indexOf(string2);
            if (n == -1) {
                return string;
            }
            int n2 = string2.length();
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1) {
                stringBuffer.append(cArray, n3, n - n3);
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string.indexOf(string2, n3);
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            return stringBuffer.toString();
        }

        public List<String> getUrlList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                String string = sQLHistory.getUrl();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public List<String> getSQLList(List<SQLHistory> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list == null) {
                list = this.getSQLHistoryList();
            }
            for (SQLHistory sQLHistory : list) {
                String string = sQLHistory.getSql();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public List<String> getDateList(List<SQLHistory> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (list == null) {
                list = this.getSQLHistoryList();
            }
            for (SQLHistory sQLHistory : list) {
                String string = DateFormat.getInstance().format(sQLHistory.getDate());
                String string2 = sQLHistory.getSql();
                if (arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
                arrayList.add(string);
            }
            return arrayList;
        }

        public void updateConnectionUrl() {
            SQLHistoryPanel.this.currentUrlList.clear();
            String string = FileUtil.getFileDisplayName((FileObject)historyRoot) + File.separator + SQLHistoryPanel.SQL_HISTORY_FILE_NAME + ".xml";
            try {
                this.sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve(string, historyRoot);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
            catch (SQLHistoryException sQLHistoryException) {
                SQLHistoryPanel.this.handleSQLHistoryException();
            }
            String string2 = NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
            SQLHistoryPanel.this.currentUrlList.add(string2);
            SQLHistoryPanel.this.connectionUrlComboBox.setSelectedItem(string2);
            for (SQLHistory object : this.sqlHistoryList) {
                if (SQLHistoryPanel.this.currentUrlList.contains(object.getUrl())) continue;
                SQLHistoryPanel.this.currentUrlList.add(object.getUrl());
            }
            SQLHistoryPanel.access$1402(SQLHistoryPanel.this, null);
            SQLHistoryPanel.access$1402(SQLHistoryPanel.this, new Object[SQLHistoryPanel.this.currentUrlList.size()]);
            int n = 0;
            for (String string3 : SQLHistoryPanel.this.currentUrlList) {
                ((SQLHistoryPanel)SQLHistoryPanel.this).comboData[n++] = string3;
            }
            SQLHistoryPanel.this.connectionUrlComboBox.revalidate();
        }

        private List<SQLHistory> filterSQLHistoryList() {
            ArrayList<SQLHistory> arrayList = new ArrayList<SQLHistory>();
            String string = SQLHistoryPanel.this.searchTextField.getText();
            String string2 = (String)SQLHistoryPanel.this.connectionUrlComboBox.getSelectedItem();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                if (!sQLHistory.getUrl().equals(string2) && !string2.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ConnectionCombo"))) continue;
                if (!string.equals("")) {
                    if (sQLHistory.getSql().toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                    arrayList.add(sQLHistory);
                    continue;
                }
                arrayList.add(sQLHistory);
            }
            this.currentSQLHistoryList = arrayList;
            return arrayList;
        }
    }
}

