/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicInfoWizardPanel
extends BasicWizardPanel.NewTemplatePanel
implements WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private BasicInfoVisualPanel visualPanel;

    public BasicInfoWizardPanel(NewModuleProjectData newModuleProjectData) {
        super(newModuleProjectData);
    }

    @Override
    public void reloadData() {
        this.getVisualPanel().refreshData();
    }

    @Override
    public void storeData() {
        this.getVisualPanel().storeData();
    }

    private BasicInfoVisualPanel getVisualPanel() {
        return (BasicInfoVisualPanel)this.getComponent();
    }

    public Component getComponent() {
        if (this.visualPanel == null) {
            this.visualPanel = new BasicInfoVisualPanel(this.getData());
            this.visualPanel.addPropertyChangeListener(this);
            this.visualPanel.setName(this.getMessage("LBL_BasicInfoPanel_Title"));
            this.visualPanel.updateAndCheck();
        }
        return this.visualPanel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(BasicInfoWizardPanel.class.getName() + "_" + this.getWizardTypeString());
    }

    public void validate() throws WizardValidationException {
        String string = this.getData().getProjectFolder();
        if (string != null) {
            String string2;
            String string3;
            File file = new File(string);
            String string4 = this.getData().getProjectName();
            if (Utilities.isWindows()) {
                string3 = ".*[\\/:*?\"<>|].*";
                string2 = "\\ / : * ? \" < > |";
            } else {
                string3 = ".*[\\/].*";
                string2 = "\\ /";
            }
            if (Pattern.matches(string3, string4)) {
                String string5 = this.getMessage("MSG_ProjectFolderInvalidCharacters");
                string5 = String.format(string5, string2);
                throw new WizardValidationException((JComponent)this.getVisualPanel().nameValue, string5, string5);
            }
            if (file.mkdir()) {
                file.delete();
            } else {
                String string6 = this.getMessage("MSG_UnableToCreateProjectFolder");
                throw new WizardValidationException((JComponent)this.getVisualPanel().nameValue, string6, string6);
            }
        }
    }
}

