/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddFriendPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class CustomizerVersioning
extends NbPropertyPanel.Single {
    private static final int CHECKBOX_WIDTH = new JCheckBox().getWidth();
    private boolean lastAppImplChecked;
    private Dimension lastSize;
    BasicCustomizer.SubCategoryProvider provider;
    private JButton addFriendButton;
    private JCheckBox appendImpl;
    private JRadioButton autoloadMod;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JLabel cnb;
    private JTextField cnbValue;
    private JRadioButton eagerMod;
    private JCheckBox exportOnlyToFriend;
    private JLabel filler1;
    private JList friendsList;
    private JScrollPane friendsSP;
    private JLabel implVer;
    private JTextField implVerValue;
    private JLabel majorRelVer;
    private JTextField majorRelVerValue;
    private ButtonGroup moduleTypeGroup;
    private JLabel publicPkgs;
    private JScrollPane publicPkgsSP;
    private JTable publicPkgsTable;
    private JRadioButton regularMod;
    private JButton removeFriendButton;
    private JLabel specificationVer;
    private JTextField specificationVerValue;
    private JLabel tokens;
    private JTextField tokensValue;
    private JPanel typePanel;
    private JLabel typeTxt;

    CustomizerVersioning(SingleModuleProperties singleModuleProperties, ProjectCustomizer.Category category, BasicCustomizer.SubCategoryProvider subCategoryProvider) {
        super(singleModuleProperties, CustomizerVersioning.class, category);
        this.initComponents();
        this.initAccesibility();
        this.initPublicPackageTable();
        this.refresh();
        this.attachListeners();
        this.checkValidity();
        this.provider = subCategoryProvider;
    }

    public void addNotify() {
        super.addNotify();
        if (this.provider != null) {
            this.showSubCategory(this.provider);
            this.provider = null;
        }
    }

    void refresh() {
        UIUtil.setText(this.majorRelVerValue, this.getProperties().getMajorReleaseVersion());
        UIUtil.setText(this.tokensValue, this.getProperties().getProvidedTokens());
        String string = this.getProperties().getSpecificationVersion();
        if (null == string || "".equals(string)) {
            this.appendImpl.setSelected(true);
            UIUtil.setText(this.specificationVerValue, this.getProperty("spec.version.base"));
        } else {
            UIUtil.setText(this.specificationVerValue, string);
        }
        UIUtil.setText(this.implVerValue, this.getProperties().getImplementationVersion());
        this.friendsList.setModel(this.getProperties().getFriendListModel());
        UIUtil.setText(this.cnbValue, this.getProperties().getCodeNameBase());
        this.regularMod.setSelected(true);
        this.autoloadMod.setSelected(this.getBooleanProperty("is.autoload"));
        this.eagerMod.setSelected(this.getBooleanProperty("is.eager"));
        this.removeFriendButton.setEnabled(false);
        this.updateAppendImpl();
    }

    private void attachListeners() {
        this.implVerValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomizerVersioning.this.updateAppendImpl();
            }
        });
        this.friendsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerVersioning.this.removeFriendButton.setEnabled(CustomizerVersioning.this.friendsList.getSelectedIndex() != -1);
                }
            }
        });
        this.majorRelVerValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomizerVersioning.this.checkValidity();
            }
        });
        this.implVerValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomizerVersioning.this.updateAppendImpl();
                CustomizerVersioning.this.checkValidity();
            }
        });
    }

    boolean isCustomizerValid() {
        return this.checkMajorReleaseVersion();
    }

    private boolean checkMajorReleaseVersion() {
        boolean bl;
        String string = this.majorRelVerValue.getText().trim();
        try {
            bl = string.length() == 0 || Integer.parseInt(string) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected void checkValidity() {
        this.exportOnlyToFriend.setSelected(this.getFriendModel().getSize() > 0);
        if (!this.checkMajorReleaseVersion()) {
            this.category.setErrorMessage(this.getMessage("MSG_MajorReleaseVersionIsInvalid"));
            this.category.setValid(true);
        } else if (this.exportOnlyToFriend.isSelected() && this.getPublicPackagesModel().getSelectedPackages().length < 1) {
            this.category.setErrorMessage(this.getMessage("MSG_PublicPackageMustBeSelected"));
            this.category.setValid(false);
        } else if (this.implVerValue.getText().matches(".*[^0-9].*")) {
            this.category.setErrorMessage(this.getMessage("MSG_integer_impl_version_recommended"));
            this.category.setValid(true);
        } else {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
        }
    }

    private void initPublicPackageTable() {
        this.publicPkgsTable.setModel(this.getProperties().getPublicPackagesModel());
        this.publicPkgsTable.getColumnModel().getColumn(0).setMaxWidth(CHECKBOX_WIDTH + 20);
        this.publicPkgsTable.setRowHeight(this.publicPkgsTable.getFontMetrics(this.publicPkgsTable.getFont()).getHeight() + 2 * this.publicPkgsTable.getRowMargin());
        this.publicPkgsTable.setTableHeader(null);
        this.publicPkgsTable.getSelectionModel().setSelectionMode(0);
        this.publicPkgsSP.getViewport().setBackground(this.publicPkgsTable.getBackground());
        final AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomizerVersioning.this.publicPkgsTable.getSelectedRow();
                if (n == -1) {
                    return;
                }
                Boolean bl = (Boolean)CustomizerVersioning.this.publicPkgsTable.getValueAt(n, 0);
                CustomizerVersioning.this.publicPkgsTable.setValueAt(bl == false, n, 0);
                CustomizerVersioning.this.checkValidity();
            }
        };
        this.publicPkgsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        this.publicPkgsTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.publicPkgsTable.getActionMap().put("startEditing", abstractAction);
    }

    private void updateAppendImpl() {
        boolean bl;
        boolean bl2 = !"".equals(this.implVerValue.getText().trim());
        boolean bl3 = bl = bl2 || this.getProperties().dependingOnImplDependency();
        if (bl && !this.appendImpl.isEnabled()) {
            this.appendImpl.setEnabled(true);
            this.appendImpl.setSelected(this.lastAppImplChecked);
        } else if (!bl && this.appendImpl.isEnabled()) {
            this.appendImpl.setEnabled(false);
            this.lastAppImplChecked = this.appendImpl.isSelected();
            this.appendImpl.setSelected(false);
        }
    }

    public void store() {
        this.getProperties().setMajorReleaseVersion(this.majorRelVerValue.getText().trim());
        String string = this.specificationVerValue.getText().trim();
        if (this.appendImpl.isSelected()) {
            this.getProperties().setSpecificationVersion("");
            this.setProperty("spec.version.base", string);
        } else {
            this.getProperties().setSpecificationVersion(string);
            this.setProperty("spec.version.base", "");
        }
        this.getProperties().setImplementationVersion(this.implVerValue.getText().trim());
        this.getProperties().setProvidedTokens(this.tokensValue.getText().trim());
        this.setBooleanProperty("is.autoload", this.autoloadMod.isSelected());
        this.setBooleanProperty("is.eager", this.eagerMod.isSelected());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("moduleDependencies" == string) {
            this.updateAppendImpl();
        } else if ("propertiesRefreshed" == string) {
            this.refresh();
            this.checkValidity();
        }
    }

    private CustomizerComponentFactory.FriendListModel getFriendModel() {
        return (CustomizerComponentFactory.FriendListModel)this.friendsList.getModel();
    }

    private CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        return (CustomizerComponentFactory.PublicPackagesTableModel)this.publicPkgsTable.getModel();
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.cnb = new JLabel();
        this.cnbValue = new JTextField();
        this.majorRelVer = new JLabel();
        this.majorRelVerValue = new JTextField();
        this.specificationVer = new JLabel();
        this.specificationVerValue = new JTextField();
        this.implVer = new JLabel();
        this.implVerValue = new JTextField();
        this.tokens = new JLabel();
        this.tokensValue = new JTextField();
        this.appendImpl = new JCheckBox();
        this.publicPkgs = new JLabel();
        this.publicPkgsSP = new JScrollPane();
        this.publicPkgsTable = new JTable();
        Dimension dimension = this.publicPkgsTable.getPreferredScrollableViewportSize();
        this.publicPkgsTable.setPreferredScrollableViewportSize(new Dimension(dimension.width, 100));
        this.bottomPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addFriendButton = new JButton();
        this.removeFriendButton = new JButton();
        this.filler1 = new JLabel();
        this.friendsSP = new JScrollPane();
        this.friendsList = new JList();
        this.exportOnlyToFriend = new JCheckBox();
        this.typePanel = new JPanel();
        this.regularMod = new JRadioButton();
        this.autoloadMod = new JRadioButton();
        this.eagerMod = new JRadioButton();
        this.typeTxt = new JLabel();
        this.setLayout(new GridBagLayout());
        this.cnb.setLabelFor(this.cnbValue);
        Mnemonics.setLocalizedText((JLabel)this.cnb, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_CNB"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cnb, gridBagConstraints);
        this.cnbValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cnbValue, gridBagConstraints);
        this.majorRelVer.setLabelFor(this.majorRelVerValue);
        Mnemonics.setLocalizedText((JLabel)this.majorRelVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_MajorReleaseVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.majorRelVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.majorRelVerValue, gridBagConstraints);
        this.specificationVer.setLabelFor(this.specificationVerValue);
        Mnemonics.setLocalizedText((JLabel)this.specificationVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_SpecificationVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 12);
        this.add((Component)this.specificationVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.specificationVerValue, gridBagConstraints);
        this.implVer.setLabelFor(this.implVerValue);
        Mnemonics.setLocalizedText((JLabel)this.implVer, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ImplementationVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.implVer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.implVerValue, gridBagConstraints);
        this.tokens.setLabelFor(this.tokensValue);
        Mnemonics.setLocalizedText((JLabel)this.tokens, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ProvidedTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.tokens, gridBagConstraints);
        this.tokensValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerVersioning.this.tokensValueActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.tokensValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.appendImpl, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AppendImplementation"));
        this.appendImpl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.appendImpl.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.appendImpl, gridBagConstraints);
        this.publicPkgs.setLabelFor(this.publicPkgsTable);
        Mnemonics.setLocalizedText((JLabel)this.publicPkgs, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_PublicPackages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 12);
        this.add((Component)this.publicPkgs, gridBagConstraints);
        this.publicPkgsTable.setShowHorizontalLines(false);
        this.publicPkgsSP.setViewportView(this.publicPkgsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.8;
        this.add((Component)this.publicPkgsSP, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addFriendButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AddButton"));
        this.addFriendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerVersioning.this.addFriend(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addFriendButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeFriendButton, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_RemoveButton"));
        this.removeFriendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerVersioning.this.removeFriend(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeFriendButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.bottomPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.friendsList.setVisibleRowCount(3);
        this.friendsSP.setViewportView(this.friendsList);
        this.friendsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerVersioning.class, (String)"ACS_FriendsList"));
        this.friendsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerVersioning.class, (String)"ACSD_FriendsList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.bottomPanel.add((Component)this.friendsSP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.bottomPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.exportOnlyToFriend, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_ExportOnlyToFriends"));
        this.exportOnlyToFriend.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.exportOnlyToFriend.setEnabled(false);
        this.exportOnlyToFriend.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.exportOnlyToFriend, gridBagConstraints);
        this.typePanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.regularMod);
        this.regularMod.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.regularMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_RegularModule"));
        this.regularMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.regularMod.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.regularMod, gridBagConstraints);
        this.moduleTypeGroup.add(this.autoloadMod);
        Mnemonics.setLocalizedText((AbstractButton)this.autoloadMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_AutoloadModule"));
        this.autoloadMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoloadMod.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.autoloadMod, gridBagConstraints);
        this.moduleTypeGroup.add(this.eagerMod);
        Mnemonics.setLocalizedText((AbstractButton)this.eagerMod, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"CTL_EagerModule"));
        this.eagerMod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.eagerMod.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.typePanel.add((Component)this.eagerMod, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.typeTxt, (String)NbBundle.getMessage(CustomizerVersioning.class, (String)"LBL_ModuleType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.typePanel.add((Component)this.typeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.typePanel, gridBagConstraints);
    }

    private void removeFriend(ActionEvent actionEvent) {
        this.getFriendModel().removeFriend((String)this.friendsList.getSelectedValue());
        if (this.getFriendModel().getSize() > 0) {
            this.friendsList.setSelectedIndex(0);
        }
        this.friendsList.requestFocus();
        this.checkValidity();
    }

    private void addFriend(ActionEvent actionEvent) {
        AddFriendPanel addFriendPanel = new AddFriendPanel(this.getProperties());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addFriendPanel, this.getMessage("CTL_AddNewFriend_Title"));
        dialogDescriptor.setHelpCtx(new HelpCtx(AddFriendPanel.class));
        final JButton jButton = new JButton(this.getMessage("CTL_OK"));
        JButton jButton2 = new JButton(this.getMessage("CTL_Cancel"));
        jButton.setEnabled(false);
        Object[] objectArray = new Object[]{jButton, jButton2};
        dialogDescriptor.setOptions(objectArray);
        dialogDescriptor.setClosingOptions(objectArray);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        addFriendPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "isPanelValid") {
                    jButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        dialog.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_AddNewFriend_Title"));
        jButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_OK"));
        jButton2.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_Cancel"));
        if (this.lastSize != null) {
            dialog.setSize(this.lastSize);
        } else {
            dialog.pack();
        }
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        this.lastSize = dialog.getSize();
        if (dialogDescriptor.getValue().equals(jButton)) {
            String string = addFriendPanel.getFriendCNB();
            this.getFriendModel().addFriend(string);
            this.friendsList.setSelectedValue(string, true);
            this.checkValidity();
        }
        dialog.dispose();
        this.friendsList.requestFocus();
    }

    private void tokensValueActionPerformed(ActionEvent actionEvent) {
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(CustomizerVersioning.class, (String)string);
    }

    public void showSubCategory(BasicCustomizer.SubCategoryProvider subCategoryProvider) {
        if ("Versioning".equals(subCategoryProvider.getCategory()) && "publicPackages".equals(subCategoryProvider.getSubcategory())) {
            this.publicPkgsTable.requestFocus();
        }
    }

    private void initAccesibility() {
        this.addFriendButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddFriendButton"));
        this.removeFriendButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveFriendButton"));
        this.cnbValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CnbValue"));
        this.majorRelVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_MajorRelVerValue"));
        this.specificationVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_SpecificationVerValuea"));
        this.appendImpl.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AppendImpl"));
        this.implVerValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ImplVerValue"));
        this.regularMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RegularMod"));
        this.autoloadMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AutoloadMod"));
        this.eagerMod.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EagerMod"));
        this.publicPkgsTable.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PublicPkgsTable"));
        this.tokensValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_TokensValue"));
    }
}

