/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddFriendPanel
extends JPanel {
    static final String VALID_PROPERTY = "isPanelValid";
    boolean valid = false;
    public JLabel errorMessage;
    public JComboBox friends;
    public JLabel friendsTxt;

    public AddFriendPanel(final SingleModuleProperties singleModuleProperties) {
        this.initComponents();
        this.friends.setPrototypeDisplayValue("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
        Component component = this.friends.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    AddFriendPanel.this.checkValidity();
                }
            });
        }
        this.friends.setEnabled(false);
        this.friends.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.friends.setSelectedItem(CustomizerComponentFactory.WAIT_VALUE);
        ModuleProperties.RP.post(new Runnable(){

            public void run() {
                final String[] stringArray = singleModuleProperties.getAvailableFriends();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            defaultComboBoxModel.addElement(stringArray[i]);
                        }
                        AddFriendPanel.this.friends.setModel(defaultComboBoxModel);
                        AddFriendPanel.this.friends.setEnabled(true);
                        AddFriendPanel.this.checkValidity();
                        AddFriendPanel.this.friends.setPrototypeDisplayValue(null);
                        Window window = SwingUtilities.getWindowAncestor(AddFriendPanel.this);
                        if (window != null && (double)window.getWidth() < window.getPreferredSize().getWidth()) {
                            window.pack();
                        }
                    }
                });
            }
        });
    }

    private void checkValidity() {
        String string = this.getFriendCNB();
        if (string.length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(AddFriendPanel.class, (String)"MSG_FriendMayNotBeBlank"));
        } else if (CustomizerComponentFactory.WAIT_VALUE == this.friends.getSelectedItem()) {
            this.setErrorMessage("");
        } else if (!Util.isValidJavaFQN(string)) {
            this.setErrorMessage(NbBundle.getMessage(AddFriendPanel.class, (String)"MSG_FriendIsNotValidCNB"));
        } else {
            this.setErrorMessage(null);
        }
    }

    String getFriendCNB() {
        return this.friends.getEditor().getItem().toString().trim();
    }

    private void setErrorMessage(String string) {
        boolean bl;
        this.errorMessage.setText(string == null ? " " : string);
        boolean bl2 = bl = string == null;
        if (this.valid != bl) {
            this.valid = bl;
            this.firePropertyChange(VALID_PROPERTY, !bl, bl);
        }
    }

    private void initComponents() {
        this.friendsTxt = new JLabel();
        this.friends = new JComboBox();
        this.errorMessage = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.friendsTxt.setLabelFor(this.friends);
        Mnemonics.setLocalizedText((JLabel)this.friendsTxt, (String)NbBundle.getMessage(AddFriendPanel.class, (String)"LBL_FriendModule"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.friendsTxt, gridBagConstraints);
        this.friends.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.friends, gridBagConstraints);
        this.errorMessage.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.errorMessage, gridBagConstraints);
    }
}

