/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.layers.OpenLayerFilesAction;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformLayersCacheManager {
    private static Map<File, PLFSCache> loadedCaches = new HashMap<File, PLFSCache>();
    private static File cacheLocation;
    private static Map<File, Integer> cacheIndex;
    private static boolean anyModified;
    private static final String CACHE_FILE_FMT = "cache%04d.ser";
    private static Logger LOGGER;
    private static RequestProcessor RP;
    private static RequestProcessor.Task storeTask;

    PlatformLayersCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File findCacheFile(File file) throws IOException {
        File file2;
        Object object;
        if (cacheIndex == null) {
            cacheIndex = new LinkedHashMap<File, Integer>();
            object = null;
            try {
                file2 = new File(cacheLocation, "index.ser");
                if (file2.exists()) {
                    object = new ObjectInputStream(new FileInputStream(file2));
                    int n = ((ObjectInputStream)object).readInt();
                    assert (n == 1);
                    int n2 = ((ObjectInputStream)object).readInt();
                    for (int i = 0; i < n2; ++i) {
                        String string = (String)((ObjectInputStream)object).readObject();
                        Date date = (Date)((ObjectInputStream)object).readObject();
                        File file3 = new File(string);
                        if (!file3.isDirectory()) continue;
                        cacheIndex.put(file3, i);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.WARNING, "Exception during loading project layers cache index file (for cluster " + file + "): " + classNotFoundException.toString());
            }
            finally {
                if (object != null) {
                    ((ObjectInputStream)object).close();
                }
            }
        }
        if ((object = cacheIndex.get(file)) == null) {
            return null;
        }
        file2 = new File(cacheLocation, String.format(CACHE_FILE_FMT, (Integer)object));
        return file2.exists() ? file2 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<FileSystem> getCache(File[] fileArray, FileFilter fileFilter) throws IOException {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenLayerFilesAction.class, (String)"MSG_scanning_layers"));
        try {
            progressHandle.start(fileArray.length + 1);
            int n = 0;
            for (File file : fileArray) {
                File[] fileArray2;
                assert (file.isDirectory());
                boolean bl = true;
                PLFSCache pLFSCache = loadedCaches.get(file);
                if (pLFSCache == null) {
                    pLFSCache = PlatformLayersCacheManager.loadCache(file);
                    if (pLFSCache == null) {
                        pLFSCache = PlatformLayersCacheManager.fillCache(file);
                        cacheIndex.put(file, cacheIndex.size());
                        bl = false;
                    }
                    loadedCaches.put(new File(file.getAbsolutePath()), pLFSCache);
                }
                progressHandle.progress(n++);
                for (File file2 : fileArray2 = PlatformLayersCacheManager.getClusterJars(file)) {
                    PLFSCacheEntry pLFSCacheEntry = pLFSCache.getEntry(file2);
                    if (pLFSCacheEntry == null) {
                        pLFSCacheEntry = new PLFSCacheEntry(file2, 0L, 0L, false, false, null, null);
                        pLFSCache.add(pLFSCacheEntry);
                    }
                    if (pLFSCacheEntry.ignored || fileFilter != null && !fileFilter.accept(pLFSCacheEntry.getJar())) continue;
                    if (bl && !pLFSCacheEntry.checkUpToDate()) {
                        PlatformLayersCacheManager.refreshEntry(pLFSCache, pLFSCacheEntry);
                        LOGGER.log(Level.FINE, "Loading of layer cache for cluster " + file + " failed due to modifications in " + file2);
                    }
                    assert (pLFSCacheEntry.checkUpToDate()) : "entry not up-to-date even immediately after refresh()";
                    if (pLFSCacheEntry.isMasked()) {
                        arrayList.add(0, pLFSCacheEntry.getFS());
                        continue;
                    }
                    arrayList.add(pLFSCacheEntry.getFS());
                }
            }
            PlatformLayersCacheManager.storeCaches();
            progressHandle.progress(n++);
        }
        finally {
            progressHandle.finish();
        }
        return arrayList;
    }

    private static void refreshEntry(PLFSCache pLFSCache, PLFSCacheEntry pLFSCacheEntry) throws IOException {
        assert (!pLFSCacheEntry.checkUpToDate()) : "refresh() called on up-to-date entry";
        if (pLFSCacheEntry.upToDate) {
            return;
        }
        File file = pLFSCacheEntry.getJar();
        if (!file.exists()) {
            pLFSCache.remove(pLFSCacheEntry);
            pLFSCacheEntry.removed = true;
            pLFSCacheEntry.updateValues(pLFSCache);
        }
        ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file, true);
        for (String malformedURLException : manifestManager.getRequiredTokens()) {
            if (!malformedURLException.startsWith("org.openide.modules.os.")) continue;
            pLFSCacheEntry.ignored = true;
            pLFSCacheEntry.updateValues(pLFSCache);
            return;
        }
        String string = manifestManager.getLayer();
        String string2 = manifestManager.getGeneratedLayer();
        if (string == null && string2 == null) {
            pLFSCacheEntry.ignored = true;
            pLFSCacheEntry.updateValues(pLFSCache);
            return;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(2);
        try {
            URI uRI = file.toURI();
            if (string != null) {
                arrayList.add(new URL("jar:" + uRI + "!/" + string));
            }
            if (string2 != null) {
                arrayList.add(new URL("jar:" + uRI + "!/" + string2));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException(malformedURLException.toString()).initCause(malformedURLException);
        }
        LayerCacheManager layerCacheManager = LayerCacheManager.manager((boolean)true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        layerCacheManager.store(null, arrayList, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        pLFSCacheEntry.fs = layerCacheManager.load(null, ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
        PLFSCacheEntry.access$1202(pLFSCacheEntry, byArray);
        pLFSCacheEntry.ignored = false;
        pLFSCacheEntry.updateValues(pLFSCache);
        pLFSCacheEntry.masked = false;
        Enumeration enumeration = pLFSCacheEntry.fs.getRoot().getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (!fileObject.getNameExt().endsWith("_hidden")) continue;
            pLFSCacheEntry.masked = true;
            break;
        }
    }

    private static void storeCaches() {
        if (!anyModified) {
            return;
        }
        if (storeTask == null) {
            storeTask = RP.create(new Runnable(){

                public void run() {
                    PlatformLayersCacheManager.doStoreCaches();
                }
            });
        }
        storeTask.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doStoreCaches() {
        ObjectOutputStream objectOutputStream = null;
        File file = null;
        try {
            try {
                file = new File(cacheLocation, "index.ser");
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeInt(1);
                objectOutputStream.writeInt(cacheIndex.size());
                Date date = Calendar.getInstance().getTime();
                int n = 0;
                for (File file2 : cacheIndex.keySet()) {
                    objectOutputStream.writeObject(file2.getAbsolutePath());
                    objectOutputStream.writeObject(date);
                    PLFSCache pLFSCache = loadedCaches.get(file2);
                    if (pLFSCache != null && pLFSCache.isModified()) {
                        File file3 = new File(cacheLocation, String.format(CACHE_FILE_FMT, n));
                        PlatformLayersCacheManager.storeCache(pLFSCache, file3);
                    }
                    ++n;
                }
            }
            finally {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Saving platform layers cache index into " + file + " failed with exception: " + iOException.getLocalizedMessage(), iOException);
        }
        anyModified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeCache(PLFSCache pLFSCache, File file) {
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeInt(1);
                objectOutputStream.writeInt(pLFSCache.getEntries().size());
                for (PLFSCacheEntry pLFSCacheEntry : pLFSCache.getEntries().values()) {
                    File file2 = pLFSCacheEntry.getJar();
                    objectOutputStream.writeObject(file2.getName());
                    objectOutputStream.writeLong(file2.length());
                    objectOutputStream.writeLong(file2.lastModified());
                    objectOutputStream.writeBoolean(pLFSCacheEntry.ignored);
                    if (pLFSCacheEntry.ignored) continue;
                    objectOutputStream.writeBoolean(pLFSCacheEntry.isMasked());
                    objectOutputStream.writeInt(pLFSCacheEntry.bytes.length);
                    objectOutputStream.write(pLFSCacheEntry.bytes);
                }
            }
            finally {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Saving platform layers cache file " + file + " failed with exception: " + iOException.getLocalizedMessage(), iOException);
        }
        pLFSCache.modified = false;
    }

    private static File[] getClusterJars(File file) {
        File file2 = new File(file, "modules");
        File[] fileArray = file2.isDirectory() ? file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        }) : new File[]{};
        return fileArray;
    }

    private static PLFSCache fillCache(File file) throws IOException {
        File[] fileArray = PlatformLayersCacheManager.getClusterJars(file);
        PLFSCache pLFSCache = new PLFSCache();
        pLFSCache.modified = true;
        anyModified = true;
        LayerCacheManager layerCacheManager = LayerCacheManager.manager((boolean)true);
        block2: for (File file2 : fileArray) {
            Object object;
            ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file2, true);
            for (String string : manifestManager.getRequiredTokens()) {
                if (!string.startsWith("org.openide.modules.os.")) continue;
                pLFSCache.add(new PLFSCacheEntry(file2, file2.length(), file2.lastModified(), true, false, null, null));
                continue block2;
            }
            String string = manifestManager.getLayer();
            String string2 = manifestManager.getGeneratedLayer();
            if (string == null && string2 == null) {
                pLFSCache.add(new PLFSCacheEntry(file2, file2.length(), file2.lastModified(), true, false, null, null));
                continue;
            }
            ArrayList<URL> arrayList = new ArrayList<URL>(2);
            try {
                URI uRI = file2.toURI();
                if (string != null) {
                    arrayList.add(new URL("jar:" + uRI + "!/" + string));
                }
                if (string2 != null) {
                    arrayList.add(new URL("jar:" + uRI + "!/" + string2));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw (IOException)new IOException(malformedURLException.toString()).initCause(malformedURLException);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            layerCacheManager.store(null, arrayList, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            FileSystem fileSystem = layerCacheManager.load(null, ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
            Enumeration enumeration = fileSystem.getRoot().getChildren(true);
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                object = (FileObject)enumeration.nextElement();
                if (!object.getNameExt().endsWith("_hidden")) continue;
                bl = true;
                break;
            }
            object = new PLFSCacheEntry(file2, file2.length(), file2.lastModified(), false, bl, fileSystem, byArray);
            pLFSCache.add((PLFSCacheEntry)object);
        }
        return pLFSCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PLFSCache loadCache(File file) {
        assert (ClusterUtils.isValidCluster(file));
        File file2 = new File(file, "modules");
        PLFSCache pLFSCache = new PLFSCache();
        LayerCacheManager layerCacheManager = LayerCacheManager.manager((boolean)true);
        try {
            File file3 = PlatformLayersCacheManager.findCacheFile(file);
            if (file3 == null) {
                return null;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file3);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = objectInputStream.readInt();
                assert (n == 1);
                int n2 = objectInputStream.readInt();
                int i = 0;
                while (i < n2) {
                    String string = (String)objectInputStream.readObject();
                    File file4 = new File(file2, string);
                    long l = objectInputStream.readLong();
                    long l2 = objectInputStream.readLong();
                    boolean bl = objectInputStream.readBoolean();
                    boolean bl2 = false;
                    FileSystem fileSystem = null;
                    byte[] byArray = null;
                    if (!bl) {
                        bl2 = objectInputStream.readBoolean();
                        int n3 = objectInputStream.readInt();
                        byArray = new byte[n3];
                        objectInputStream.readFully(byArray, 0, n3);
                        fileSystem = layerCacheManager.load(null, ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
                    }
                    pLFSCache.add(new PLFSCacheEntry(file4, l, l2, bl, bl2, fileSystem, byArray));
                    ++i;
                }
                return pLFSCache;
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.WARNING, "Exception while loading project layers cache (from file " + file3.getAbsolutePath() + " for cluster " + file + "): " + fileNotFoundException.toString());
                PLFSCache pLFSCache2 = null;
                return pLFSCache2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.WARNING, "Exception while loading project layers cache (from file " + file3.getAbsolutePath() + " for cluster " + file + "): " + classNotFoundException.toString());
                PLFSCache pLFSCache3 = null;
                return pLFSCache3;
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "IOException during loading project layers cache (for cluster " + file + "): " + iOException.toString());
            return null;
        }
    }

    static {
        LOGGER = Logger.getLogger(PlatformLayersCacheManager.class.getName());
        cacheLocation = new File(System.getProperty("netbeans.user"), "var/cache/nbplfsc");
        if (!cacheLocation.exists() && !cacheLocation.mkdirs()) {
            throw new RuntimeException("Cannot create cache dir " + System.getProperty("netbeans.user") + "/var/cache/nbplfsc");
        }
        RP = new RequestProcessor(PlatformLayersCacheManager.class.getName(), 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PLFSCache {
        private Map<File, PLFSCacheEntry> allEntries = new HashMap<File, PLFSCacheEntry>();
        private boolean modified;

        PLFSCache() {
        }

        private void add(PLFSCacheEntry pLFSCacheEntry) {
            this.allEntries.put(pLFSCacheEntry.getJar(), pLFSCacheEntry);
        }

        private Map<File, PLFSCacheEntry> getEntries() {
            return Collections.unmodifiableMap(this.allEntries);
        }

        private PLFSCacheEntry getEntry(File file) {
            return this.allEntries.get(file);
        }

        private boolean isModified() {
            return this.modified;
        }

        private void remove(PLFSCacheEntry pLFSCacheEntry) {
            this.allEntries.remove(pLFSCacheEntry.getJar());
        }
    }

    static class PLFSCacheEntry {
        private File jarFile;
        private long jarSize;
        private FileSystem fs;
        private boolean masked;
        private long jarTS;
        private boolean upToDate;
        private boolean ignored;
        private byte[] bytes;
        private boolean removed;

        private PLFSCacheEntry(File file, long l, long l2, boolean bl, boolean bl2, FileSystem fileSystem, byte[] byArray) {
            this.jarFile = file;
            this.jarSize = l;
            this.jarTS = l2;
            this.masked = bl2;
            this.ignored = bl;
            this.fs = fileSystem;
            this.bytes = byArray;
        }

        boolean checkUpToDate() {
            this.upToDate = this.jarFile.exists() && this.jarFile.length() == this.jarSize && this.jarFile.lastModified() == this.jarTS;
            return this.upToDate;
        }

        FileSystem getFS() {
            return this.fs;
        }

        File getJar() {
            return this.jarFile;
        }

        private boolean isMasked() {
            return this.masked;
        }

        private void updateValues(PLFSCache pLFSCache) {
            this.jarSize = this.jarFile.length();
            this.jarTS = this.jarFile.lastModified();
            pLFSCache.modified = true;
            anyModified = true;
        }

        static /* synthetic */ byte[] access$1202(PLFSCacheEntry pLFSCacheEntry, byte[] byArray) {
            pLFSCacheEntry.bytes = byArray;
            return byArray;
        }
    }
}

