/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneIndex
extends Index {
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    private static final String REFERENCES = "refs";
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final File refCacheRoot;
    private Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private Set<String> rootPkgCache;
    private Analyzer analyzer;
    private volatile boolean closed;

    static Index create(File file) throws IOException {
        assert (file != null && file.exists() && file.canRead() && file.canWrite());
        return new LuceneIndex(LuceneIndex.getReferencesCacheFolder(file));
    }

    private LuceneIndex(File file) throws IOException {
        assert (file != null);
        this.refCacheRoot = file;
        this.directory = FSDirectory.getDirectory((File)this.refCacheRoot, (LockFactory)NoLockFactory.getNoLockFactory());
        PerFieldAnalyzerWrapper perFieldAnalyzerWrapper = new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer());
        perFieldAnalyzerWrapper.addAnalyzer(DocumentUtil.identTerm("").field(), (Analyzer)new WhitespaceAnalyzer());
        perFieldAnalyzerWrapper.addAnalyzer(DocumentUtil.featureIdentTerm("").field(), (Analyzer)new WhitespaceAnalyzer());
        perFieldAnalyzerWrapper.addAnalyzer(DocumentUtil.caseInsensitiveFeatureIdentTerm("").field(), (Analyzer)new DocumentUtil.LCWhitespaceAnalyzer());
        this.analyzer = perFieldAnalyzerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesFQN(String string, Set<ClassIndexImpl.UsageType> set, Index.BooleanOperator booleanOperator) throws IOException, InterruptedException {
        Object object;
        this.checkPreconditions();
        if (!this.isValid(false)) {
            return null;
        }
        AtomicBoolean atomicBoolean = (AtomicBoolean)cancel.get();
        assert (atomicBoolean != null);
        assert (string != null);
        assert (set != null);
        assert (booleanOperator != null);
        IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
        try {
            WildcardQuery wildcardQuery;
            BooleanQuery booleanQuery;
            WildcardQuery wildcardQuery2;
            LinkedList<String> linkedList = new LinkedList<String>();
            switch (booleanOperator) {
                case AND: {
                    wildcardQuery2 = new WildcardQuery(DocumentUtil.referencesTerm(string, set));
                    break;
                }
                case OR: {
                    booleanQuery = new BooleanQuery();
                    for (ClassIndexImpl.UsageType usageType : set) {
                        wildcardQuery = new WildcardQuery(DocumentUtil.referencesTerm(string, EnumSet.of(usageType)));
                        booleanQuery.add((Query)wildcardQuery, BooleanClause.Occur.SHOULD);
                    }
                    wildcardQuery2 = booleanQuery;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(booleanOperator.toString());
                }
            }
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            booleanQuery = indexSearcher.search((Query)wildcardQuery2);
            object = booleanQuery.iterator();
            while (object.hasNext()) {
                ClassIndexImpl.UsageType usageType;
                if (atomicBoolean.get()) {
                    throw new InterruptedException();
                }
                usageType = (Hit)object.next();
                wildcardQuery = usageType.getDocument();
                String string2 = DocumentUtil.getBinaryName((Document)wildcardQuery);
                linkedList.add(string2);
            }
            object = linkedList;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            indexSearcher.close();
            throw throwable;
        }
        indexSearcher.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourceName(String string) throws IOException {
        Hits hits;
        IndexSearcher indexSearcher;
        block4: {
            String string2;
            this.checkPreconditions();
            if (!this.isValid(false)) {
                return null;
            }
            indexSearcher = new IndexSearcher(this.getReader());
            try {
                hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
                if (hits.length() != 0) break block4;
                string2 = null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                indexSearcher.close();
                throw throwable;
            }
            indexSearcher.close();
            return string2;
        }
        Hit hit = (Hit)hits.iterator().next();
        String string3 = DocumentUtil.getSourceName(hit.getDocument());
        Object var7_7 = null;
        indexSearcher.close();
        return string3;
    }

    @Override
    public <T> void getDeclaredTypes(String string, ClassIndex.NameKind nameKind, ResultConvertor<T> resultConvertor, Set<? super T> set) throws IOException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        this.checkPreconditions();
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        AtomicBoolean atomicBoolean = (AtomicBoolean)cancel.get();
        assert (atomicBoolean != null);
        assert (string != null);
        TreeSet<Term> treeSet = new TreeSet<Term>(new TermComparator());
        IndexReader indexReader = this.getReader();
        switch (nameKind) {
            case SIMPLE_NAME: {
                treeSet.add(DocumentUtil.simpleNameTerm(string));
                break;
            }
            case PREFIX: {
                if (string.length() == 0) {
                    this.emptyPrefixSearch(indexReader, resultConvertor, set, atomicBoolean);
                    return;
                }
                object3 = DocumentUtil.simpleNameTerm(string);
                this.prefixSearh((Term)object3, indexReader, treeSet, atomicBoolean);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (string.length() == 0) {
                    this.emptyPrefixSearch(indexReader, resultConvertor, set, atomicBoolean);
                    return;
                }
                object3 = DocumentUtil.caseInsensitiveNameTerm(string.toLowerCase());
                this.prefixSearh((Term)object3, indexReader, treeSet, atomicBoolean);
                break;
            }
            case CAMEL_CASE: {
                Object object4;
                int n3;
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                object3 = new StringBuilder();
                object2 = null;
                int n2 = 0;
                do {
                    object4 = string.substring(n2, (n3 = LuceneIndex.findNextUpper(string, n2 + 1)) == -1 ? string.length() : n3);
                    if (n2 == 0) {
                        object2 = object4;
                    }
                    ((StringBuilder)object3).append((String)object4);
                    ((StringBuilder)object3).append(n3 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n2 = n3;
                } while (n3 != -1);
                object4 = Pattern.compile(((StringBuilder)object3).toString());
                this.regExpSearch((Pattern)object4, DocumentUtil.simpleNameTerm((String)object2), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                object3 = Pattern.compile(string, 2);
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    this.regExpSearch((Pattern)object3, DocumentUtil.caseInsensitiveNameTerm(string.toLowerCase()), indexReader, treeSet, atomicBoolean, false);
                    break;
                }
                this.regExpSearch((Pattern)object3, DocumentUtil.caseInsensitiveNameTerm(""), indexReader, treeSet, atomicBoolean, false);
                break;
            }
            case REGEXP: {
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                object3 = Pattern.compile(string);
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    this.regExpSearch((Pattern)object3, DocumentUtil.simpleNameTerm(string), indexReader, treeSet, atomicBoolean, true);
                    break;
                }
                this.regExpSearch((Pattern)object3, DocumentUtil.simpleNameTerm(""), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            case CAMEL_CASE_INSENSITIVE: {
                int n;
                if (string.length() == 0) {
                    this.emptyPrefixSearch(indexReader, resultConvertor, set, atomicBoolean);
                    return;
                }
                object3 = DocumentUtil.caseInsensitiveNameTerm(string.toLowerCase());
                this.prefixSearh((Term)object3, indexReader, treeSet, atomicBoolean);
                object2 = new StringBuilder();
                String string2 = null;
                int n3 = 0;
                do {
                    object = string.substring(n3, (n = LuceneIndex.findNextUpper(string, n3 + 1)) == -1 ? string.length() : n);
                    if (n3 == 0) {
                        string2 = object;
                    }
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n3 = n;
                } while (n != -1);
                object = Pattern.compile(((StringBuilder)object2).toString());
                this.regExpSearch((Pattern)object, DocumentUtil.simpleNameTerm(string2), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        object3 = indexReader.termDocs();
        LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), treeSet.size()));
        object2 = treeSet.iterator();
        ElementKind[] elementKindArray = new ElementKind[1];
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        int[] nArray = new int[25];
        object = new int[25];
        block11: while (object2.hasNext()) {
            int n;
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            object3.seek((Term)object2.next());
            while ((n = object3.read(nArray, (int[])object)) > 0) {
                for (int i = 0; i < n; ++i) {
                    treeSet2.add(nArray[i]);
                }
                if (n >= nArray.length) continue;
                continue block11;
            }
        }
        for (Integer n : treeSet2) {
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            Document document = indexReader.document(n.intValue(), DocumentUtil.declaredTypesFieldSelector());
            String string3 = DocumentUtil.getBinaryName(document, elementKindArray);
            set.add(resultConvertor.convert(elementKindArray[0], string3));
        }
    }

    @Override
    public <T> void getDeclaredElements(String string, ClassIndex.NameKind nameKind, ResultConvertor<T> resultConvertor, Map<T, Set<String>> map) throws IOException, InterruptedException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.checkPreconditions();
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        AtomicBoolean atomicBoolean = (AtomicBoolean)cancel.get();
        assert (atomicBoolean != null);
        Parameters.notNull((CharSequence)"ident", (Object)string);
        Parameters.notEmpty((CharSequence)"ident", (CharSequence)string);
        TreeSet<Term> treeSet = new TreeSet<Term>(new TermComparator());
        IndexReader indexReader = this.getReader();
        switch (nameKind) {
            case SIMPLE_NAME: {
                treeSet.add(DocumentUtil.featureIdentTerm(string));
                break;
            }
            case PREFIX: {
                object4 = DocumentUtil.featureIdentTerm(string);
                this.prefixSearh((Term)object4, indexReader, treeSet, atomicBoolean);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                object4 = DocumentUtil.caseInsensitiveFeatureIdentTerm(string.toLowerCase());
                this.prefixSearh((Term)object4, indexReader, treeSet, atomicBoolean);
                break;
            }
            case REGEXP: {
                object4 = Pattern.compile(string);
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    this.regExpSearch((Pattern)object4, DocumentUtil.featureIdentTerm(string), indexReader, treeSet, atomicBoolean, true);
                    break;
                }
                this.regExpSearch((Pattern)object4, DocumentUtil.featureIdentTerm(""), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                object4 = Pattern.compile(string, 2);
                if (Character.isJavaIdentifierStart(string.charAt(0))) {
                    this.regExpSearch((Pattern)object4, DocumentUtil.caseInsensitiveFeatureIdentTerm(string.toLowerCase()), indexReader, treeSet, atomicBoolean, false);
                    break;
                }
                this.regExpSearch((Pattern)object4, DocumentUtil.caseInsensitiveFeatureIdentTerm(""), indexReader, treeSet, atomicBoolean, false);
                break;
            }
            case CAMEL_CASE: {
                Object object5;
                int n3;
                object4 = new StringBuilder();
                object3 = null;
                int n2 = 0;
                do {
                    object5 = string.substring(n2, (n3 = LuceneIndex.findNextUpper(string, n2 + 1)) == -1 ? string.length() : n3);
                    if (n2 == 0) {
                        object3 = object5;
                    }
                    ((StringBuilder)object4).append((String)object5);
                    ((StringBuilder)object4).append(n3 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n2 = n3;
                } while (n3 != -1);
                object5 = Pattern.compile(((StringBuilder)object4).toString());
                this.regExpSearch((Pattern)object5, DocumentUtil.featureIdentTerm((String)object3), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            case CAMEL_CASE_INSENSITIVE: {
                int n;
                object4 = DocumentUtil.caseInsensitiveFeatureIdentTerm(string.toLowerCase());
                this.prefixSearh((Term)object4, indexReader, treeSet, atomicBoolean);
                object3 = new StringBuilder();
                String string2 = null;
                int n3 = 0;
                do {
                    object2 = string.substring(n3, (n = LuceneIndex.findNextUpper(string, n3 + 1)) == -1 ? string.length() : n);
                    if (n3 == 0) {
                        string2 = object2;
                    }
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n3 = n;
                } while (n != -1);
                object2 = Pattern.compile(((StringBuilder)object3).toString());
                this.regExpSearch((Pattern)object2, DocumentUtil.featureIdentTerm(string2), indexReader, treeSet, atomicBoolean, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        object4 = indexReader.termDocs();
        LOGGER.fine(String.format("LuceneIndex.getDeclaredElements[%s] returned %d elements\n", this.toString(), treeSet.size()));
        object3 = treeSet.iterator();
        ElementKind[] elementKindArray = new ElementKind[1];
        HashMap<Integer, Document> hashMap = new HashMap<Integer, Document>();
        int[] nArray = new int[25];
        object2 = new int[25];
        block11: while (object3.hasNext()) {
            int n;
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            Term term = (Term)object3.next();
            object4.seek(term);
            while ((n = object4.read(nArray, (int[])object2)) > 0) {
                for (int i = 0; i < n; ++i) {
                    object = (Set)hashMap.get(nArray[i]);
                    if (object == null) {
                        object = new HashSet();
                        hashMap.put(nArray[i], (Document)object);
                    }
                    object.add(term.text());
                }
                if (n >= nArray.length) continue;
                continue block11;
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            object = indexReader.document(((Integer)entry.getKey()).intValue(), DocumentUtil.declaredTypesFieldSelector());
            String string3 = DocumentUtil.getBinaryName(object, elementKindArray);
            map.put(resultConvertor.convert(elementKindArray[0], string3), (Set<String>)entry.getValue());
        }
    }

    private static int findNextUpper(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regExpSearch(Pattern pattern, Term term, IndexReader indexReader, Set<Term> set, AtomicBoolean atomicBoolean, boolean bl) throws IOException, InterruptedException {
        String string;
        CharSequence charSequence;
        String string2 = term.text();
        if (string2.length() > 0) {
            char c;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2.charAt(0));
            for (int i = 1; i < string2.length() && Character.isJavaIdentifierPart(c = string2.charAt(i)); ++i) {
                ((StringBuilder)charSequence).append(c);
            }
            string = ((StringBuilder)charSequence).toString();
            term = new Term(term.field(), string);
        } else {
            string = string2;
        }
        charSequence = term.field();
        TermEnum termEnum = indexReader.terms(term);
        try {
            do {
                if (atomicBoolean.get()) {
                    throw new InterruptedException();
                }
                Term term2 = termEnum.term();
                if (term2 == null || charSequence != term2.field() || !term2.text().startsWith(string)) break;
                Matcher matcher = pattern.matcher(term2.text());
                if (!matcher.matches()) continue;
                set.add(term2);
            } while (termEnum.next());
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            termEnum.close();
            throw throwable;
        }
        termEnum.close();
    }

    private <T> void emptyPrefixSearch(IndexReader indexReader, ResultConvertor<T> resultConvertor, Set<? super T> set, AtomicBoolean atomicBoolean) throws IOException, InterruptedException {
        int n = indexReader.maxDoc();
        ElementKind[] elementKindArray = new ElementKind[1];
        for (int i = 0; i < n; ++i) {
            String string;
            Document document;
            if (atomicBoolean.get()) {
                throw new InterruptedException();
            }
            if (indexReader.isDeleted(i) || (document = indexReader.document(i, DocumentUtil.declaredTypesFieldSelector())) == null || (string = DocumentUtil.getBinaryName(document, elementKindArray)) == null) continue;
            set.add(resultConvertor.convert(elementKindArray[0], string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefixSearh(Term term, IndexReader indexReader, Set<Term> set, AtomicBoolean atomicBoolean) throws IOException, InterruptedException {
        String string = term.field();
        String string2 = term.text();
        TermEnum termEnum = indexReader.terms(term);
        try {
            do {
                if (atomicBoolean.get()) {
                    throw new InterruptedException();
                }
                Term term2 = termEnum.term();
                if (term2 == null || string != term2.field() || !term2.text().startsWith(string2)) break;
                set.add(term2);
            } while (termEnum.next());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            termEnum.close();
            throw throwable;
        }
        termEnum.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPackageNames(String string, boolean bl, Set<String> set) throws IOException, InterruptedException {
        block16: {
            this.checkPreconditions();
            if (bl && this.rootPkgCache != null && string.length() == 0) {
                set.addAll(this.rootPkgCache);
                return;
            }
            if (!this.isValid(false)) {
                return;
            }
            AtomicBoolean atomicBoolean = (AtomicBoolean)cancel.get();
            assert (atomicBoolean != null);
            IndexReader indexReader = this.getReader();
            Term term = DocumentUtil.packageNameTerm(string);
            String string2 = term.field();
            if (string.length() == 0) {
                if (bl) {
                    this.rootPkgCache = new HashSet<String>();
                }
                TermEnum termEnum = indexReader.terms();
                try {
                    do {
                        if (atomicBoolean.get()) {
                            throw new InterruptedException();
                        }
                        Term term2 = termEnum.term();
                        if (term2 == null || string2 != term2.field()) continue;
                        String string3 = term2.text();
                        if (bl) {
                            int n = string3.indexOf(46, string.length());
                            if (n > 0) {
                                string3 = string3.substring(0, n);
                            }
                            this.rootPkgCache.add(string3);
                        }
                        set.add(string3);
                    } while (termEnum.next());
                    Object var13_16 = null;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    termEnum.close();
                    throw throwable;
                }
                termEnum.close();
                {
                    break block16;
                }
            }
            TermEnum termEnum = indexReader.terms(term);
            try {
                do {
                    int n;
                    if (atomicBoolean.get()) {
                        throw new InterruptedException();
                    }
                    Term term3 = termEnum.term();
                    if (term3 == null || string2 != term3.field() || !term3.text().startsWith(string)) break;
                    String string4 = term3.text();
                    if (bl && (n = string4.indexOf(46, string.length())) > 0) {
                        string4 = string4.substring(0, n);
                    }
                    set.add(string4);
                } while (termEnum.next());
                Object var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                termEnum.close();
                throw throwable;
            }
            termEnum.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String string, long l) throws IOException {
        this.checkPreconditions();
        if (!this.isValid(false)) {
            return false;
        }
        try {
            boolean bl;
            IndexSearcher indexSearcher;
            block20: {
                boolean bl2;
                block19: {
                    boolean bl3;
                    block18: {
                        indexSearcher = new IndexSearcher(this.getReader());
                        try {
                            Hits hits;
                            LuceneIndex luceneIndex;
                            if (string == null) {
                                luceneIndex = this;
                                synchronized (luceneIndex) {
                                    if (this.rootTimeStamp != null) {
                                        bl3 = this.rootTimeStamp >= l;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 6, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var6_5
                                        Object var12_10 = null;
                                        break block18;
                                    }
                                }
                                hits = indexSearcher.search((Query)new TermQuery(DocumentUtil.rootDocumentTerm()));
                            } else {
                                hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
                            }
                            if (hits.length() != 1) {
                                bl2 = false;
                                break block19;
                            }
                            try {
                                luceneIndex = (Hit)hits.iterator().next();
                                long l2 = DocumentUtil.getTimeStamp(luceneIndex.getDocument());
                                if (string == null) {
                                    LuceneIndex luceneIndex2 = this;
                                    synchronized (luceneIndex2) {
                                        this.rootTimeStamp = new Long(l2);
                                    }
                                }
                                bl = l2 >= l;
                                break block20;
                            }
                            catch (ParseException parseException) {
                                throw new IOException();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            indexSearcher.close();
                            throw throwable;
                        }
                    }
                    indexSearcher.close();
                    return bl3;
                }
                Object var12_11 = null;
                indexSearcher.close();
                return bl2;
            }
            Object var12_12 = null;
            indexSearcher.close();
            return bl;
        }
        catch (IOException iOException) {
            this.clear();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<Pair<String, String>, Object[]> map, List<Pair<String, String>> list) throws IOException {
        this.checkPreconditions();
        assert (ClassIndexManager.getDefault().holdsWriteLock());
        this.rootPkgCache = null;
        boolean bl = !this.isValid(false);
        long l = System.currentTimeMillis();
        if (!bl) {
            IndexReader indexReader = this.getReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            try {
                for (Pair<String, String> pair : list) {
                    Hits hits = indexSearcher.search(DocumentUtil.binaryContentNameQuery(pair));
                    for (int i = 0; i < hits.length(); ++i) {
                        indexReader.deleteDocument(hits.id(i));
                    }
                }
                indexReader.deleteDocuments(DocumentUtil.rootDocumentTerm());
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                indexSearcher.close();
                throw throwable;
            }
            indexSearcher.close();
            {
            }
        }
        this.storeData(map, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<Pair<String, String>, Object[]> map, Set<Pair<String, String>> set) throws IOException {
        this.checkPreconditions();
        assert (ClassIndexManager.getDefault().holdsWriteLock());
        this.rootPkgCache = null;
        boolean bl = !this.isValid(false);
        long l = System.currentTimeMillis();
        if (!bl) {
            IndexReader indexReader = this.getReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            try {
                for (Pair<String, String> pair : set) {
                    int n;
                    Hits hits = indexSearcher.search(DocumentUtil.binaryNameSourceNamePairQuery(pair));
                    int[] nArray = new int[hits.length()];
                    int n2 = 0;
                    if (nArray.length == 1) {
                        nArray[0] = hits.id(0);
                        n2 = 1;
                    } else if (nArray.length > 1) {
                        n = pair.second != null ? 1 : 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (n == 0) {
                                Document document = hits.doc(i);
                                if (DocumentUtil.getSourceName(document) != null) continue;
                                nArray[n2++] = hits.id(i);
                                continue;
                            }
                            nArray[n2++] = hits.id(i);
                        }
                        if (n2 > 1) {
                            LOGGER.warning("Multiple index entries for binaryName: " + pair);
                        }
                    }
                    for (n = 0; n < n2; ++n) {
                        indexReader.deleteDocument(nArray[n]);
                    }
                }
                indexReader.deleteDocuments(DocumentUtil.rootDocumentTerm());
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                indexSearcher.close();
                throw throwable;
            }
            indexSearcher.close();
            {
            }
        }
        this.storeData(map, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeData(Map<Pair<String, String>, Object[]> map, boolean bl, long l) throws IOException {
        IndexWriter indexWriter = this.getWriter(bl);
        try {
            LuceneIndexMBeanImpl luceneIndexMBeanImpl;
            if (debugIndexMerging) {
                indexWriter.setInfoStream(System.err);
            }
            if ((luceneIndexMBeanImpl = LuceneIndexMBeanImpl.getDefault()) != null) {
                indexWriter.setMergeFactor(luceneIndexMBeanImpl.getMergeFactor());
                indexWriter.setMaxMergeDocs(luceneIndexMBeanImpl.getMaxMergeDocs());
                indexWriter.setMaxBufferedDocs(luceneIndexMBeanImpl.getMaxBufferedDocs());
            }
            LowMemoryNotifier lowMemoryNotifier = LowMemoryNotifier.getDefault();
            LMListener lMListener = new LMListener();
            lowMemoryNotifier.addLowMemoryListener(lMListener);
            RAMDirectory rAMDirectory = null;
            IndexWriter indexWriter2 = null;
            if (lMListener.lowMemory.getAndSet(false)) {
                indexWriter2 = indexWriter;
            } else {
                rAMDirectory = new RAMDirectory();
                indexWriter2 = new IndexWriter((Directory)rAMDirectory, this.analyzer, true);
            }
            try {
                indexWriter2.addDocument(DocumentUtil.createRootTimeStampDocument(l));
                Object object = map.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<Pair<String, String>, Object[]> entry = object.next();
                    object.remove();
                    Pair<String, String> pair = entry.getKey();
                    String string = (String)pair.first;
                    String string2 = (String)pair.second;
                    Object[] objectArray = entry.getValue();
                    List list = (List)objectArray[0];
                    String string3 = (String)objectArray[1];
                    String string4 = (String)objectArray[2];
                    Document document = DocumentUtil.createDocument(string, l, list, string3, string4, string2);
                    indexWriter2.addDocument(document);
                    if (rAMDirectory == null || !lMListener.lowMemory.getAndSet(false)) continue;
                    indexWriter2.close();
                    indexWriter.addIndexes(new Directory[]{rAMDirectory});
                    rAMDirectory = new RAMDirectory();
                    indexWriter2 = new IndexWriter((Directory)rAMDirectory, this.analyzer, true);
                }
                if (rAMDirectory != null) {
                    indexWriter2.close();
                    indexWriter.addIndexes(new Directory[]{rAMDirectory});
                    indexWriter2 = null;
                    rAMDirectory = null;
                }
                object = this;
                synchronized (object) {
                    this.rootTimeStamp = new Long(l);
                }
                Object var23_21 = null;
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
            catch (Throwable throwable) {
                Object var23_22 = null;
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
                throw throwable;
            }
            Object var25_24 = null;
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            indexWriter.close();
            throw throwable;
        }
        indexWriter.close();
    }

    @Override
    public boolean isValid(boolean bl) throws IOException {
        this.checkPreconditions();
        boolean bl2 = false;
        try {
            bl2 = IndexReader.indexExists((Directory)this.directory);
        }
        catch (IOException iOException) {
            return bl2;
        }
        if (bl2 && bl) {
            try {
                this.getReader();
            }
            catch (IOException iOException) {
                bl2 = false;
                this.clear();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() throws IOException {
        this.checkPreconditions();
        this.rootPkgCache = null;
        this.close(false);
        try {
            File[] fileArray;
            String[] stringArray = this.directory.list();
            boolean bl = false;
            Object object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string = object[i];
                try {
                    this.directory.deleteFile(string);
                    continue;
                }
                catch (IOException iOException) {
                    if (!this.directory.fileExists(string)) continue;
                    bl = true;
                }
            }
            if (bl && (fileArray = ((File)(object = ((FSDirectory)this.directory).getFile())).listFiles()) != null) {
                for (File file : fileArray) {
                    if (file.delete()) continue;
                    Class<?> clazz = this.directory.getClass();
                    int n2 = -1;
                    try {
                        Field field = clazz.getDeclaredField("refCount");
                        field.setAccessible(true);
                        n2 = field.getInt(this.directory);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    throw new IOException("Cannot delete: " + file.getAbsolutePath() + "(" + file.exists() + "," + file.canRead() + "," + file.canWrite() + "," + ((File)object).canRead() + "," + ((File)object).canWrite() + "," + n2 + ")");
                }
            }
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            this.close(true);
            this.directory = FSDirectory.getDirectory((File)this.refCacheRoot, (LockFactory)NoLockFactory.getNoLockFactory());
            this.closed = false;
            throw throwable;
        }
        this.close(true);
        this.directory = FSDirectory.getDirectory((File)this.refCacheRoot, (LockFactory)NoLockFactory.getNoLockFactory());
        this.closed = false;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close(boolean bl) throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            Object var3_2 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!bl) throw throwable;
            this.directory.close();
            this.closed = true;
            throw throwable;
        }
        this.directory.close();
        this.closed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.refCacheRoot.getAbsolutePath() + "]";
    }

    private synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            try {
                this.reader = new NoNormsReader(IndexReader.open((Directory)this.directory));
            }
            catch (IOException iOException) {
                throw this.annotateException(iOException);
            }
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean bl) throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        try {
            IndexWriter indexWriter = new IndexWriter(this.directory, this.analyzer, bl);
            return indexWriter;
        }
        catch (IOException iOException) {
            throw this.annotateException(iOException);
        }
    }

    private IOException annotateException(IOException iOException) {
        String string;
        File[] fileArray = this.refCacheRoot.listFiles();
        if (fileArray == null) {
            string = "Non existing index folder";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : fileArray) {
                stringBuilder.append(file.getName() + " f: " + file.isFile() + " r: " + file.canRead() + " w: " + file.canWrite() + "\n");
            }
            string = stringBuilder.toString();
        }
        return (IOException)Exceptions.attachMessage((Throwable)iOException, (String)string);
    }

    private static File getReferencesCacheFolder(File file) throws IOException {
        File file2 = new File(file, REFERENCES);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return file2;
    }

    private void checkPreconditions() throws ClassIndexImpl.IndexAlreadyClosedException {
        if (this.closed) {
            throw new ClassIndexImpl.IndexAlreadyClosedException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TermComparator
    implements Comparator<Term> {
        private TermComparator() {
        }

        @Override
        public int compare(Term term, Term term2) {
            int n = term.field().compareTo(term2.field());
            if (n == 0) {
                n = term.text().compareTo(term2.text());
            }
            return n;
        }
    }

    private static class NoNormsReader
    extends FilterIndexReader {
        private byte[] norms;

        public NoNormsReader(IndexReader indexReader) {
            super(indexReader);
        }

        public byte[] norms(String string) throws IOException {
            byte[] byArray = this.fakeNorms();
            return byArray;
        }

        public void norms(String string, byte[] byArray, int n) throws IOException {
            byte[] byArray2 = this.fakeNorms();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }

        public boolean hasNorms(String string) throws IOException {
            return false;
        }

        protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doClose() throws IOException {
            NoNormsReader noNormsReader = this;
            synchronized (noNormsReader) {
                this.norms = null;
            }
            super.doClose();
        }

        private synchronized byte[] fakeNorms() {
            if (this.norms == null) {
                this.norms = new byte[this.maxDoc()];
                Arrays.fill(this.norms, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            return this.norms;
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }
}

