/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.source.tasklist.RebuildOraculum;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstParseCatcher
extends EditorAwareJavaSourceTaskFactory {
    public FirstParseCatcher() {
        super(JavaSource.Phase.ELEMENTS_RESOLVED, JavaSource.Priority.ABOVE_NORMAL);
    }

    @Override
    public CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
        return new CancellableTask<CompilationInfo>(){

            @Override
            public void cancel() {
            }

            @Override
            public void run(final CompilationInfo compilationInfo) throws Exception {
                Logger.getLogger(FirstParseCatcher.class.getName()).entering(FirstParseCatcher.class.getName(), "run", compilationInfo.getFileObject());
                long l = System.currentTimeMillis();
                URL uRL = compilationInfo.getFileObject().getURL();
                if (RebuildOraculum.isInitialized(uRL)) {
                    Logger.getLogger(FirstParseCatcher.class.getName()).finer("Oraculum is initialized.");
                    Logger.getLogger(FirstParseCatcher.class.getName()).exiting(FirstParseCatcher.class.getName(), "run");
                    return;
                }
                final ArrayList arrayList = new ArrayList();
                new TreePathScanner(){

                    public Object visitClass(ClassTree classTree, Object object) {
                        arrayList.add((TypeElement)compilationInfo.getTrees().getElement(this.getCurrentPath()));
                        return null;
                    }
                }.scan(compilationInfo.getCompilationUnit(), null);
                Logger.getLogger(FirstParseCatcher.class.getName()).log(Level.FINER, "Found type={0}.", arrayList);
                RebuildOraculum.putMembers(uRL, RebuildOraculum.sortOut(compilationInfo.getElements(), arrayList));
                if (compilationInfo.getFileObject() != null) {
                    Logger.getLogger("TIMER").log(Level.FINE, "First Parse Catcher", new Object[]{compilationInfo.getFileObject(), System.currentTimeMillis() - l});
                }
                Logger.getLogger(FirstParseCatcher.class.getName()).exiting(FirstParseCatcher.class.getName(), "run");
            }
        };
    }
}

