/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class JavaIndex {
    public static final String NAME = "java";
    public static final int VERSION = 13;
    static final Logger LOG = Logger.getLogger(JavaIndex.class.getName());
    private static final String CLASSES = "classes";
    private static final String ATTR_FILE_NAME = "attributes.properties";

    public static File getIndex(Context context) {
        return FileUtil.toFile((FileObject)context.getIndexFolder());
    }

    public static File getIndex(URL uRL) throws IOException {
        FileObject fileObject = CacheFolder.getDataFolder((URL)uRL);
        String string = SPIAccessor.getInstance().getIndexerPath(NAME, 13);
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
        return FileUtil.toFile((FileObject)fileObject2);
    }

    public static File getClassFolder(Context context) {
        return JavaIndex.getClassFolder(context, false);
    }

    public static File getClassFolder(Context context, boolean bl) {
        return JavaIndex.processCandidate(new File(JavaIndex.getIndex(context), CLASSES), bl);
    }

    public static File getClassFolder(File file) throws IOException {
        return JavaIndex.getClassFolder(file.toURI().toURL());
    }

    public static File getClassFolder(URL uRL) throws IOException {
        return JavaIndex.getClassFolder(uRL, false);
    }

    public static File getClassFolder(URL uRL, boolean bl) throws IOException {
        return JavaIndex.processCandidate(new File(JavaIndex.getIndex(uRL), CLASSES), bl);
    }

    public static URL getSourceRootForClassFolder(URL uRL) {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null || !CLASSES.equals(fileObject.getName())) {
            return null;
        }
        if ((fileObject = fileObject.getParent()) == null || !String.valueOf(13).equals(fileObject.getName())) {
            return null;
        }
        if ((fileObject = fileObject.getParent()) == null || !NAME.equals(fileObject.getName())) {
            return null;
        }
        if ((fileObject = fileObject.getParent()) == null) {
            return null;
        }
        return CacheFolder.getSourceRootForDataFolder((FileObject)fileObject);
    }

    public static boolean ensureAttributeValue(URL uRL, String string, String string2, boolean bl) throws IOException {
        Properties properties = JavaIndex.loadProperties(uRL);
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            if (string2 != null) {
                properties.setProperty(string, string2);
                JavaIndex.storeProperties(uRL, properties);
            }
            return false;
        }
        if (string3.equals(string2)) {
            return false;
        }
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        JavaIndex.storeProperties(uRL, properties);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ensureAttributeValue attr: " + string + " current: " + string3 + " new: " + string2);
        }
        return true;
    }

    public static void setAttribute(URL uRL, String string, String string2) throws IOException {
        Properties properties = JavaIndex.loadProperties(uRL);
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        JavaIndex.storeProperties(uRL, properties);
    }

    public static String getAttribute(URL uRL, String string, String string2) throws IOException {
        Properties properties = JavaIndex.loadProperties(uRL);
        return properties.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL) throws IOException {
        File file = JavaIndex.getAttributeFile(uRL);
        Properties properties = new Properties();
        if (!file.exists()) {
            return properties;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                properties.load(bufferedInputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.warning("Broken attribute file: " + file.getAbsolutePath());
                Properties properties2 = new Properties();
                Object var7_5 = null;
                ((InputStream)bufferedInputStream).close();
                return properties2;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(URL uRL, Properties properties) throws IOException {
        File file = JavaIndex.getAttributeFile(uRL);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            properties.store(bufferedOutputStream, "");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)bufferedOutputStream).close();
            throw throwable;
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    private static File getAttributeFile(URL uRL) throws IOException {
        return new File(JavaIndex.getIndex(uRL), ATTR_FILE_NAME);
    }

    private static File processCandidate(File file, boolean bl) {
        if (bl) {
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        file.mkdirs();
        return file;
    }

    public static boolean isLibrary(ClassPath classPath) {
        assert (classPath != null);
        for (FileObject fileObject : classPath.getRoots()) {
            if (!JavaIndex.isLibrary(fileObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLibrary(FileObject fileObject) {
        assert (fileObject != null);
        try {
            return JavaIndex.isLibrary(fileObject.getURL());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            return true;
        }
    }

    public static boolean isLibrary(URL uRL) {
        assert (uRL != null);
        return ClassIndexManager.getDefault().getUsagesQuery(uRL) == null;
    }

    private JavaIndex() {
    }
}

