/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostFlowAnalysis
extends TreeScanner {
    private Log log;
    private Types types;
    private Enter enter;
    private Names names;
    private List<Pair<Symbol.TypeSymbol, Symbol>> outerThisStack;
    private Symbol.TypeSymbol currentClass;

    private PostFlowAnalysis(Context context) {
        this.log = Log.instance(context);
        this.types = Types.instance(context);
        this.enter = Enter.instance(context);
        this.names = Names.instance(context);
        this.outerThisStack = List.nil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyze(Iterable<? extends Element> iterable, Context context) {
        assert (iterable != null);
        PostFlowAnalysis postFlowAnalysis = new PostFlowAnalysis(context);
        for (Element element : iterable) {
            Object var8_7;
            Env<AttrContext> env;
            if (!(element instanceof Symbol.TypeSymbol) || (env = postFlowAnalysis.enter.getClassEnv((Symbol.TypeSymbol)element)) == null) continue;
            JavaFileObject javaFileObject = postFlowAnalysis.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                postFlowAnalysis.scan(env.toplevel);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                postFlowAnalysis.log.useSource(javaFileObject);
                throw throwable;
            }
            postFlowAnalysis.log.useSource(javaFileObject);
            {
            }
        }
    }

    private void analyze(Element element) {
        Env<AttrContext> env;
        if (element instanceof Symbol.TypeSymbol && (env = this.enter.getClassEnv((Symbol.TypeSymbol)element)) != null) {
            this.scan(env.toplevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        Symbol.TypeSymbol typeSymbol = this.currentClass;
        this.currentClass = jCClassDecl.sym;
        List<Pair<Symbol.TypeSymbol, Symbol>> list = this.outerThisStack;
        try {
            if (this.currentClass.hasOuterInstance()) {
                this.outerThisDef(this.currentClass);
            }
            super.visitClassDef(jCClassDecl);
            Object var5_4 = null;
            this.outerThisStack = list;
            this.currentClass = typeSymbol;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.outerThisStack = list;
            this.currentClass = typeSymbol;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        Object object;
        if (jCMethodDecl.name == this.names.init && (this.currentClass.isInner() || (this.currentClass.owner.kind & 0x14) != 0)) {
            object = this.outerThisStack;
            try {
                if (this.currentClass.hasOuterInstance()) {
                    this.outerThisDef(jCMethodDecl.sym);
                }
                super.visitMethodDef(jCMethodDecl);
                Object var4_3 = null;
                this.outerThisStack = object;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.outerThisStack = object;
                throw throwable;
            }
        } else {
            super.visitMethodDef(jCMethodDecl);
        }
        if (jCMethodDecl.sym == null || jCMethodDecl.type == null) {
            return;
        }
        object = this.types.erasure(jCMethodDecl.type);
        Scope.Entry entry = jCMethodDecl.sym.owner.members().lookup(jCMethodDecl.name);
        while (entry.sym != null) {
            if (entry.sym != jCMethodDecl.sym && this.types.isSameType(this.types.erasure(entry.sym.type), (Type)object)) {
                this.log.error(jCMethodDecl.pos(), "name.clash.same.erasure", new Object[]{jCMethodDecl.sym, entry.sym});
                return;
            }
            entry = entry.next();
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        Symbol symbol;
        super.visitNewClass(jCNewClass);
        Symbol symbol2 = symbol = jCNewClass.constructor != null ? jCNewClass.constructor.owner : null;
        if (symbol != null && symbol.hasOuterInstance() && jCNewClass.encl == null && (symbol.owner.kind & 0x14) != 0) {
            this.checkThis(jCNewClass.pos(), symbol.type.getEnclosingType().tsym);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        Symbol symbol;
        super.visitApply(jCMethodInvocation);
        Symbol symbol2 = TreeInfo.symbol(jCMethodInvocation.meth);
        Name name = TreeInfo.name(jCMethodInvocation.meth);
        if (symbol2 != null && symbol2.name == this.names.init && (symbol = symbol2.owner).hasOuterInstance() && jCMethodInvocation.meth.getTag() != 34 && ((symbol.owner.kind & 0x14) != 0 || name == this.names._this)) {
            this.checkThis(jCMethodInvocation.meth.pos(), symbol.type.getEnclosingType().tsym);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        super.visitSelect(jCFieldAccess);
        if ((jCFieldAccess.name == this.names._this || jCFieldAccess.name == this.names._super) && jCFieldAccess.selected.type != null) {
            this.checkThis(jCFieldAccess.pos(), jCFieldAccess.selected.type.tsym);
        }
    }

    private void checkThis(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if (this.currentClass != typeSymbol) {
            List<Pair<Symbol.TypeSymbol, Symbol>> list = this.outerThisStack;
            if (list.isEmpty()) {
                this.log.error(diagnosticPosition, "no.encl.instance.of.type.in.scope", new Object[]{typeSymbol});
                return;
            }
            Pair pair = (Pair)list.head;
            Symbol.TypeSymbol typeSymbol2 = (Symbol.TypeSymbol)pair.fst;
            while (typeSymbol2 != typeSymbol) {
                do {
                    if ((list = list.tail).isEmpty()) {
                        this.log.error(diagnosticPosition, "no.encl.instance.of.type.in.scope", new Object[]{typeSymbol});
                        return;
                    }
                    pair = (Pair)list.head;
                } while (pair.snd != typeSymbol2);
                if (typeSymbol2.owner.kind != true && !typeSymbol2.hasOuterInstance()) {
                    this.log.error(diagnosticPosition, "cant.ref.before.ctor.called", new Object[]{typeSymbol});
                    return;
                }
                typeSymbol2 = (Symbol.TypeSymbol)pair.fst;
            }
        }
    }

    private void outerThisDef(Symbol symbol) {
        Type type = this.types.erasure(symbol.enclClass().type.getEnclosingType());
        Pair<Symbol.TypeSymbol, Symbol> pair = Pair.of(type.tsym, symbol);
        this.outerThisStack = this.outerThisStack.prepend(pair);
    }
}

