/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.ClasspathInfoTask;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.JavacParserFactory;
import org.netbeans.modules.java.source.parsing.NewComilerTask;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.PatchedPublic;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSource {
    private final Collection<Source> sources;
    private final Collection<FileObject> files;
    private final ClasspathInfo classpathInfo;
    private ClasspathInfo cachedCpInfo;
    private static final Logger LOGGER;
    private static Map<FileObject, Reference<JavaSource>> file2JavaSource;

    @NullUnknown
    public static JavaSource create(@NonNull ClasspathInfo classpathInfo, FileObject ... fileObjectArray) throws IllegalArgumentException {
        if (fileObjectArray == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        return JavaSource.create(classpathInfo, Arrays.asList(fileObjectArray));
    }

    @NullUnknown
    public static JavaSource create(@NonNull ClasspathInfo classpathInfo, @NonNull Collection<? extends FileObject> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new JavaSource(classpathInfo, collection);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)dataObjectNotFoundException.getFileObject()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    @CheckForNull
    public static JavaSource forFileObject(@NonNull FileObject fileObject) throws IllegalArgumentException {
        Object object;
        Object object2;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid()) {
            return null;
        }
        try {
            if (fileObject.getFileSystem().isDefault() && fileObject.getAttribute("javax.script.ScriptEngine") != null && fileObject.getAttribute("template") == Boolean.TRUE) {
                return null;
            }
            object2 = DataObject.find((FileObject)fileObject);
            object = (EditorCookie)object2.getLookup().lookup(EditorCookie.class);
            if (!(object instanceof CloneableEditorSupport || "application/x-class-file".equals(FileUtil.getMIMEType((FileObject)fileObject)) || "class".equals(fileObject.getExt()))) {
                return null;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            LOGGER.log(Level.FINE, null, fileStateInvalidException);
            return null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOGGER.log(Level.FINE, null, dataObjectNotFoundException);
            return null;
        }
        object2 = file2JavaSource.get(fileObject);
        JavaSource javaSource = object = object2 != null ? (JavaSource)((Reference)object2).get() : null;
        if (object == null) {
            if ("application/x-class-file".equals(FileUtil.getMIMEType((FileObject)fileObject)) || "class".equals(fileObject.getExt())) {
                ClassPath classPath;
                ClassPath classPath2;
                ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                ClassPath classPath4 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                if (classPath4 == null) {
                    classPath4 = ClassPathSupport.createClassPath((URL[])new URL[0]);
                }
                if ((classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
                    classPath2 = ClassPathSupport.createClassPath((URL[])new URL[0]);
                }
                if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute")) != null) {
                    classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath3});
                }
                ClasspathInfo classpathInfo = ClasspathInfo.create(classPath3, classPath4, classPath2);
                FileObject fileObject2 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath3, classPath4, classPath2}).findOwnerRoot(fileObject);
                if (fileObject2 == null) {
                    return null;
                }
                try {
                    object = new JavaSource(classpathInfo, fileObject, fileObject2);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                if (!"text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject)) && !"java".equals(fileObject.getExt())) {
                    return null;
                }
                object = JavaSource.create(null, Collections.singletonList(fileObject));
            }
            file2JavaSource.put(fileObject, new WeakReference<EditorCookie>((EditorCookie)object));
        }
        return object;
    }

    @CheckForNull
    public static JavaSource forDocument(@NonNull Document document) throws IllegalArgumentException {
        DataObject dataObject;
        Object object;
        JavaSource javaSource;
        if (document == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference reference = (Reference)document.getProperty(JavaSource.class);
        JavaSource javaSource2 = javaSource = reference != null ? (JavaSource)reference.get() : null;
        if (javaSource == null && (object = document.getProperty("stream")) instanceof DataObject && (dataObject = (DataObject)object) != null) {
            javaSource = JavaSource.forFileObject(dataObject.getPrimaryFile());
        }
        return javaSource;
    }

    private JavaSource(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IOException {
        boolean bl = collection.size() > 1;
        LinkedList<Source> linkedList = new LinkedList<Source>();
        LinkedList<FileObject> linkedList2 = new LinkedList<FileObject>();
        for (FileObject fileObject : collection) {
            Logger.getLogger("TIMER").log(Level.FINE, "JavaSource", new Object[]{fileObject, this});
            if (!fileObject.isValid()) {
                if (bl) {
                    LOGGER.warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    continue;
                }
                DataObject.find((FileObject)fileObject);
                continue;
            }
            linkedList2.add(fileObject);
            linkedList.add(Source.create((FileObject)fileObject));
        }
        this.files = Collections.unmodifiableList(linkedList2);
        this.sources = Collections.unmodifiableList(linkedList);
        this.classpathInfo = classpathInfo;
    }

    private JavaSource(ClasspathInfo classpathInfo, FileObject fileObject, FileObject fileObject2) throws IOException {
        assert (classpathInfo != null);
        assert (fileObject != null);
        assert (fileObject2 != null);
        this.files = Collections.singletonList(fileObject);
        this.sources = Collections.singletonList(Source.create((FileObject)fileObject));
        this.classpathInfo = classpathInfo;
    }

    public void runUserActionTask(@NonNull Task<CompilationController> task, boolean bl) throws IOException {
        this.runUserActionTaskImpl(task, bl);
    }

    private long runUserActionTaskImpl(Task<CompilationController> task, boolean bl) throws IOException {
        Parameters.notNull((CharSequence)"task", task);
        long l = -1L;
        if (this.sources.isEmpty()) {
            try {
                ParserManager.parse((String)"text/x-java", (UserTask)new MimeTask(this, task, this.classpathInfo));
            }
            catch (ParseException parseException) {
                Throwable throwable = parseException.getCause();
                if (throwable instanceof Symbol.CompletionFailure) {
                    IOException iOException = new IOException();
                    iOException.initCause(throwable);
                    throw iOException;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
        }
        try {
            MultiTask multiTask = new MultiTask(this, task, this.classpathInfo);
            ParserManager.parse(this.sources, (UserTask)multiTask);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof Symbol.CompletionFailure) {
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            IOException iOException = new IOException();
            iOException.initCause(throwable);
            throw iOException;
        }
        return l;
    }

    @PatchedPublic
    private void runUserActionTask(CancellableTask<CompilationController> cancellableTask, boolean bl) throws IOException {
        CancellableTask<CompilationController> cancellableTask2 = cancellableTask;
        this.runUserActionTask((Task<CompilationController>)cancellableTask2, bl);
    }

    long createTaggedController(long l, Object[] objectArray) throws IOException {
        assert (objectArray.length == 1);
        assert (objectArray[0] == null || objectArray[0] instanceof CompilationController);
        try {
            CompilationController compilationController = (CompilationController)objectArray[0];
            NewComilerTask newComilerTask = new NewComilerTask(this.classpathInfo, compilationController, l);
            ParserManager.parse(this.sources, (UserTask)newComilerTask);
            objectArray[0] = newComilerTask.getCompilationController();
            return newComilerTask.getTimeStamp();
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof Symbol.CompletionFailure) {
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            IOException iOException = new IOException();
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    @NonNull
    public Future<Void> runWhenScanFinished(@NonNull Task<CompilationController> task, boolean bl) throws IOException {
        Parameters.notNull((CharSequence)"task", task);
        if (this.sources.isEmpty()) {
            try {
                return ParserManager.parseWhenScanFinished((String)"text/x-java", (UserTask)new MimeTask(this, task, this.classpathInfo));
            }
            catch (ParseException parseException) {
                Throwable throwable = parseException.getCause();
                if (throwable instanceof Symbol.CompletionFailure) {
                    IOException iOException = new IOException();
                    iOException.initCause(throwable);
                    throw iOException;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
        }
        try {
            MultiTask multiTask = new MultiTask(this, task, this.classpathInfo);
            return ParserManager.parseWhenScanFinished(this.sources, (UserTask)multiTask);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof Symbol.CompletionFailure) {
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            IOException iOException = new IOException();
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    @PatchedPublic
    private Future<Void> runWhenScanFinished(CancellableTask<CompilationController> cancellableTask, boolean bl) throws IOException {
        CancellableTask<CompilationController> cancellableTask2 = cancellableTask;
        return this.runWhenScanFinished((Task<CompilationController>)cancellableTask2, bl);
    }

    @NonNull
    public ModificationResult runModificationTask(final @NonNull Task<WorkingCopy> task) throws IOException {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (this.sources.isEmpty()) {
            throw new IllegalStateException("Cannot run modification task without  file.");
        }
        final ModificationResult modificationResult = new ModificationResult(this);
        long l = System.currentTimeMillis();
        try {
            final JavacParser[] javacParserArray = new JavacParser[1];
            ClasspathInfoTask classpathInfoTask = new ClasspathInfoTask(this.classpathInfo){

                public void run(ResultIterator resultIterator) throws Exception {
                    Snapshot snapshot = resultIterator.getSnapshot();
                    if ("text/x-java".equals(snapshot.getMimeType())) {
                        Parser.Result result = resultIterator.getParserResult();
                        CompilationController compilationController = CompilationController.get(result);
                        assert (compilationController != null);
                        WorkingCopy workingCopy = new WorkingCopy(compilationController.impl);
                        workingCopy.setJavaSource(JavaSource.this);
                        task.run(workingCopy);
                        JavacTaskImpl javacTaskImpl = workingCopy.impl.getJavacTask();
                        Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
                        javacParserArray[0] = workingCopy.impl.getParser();
                        List<ModificationResult.Difference> list = workingCopy.getChanges(modificationResult.tag2Span);
                        if (list != null && list.size() > 0) {
                            modificationResult.diffs.put(workingCopy.getFileObject(), list);
                        }
                    }
                }

                public String toString() {
                    return this.getClass().getName() + "[" + task.getClass().getName() + "]";
                }
            };
            ParserManager.parse(this.sources, (UserTask)classpathInfoTask);
            if (javacParserArray[0] != null) {
                javacParserArray[0].invalidate();
            }
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof Symbol.CompletionFailure) {
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            IOException iOException = new IOException();
            iOException.initCause(throwable);
            throw iOException;
        }
        if (this.sources.size() == 1) {
            Logger.getLogger("TIMER").log(Level.FINE, "Modification Task", new Object[]{this.sources.iterator().next().getFileObject(), System.currentTimeMillis() - l});
        }
        return modificationResult;
    }

    @PatchedPublic
    private ModificationResult runModificationTask(CancellableTask<WorkingCopy> cancellableTask) throws IOException {
        CancellableTask<WorkingCopy> cancellableTask2 = cancellableTask;
        return this.runModificationTask((Task<WorkingCopy>)cancellableTask2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClasspathInfo getClasspathInfo() {
        Object object = this;
        synchronized (object) {
            if (this.cachedCpInfo != null) {
                return this.cachedCpInfo;
            }
        }
        object = this.classpathInfo;
        if (object == null) {
            assert (!this.files.isEmpty());
            object = ClasspathInfo.create(this.files.iterator().next());
        }
        JavaSource javaSource = this;
        synchronized (javaSource) {
            if (this.cachedCpInfo == null) {
                this.cachedCpInfo = object;
            }
            return this.cachedCpInfo;
        }
    }

    @NonNull
    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    static {
        JavaSourceAccessor.setINSTANCE(new JavaSourceAccessorImpl());
        LOGGER = Logger.getLogger(JavaSource.class.getName());
        file2JavaSource = new WeakHashMap<FileObject, Reference<JavaSource>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSourceAccessorImpl
    extends JavaSourceAccessor {
        private JavaSourceAccessorImpl() {
        }

        @Override
        public JavacTaskImpl getJavacTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.impl.getJavacTask();
        }

        @Override
        public JavaSource create(ClasspathInfo classpathInfo, PositionConverter positionConverter, Collection<? extends FileObject> collection) throws IllegalArgumentException {
            return JavaSource.create(classpathInfo, collection);
        }

        @Override
        public CompilationController createCompilationController(Source source) throws IOException, ParseException {
            Parameters.notNull((CharSequence)"s", (Object)source);
            JavacParserFactory javacParserFactory = JavacParserFactory.getDefault();
            Snapshot snapshot = source.createSnapshot();
            JavacParser javacParser = javacParserFactory.createPrivateParser(snapshot);
            UserTask userTask = new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                }
            };
            javacParser.parse(snapshot, (org.netbeans.modules.parsing.api.Task)userTask, null);
            return CompilationController.get(javacParser.getResult((org.netbeans.modules.parsing.api.Task)userTask));
        }

        @Override
        public long createTaggedCompilationController(JavaSource javaSource, long l, Object[] objectArray) throws IOException {
            return javaSource.createTaggedController(l, objectArray);
        }

        @Override
        public CompilationInfo createCompilationInfo(CompilationInfoImpl compilationInfoImpl) {
            return new CompilationInfo(compilationInfoImpl);
        }

        @Override
        public CompilationController createCompilationController(CompilationInfoImpl compilationInfoImpl) {
            return new CompilationController(compilationInfoImpl);
        }

        @Override
        public void invalidate(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            compilationInfo.invalidate();
        }

        @Override
        public Collection<Source> getSources(JavaSource javaSource) {
            assert (javaSource != null);
            return javaSource.sources;
        }

        @Override
        public void setJavaSource(CompilationInfo compilationInfo, JavaSource javaSource) {
            assert (compilationInfo != null);
            assert (javaSource != null);
            compilationInfo.setJavaSource(javaSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateCachedClasspathInfo(FileObject fileObject) {
            JavaSource javaSource;
            assert (fileObject != null);
            Reference reference = (Reference)file2JavaSource.get(fileObject);
            if (reference != null && (javaSource = (JavaSource)reference.get()) != null) {
                JavaSource javaSource2 = javaSource;
                synchronized (javaSource2) {
                    javaSource.cachedCpInfo = null;
                }
            }
        }

        @Override
        public CompilationInfoImpl getCompilationInfoImpl(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.impl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MimeTask
    extends ClasspathInfoTask {
        private final Task<CompilationController> task;
        private final JavaSource js;

        public MimeTask(JavaSource javaSource, Task<CompilationController> task, ClasspathInfo classpathInfo) {
            super(classpathInfo);
            assert (javaSource != null);
            assert (task != null);
            this.js = javaSource;
            this.task = task;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Parser.Result result = resultIterator.getParserResult();
            CompilationController compilationController = CompilationController.get(result);
            assert (compilationController != null);
            compilationController.setJavaSource(this.js);
            this.task.run(compilationController);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiTask
    extends ClasspathInfoTask {
        private final JavaSource js;
        private final Task<CompilationController> task;

        public MultiTask(JavaSource javaSource, Task<CompilationController> task, ClasspathInfo classpathInfo) {
            super(classpathInfo);
            assert (javaSource != null);
            assert (task != null);
            this.js = javaSource;
            this.task = task;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Snapshot snapshot = resultIterator.getSnapshot();
            if ("text/x-java".equals(snapshot.getMimeType())) {
                Parser.Result result = resultIterator.getParserResult();
                CompilationController compilationController = CompilationController.get(result);
                assert (compilationController != null);
                compilationController.setJavaSource(this.js);
                this.task.run(compilationController);
                JavacTaskImpl javacTaskImpl = compilationController.impl.getJavacTask();
                Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
            } else {
                Parser.Result result = this.findEmbeddedJava(resultIterator);
                if (result == null) {
                    return;
                }
                CompilationController compilationController = CompilationController.get(result);
                assert (compilationController != null);
                compilationController.setJavaSource(this.js);
                this.task.run(compilationController);
                JavacTaskImpl javacTaskImpl = compilationController.impl.getJavacTask();
                Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
            }
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.task.getClass().getName() + "]";
        }

        private Parser.Result findEmbeddedJava(ResultIterator resultIterator) throws ParseException {
            LinkedList<Embedding> linkedList = new LinkedList<Embedding>();
            for (Embedding embedding : resultIterator.getEmbeddings()) {
                if ("text/x-java".equals(embedding.getMimeType())) {
                    return resultIterator.getResultIterator(embedding).getParserResult();
                }
                linkedList.add(embedding);
            }
            for (Embedding embedding : linkedList) {
                Parser.Result result = this.findEmbeddedJava(resultIterator.getResultIterator(embedding));
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String string, FileObject fileObject) {
            super(string);
            this.fo = fileObject;
        }

        private InsufficientMemoryException(FileObject fileObject) {
            this(NbBundle.getMessage(JavaSource.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)), fileObject);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        MODIFIED,
        PARSED,
        ELEMENTS_RESOLVED,
        RESOLVED,
        UP_TO_DATE;

    }
}

