/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationInfo {
    private static final boolean VERIFY_CONFINEMENT = Boolean.getBoolean(CompilationInfo.class.getName() + ".vetifyConfinement");
    final CompilationInfoImpl impl;
    private boolean invalid;
    private ElementUtilities elementUtilities;
    private TreeUtilities treeUtilities;
    private TypeUtilities typeUtilities;
    private JavaSource javaSource;

    CompilationInfo(CompilationInfoImpl compilationInfoImpl) {
        assert (compilationInfoImpl != null);
        this.impl = compilationInfoImpl;
    }

    @NullUnknown
    public static CompilationInfo get(@NonNull Parser.Result result) {
        Parameters.notNull((CharSequence)"result", (Object)result);
        CompilationInfo compilationInfo = null;
        if (result instanceof JavacParserResult) {
            JavacParserResult javacParserResult = (JavacParserResult)result;
            compilationInfo = javacParserResult.get(CompilationInfo.class);
        }
        return compilationInfo;
    }

    @NonNull
    public JavaSource.Phase getPhase() {
        this.checkConfinement();
        return this.impl.getPhase();
    }

    @CheckForNull
    @CheckReturnValue
    public TreePath getChangedTree() {
        this.checkConfinement();
        if (JavaSource.Phase.PARSED.compareTo(this.impl.getPhase()) > 0) {
            return null;
        }
        Pair<DocPositionRegion, MethodTree> pair = this.impl.getChangedTree();
        if (pair == null) {
            return null;
        }
        CompilationUnitTree compilationUnitTree = this.impl.getCompilationUnit();
        if (compilationUnitTree == null) {
            return null;
        }
        return TreePath.getPath(compilationUnitTree, (Tree)pair.second);
    }

    public CompilationUnitTree getCompilationUnit() {
        this.checkConfinement();
        return this.impl.getCompilationUnit();
    }

    @NonNull
    public String getText() {
        this.checkConfinement();
        return this.impl.getText();
    }

    @NonNull
    public Snapshot getSnapshot() {
        this.checkConfinement();
        return this.impl.getSnapshot();
    }

    @NonNull
    public TokenHierarchy<?> getTokenHierarchy() {
        this.checkConfinement();
        return this.impl.getTokenHierarchy();
    }

    @NonNull
    public List<Diagnostic> getDiagnostics() {
        this.checkConfinement();
        return this.impl.getDiagnostics();
    }

    @NullUnknown
    public List<? extends TypeElement> getTopLevelElements() throws IllegalStateException {
        this.checkConfinement();
        if (this.impl.getFileObject() == null) {
            throw new IllegalStateException();
        }
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        if (this.impl.isClassFile()) {
            Elements elements = this.getElements();
            assert (elements != null);
            assert (this.impl.getRoot() != null);
            String string = FileObjects.convertFolder2Package(FileObjects.stripExtension(FileUtil.getRelativePath((FileObject)this.impl.getRoot(), (FileObject)this.impl.getFileObject())));
            Symbol.ClassSymbol classSymbol = ((JavacElements)elements).getTypeElementByBinaryName(string);
            if (classSymbol != null) {
                arrayList.add(classSymbol);
            }
        } else {
            CompilationUnitTree compilationUnitTree = this.getCompilationUnit();
            if (compilationUnitTree == null) {
                return null;
            }
            Trees trees = this.getTrees();
            assert (trees != null);
            List<? extends Tree> list = compilationUnitTree.getTypeDecls();
            TreePath treePath = new TreePath(compilationUnitTree);
            for (Tree tree : list) {
                TreePath treePath2 = new TreePath(treePath, tree);
                Element element = trees.getElement(treePath2);
                if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) continue;
                arrayList.add((TypeElement)element);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @NonNull
    public Trees getTrees() {
        this.checkConfinement();
        return Trees.instance(this.impl.getJavacTask());
    }

    @NonNull
    public Types getTypes() {
        this.checkConfinement();
        return this.impl.getJavacTask().getTypes();
    }

    @NonNull
    public Elements getElements() {
        this.checkConfinement();
        return this.impl.getJavacTask().getElements();
    }

    @NullUnknown
    public JavaSource getJavaSource() {
        this.checkConfinement();
        return this.javaSource;
    }

    void setJavaSource(JavaSource javaSource) {
        this.javaSource = javaSource;
    }

    @NonNull
    public ClasspathInfo getClasspathInfo() {
        this.checkConfinement();
        return this.impl.getClasspathInfo();
    }

    @NullUnknown
    public FileObject getFileObject() {
        this.checkConfinement();
        return this.impl.getFileObject();
    }

    @Deprecated
    public PositionConverter getPositionConverter() {
        this.checkConfinement();
        if (this.impl.getFileObject() == null) {
            throw new IllegalStateException();
        }
        return new PositionConverter(this.impl.getSnapshot());
    }

    @CheckForNull
    public Document getDocument() throws IOException {
        this.checkConfinement();
        return this.impl.getDocument();
    }

    @NonNull
    public synchronized TreeUtilities getTreeUtilities() {
        this.checkConfinement();
        if (this.treeUtilities == null) {
            this.treeUtilities = new TreeUtilities(this);
        }
        return this.treeUtilities;
    }

    @NonNull
    public synchronized ElementUtilities getElementUtilities() {
        this.checkConfinement();
        if (this.elementUtilities == null) {
            this.elementUtilities = new ElementUtilities(this);
        }
        return this.elementUtilities;
    }

    @NonNull
    public synchronized TypeUtilities getTypeUtilities() {
        this.checkConfinement();
        if (this.typeUtilities == null) {
            this.typeUtilities = new TypeUtilities(this);
        }
        return this.typeUtilities;
    }

    final void invalidate() {
        this.invalid = true;
        this.doInvalidate();
    }

    protected void doInvalidate() {
        JavacParser javacParser = this.impl.getParser();
        if (javacParser != null) {
            javacParser.resultFinished(true);
        }
    }

    final void checkConfinement() throws IllegalStateException {
        if (VERIFY_CONFINEMENT && this.invalid) {
            throw new IllegalStateException(String.format("Access to the shared %s outside a guarded run method.", this.getClass().getSimpleName()));
        }
    }
}

