/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message.saaj;

import com.sun.istack.FragmentContentHandler;
import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.XMLStreamException2;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.ws.message.saaj.SAAJHeader;
import com.sun.xml.ws.streaming.DOMStreamReader;
import com.sun.xml.ws.util.DOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAAJMessage
extends Message {
    private boolean parsedMessage;
    private boolean accessedMessage;
    private final SOAPMessage sm;
    private HeaderList headers;
    private List<Element> bodyParts;
    private Element payload;
    private String payloadLocalName;
    private String payloadNamespace;
    private SOAPVersion soapVersion;
    private static final AttributesImpl EMPTY_ATTS = new AttributesImpl();
    private static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    public SAAJMessage(SOAPMessage sm) {
        this.sm = sm;
    }

    private SAAJMessage(HeaderList headers, AttachmentSet as, SOAPMessage sm) {
        this.sm = sm;
        this.parse();
        if (headers == null) {
            headers = new HeaderList();
        }
        this.headers = headers;
        this.attachmentSet = as;
    }

    private void parse() {
        if (!this.parsedMessage) {
            try {
                SOAPHeader header;
                this.access();
                if (this.headers == null) {
                    this.headers = new HeaderList();
                }
                if ((header = this.sm.getSOAPHeader()) != null) {
                    Iterator iter = header.examineAllHeaderElements();
                    while (iter.hasNext()) {
                        this.headers.add(new SAAJHeader((SOAPHeaderElement)iter.next()));
                    }
                }
                this.attachmentSet = new SAAJAttachmentSet(this.sm);
                this.parsedMessage = true;
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    private void access() {
        if (!this.accessedMessage) {
            try {
                SOAPBody body = this.sm.getSOAPBody();
                this.soapVersion = SOAPVersion.fromNsUri(body.getNamespaceURI());
                this.bodyParts = DOMUtil.getChildElements((Node)body);
                Element element = this.payload = this.bodyParts.size() > 0 ? this.bodyParts.get(0) : null;
                if (this.payload != null) {
                    this.payloadLocalName = this.payload.getLocalName();
                    this.payloadNamespace = this.payload.getNamespaceURI();
                }
                this.accessedMessage = true;
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    @Override
    public boolean hasHeaders() {
        this.parse();
        return this.headers.size() > 0;
    }

    @Override
    @NotNull
    public HeaderList getHeaders() {
        this.parse();
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        this.parse();
        return this.attachmentSet;
    }

    @Override
    protected boolean hasAttachments() {
        this.parse();
        return this.attachmentSet != null;
    }

    @Override
    @Nullable
    public String getPayloadLocalPart() {
        this.access();
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        this.access();
        return this.payloadNamespace;
    }

    @Override
    public boolean hasPayload() {
        this.access();
        return this.payloadNamespace != null;
    }

    @Override
    public Source readEnvelopeAsSource() {
        try {
            if (!this.parsedMessage) {
                SOAPEnvelope se = this.sm.getSOAPPart().getEnvelope();
                return new DOMSource((Node)se);
            }
            SOAPMessage msg = this.soapVersion.saajMessageFactory.createMessage();
            SOAPBody newBody = msg.getSOAPPart().getEnvelope().getBody();
            for (Element part : this.bodyParts) {
                Node n = newBody.getOwnerDocument().importNode(part, true);
                newBody.appendChild(n);
            }
            for (Header header : this.headers) {
                header.writeTo(msg);
            }
            SOAPEnvelope se = msg.getSOAPPart().getEnvelope();
            return new DOMSource((Node)se);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        if (!this.parsedMessage) {
            return this.sm;
        }
        SOAPMessage msg = this.soapVersion.saajMessageFactory.createMessage();
        SOAPBody newBody = msg.getSOAPPart().getEnvelope().getBody();
        for (Element part : this.bodyParts) {
            Node n = newBody.getOwnerDocument().importNode(part, true);
            newBody.appendChild(n);
        }
        for (Header header : this.headers) {
            header.writeTo(msg);
        }
        for (Attachment att : this.getAttachments()) {
            AttachmentPart part = msg.createAttachmentPart();
            part.setDataHandler(att.asDataHandler());
            part.setContentId('<' + att.getContentId() + '>');
            msg.addAttachmentPart(part);
        }
        msg.saveChanges();
        return msg;
    }

    @Override
    public Source readPayloadAsSource() {
        this.access();
        return this.payload != null ? new DOMSource(this.payload) : null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        this.access();
        if (this.payload != null) {
            if (this.hasAttachments()) {
                unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(this.getAttachments()));
            }
            return (T)unmarshaller.unmarshal((Node)this.payload);
        }
        return null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        this.access();
        if (this.payload != null) {
            return (T)bridge.unmarshal((Node)this.payload, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        }
        return null;
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        this.access();
        if (this.payload != null) {
            DOMStreamReader dss = new DOMStreamReader();
            dss.setCurrentNode(this.payload);
            dss.nextTag();
            assert (dss.getEventType() == 1);
            return dss;
        }
        return null;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        this.access();
        try {
            for (Element part : this.bodyParts) {
                DOMUtil.serializeNode(part, sw);
            }
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        try {
            writer.writeStartDocument();
            if (!this.parsedMessage) {
                DOMUtil.serializeNode((Element)this.sm.getSOAPPart().getEnvelope(), writer);
            } else {
                SOAPEnvelope env = this.sm.getSOAPPart().getEnvelope();
                DOMUtil.writeTagWithAttributes((Element)env, writer);
                if (this.hasHeaders()) {
                    writer.writeStartElement(env.getPrefix(), "Header", env.getNamespaceURI());
                    int len = this.headers.size();
                    for (int i = 0; i < len; ++i) {
                        this.headers.get(i).writeTo(writer);
                    }
                    writer.writeEndElement();
                }
                DOMUtil.serializeNode((Element)this.sm.getSOAPBody(), writer);
                writer.writeEndElement();
            }
            writer.writeEndDocument();
            writer.flush();
        }
        catch (SOAPException ex) {
            throw new XMLStreamException2((Throwable)ex);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String soapNsUri = this.soapVersion.nsUri;
        if (!this.parsedMessage) {
            DOMScanner ds = new DOMScanner();
            ds.setContentHandler(contentHandler);
            ds.scan((Document)this.sm.getSOAPPart());
        } else {
            contentHandler.setDocumentLocator(NULL_LOCATOR);
            contentHandler.startDocument();
            contentHandler.startPrefixMapping("S", soapNsUri);
            contentHandler.startElement(soapNsUri, "Envelope", "S:Envelope", EMPTY_ATTS);
            if (this.hasHeaders()) {
                contentHandler.startElement(soapNsUri, "Header", "S:Header", EMPTY_ATTS);
                HeaderList headers = this.getHeaders();
                int len = headers.size();
                for (int i = 0; i < len; ++i) {
                    headers.get(i).writeTo(contentHandler, errorHandler);
                }
                contentHandler.endElement(soapNsUri, "Header", "S:Header");
            }
            contentHandler.startElement(soapNsUri, "Body", "S:Body", EMPTY_ATTS);
            this.writePayloadTo(contentHandler, errorHandler, true);
            contentHandler.endElement(soapNsUri, "Body", "S:Body");
            contentHandler.endElement(soapNsUri, "Envelope", "S:Envelope");
        }
    }

    private void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
        if (fragment) {
            contentHandler = new FragmentContentHandler(contentHandler);
        }
        DOMScanner ds = new DOMScanner();
        ds.setContentHandler(contentHandler);
        ds.scan(this.payload);
    }

    @Override
    public Message copy() {
        try {
            if (!this.parsedMessage) {
                return new SAAJMessage(this.readAsSOAPMessage());
            }
            SOAPMessage msg = this.soapVersion.saajMessageFactory.createMessage();
            SOAPBody newBody = msg.getSOAPPart().getEnvelope().getBody();
            for (Element part : this.bodyParts) {
                Node n = newBody.getOwnerDocument().importNode(part, true);
                newBody.appendChild(n);
            }
            return new SAAJMessage(this.getHeaders(), this.getAttachments(), msg);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAAJAttachmentSet
    implements AttachmentSet {
        private Map<String, Attachment> attMap;
        private Iterator attIter;

        public SAAJAttachmentSet(SOAPMessage sm) {
            this.attIter = sm.getAttachments();
        }

        @Override
        public Attachment get(String contentId) {
            if (this.attMap == null) {
                if (!this.attIter.hasNext()) {
                    return null;
                }
                this.attMap = this.createAttachmentMap();
            }
            if (contentId.charAt(0) != '<') {
                return this.attMap.get('<' + contentId + '>');
            }
            return this.attMap.get(contentId);
        }

        @Override
        public boolean isEmpty() {
            if (this.attMap != null) {
                return this.attMap.isEmpty();
            }
            return !this.attIter.hasNext();
        }

        @Override
        public Iterator<Attachment> iterator() {
            if (this.attMap == null) {
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.values().iterator();
        }

        private Map<String, Attachment> createAttachmentMap() {
            HashMap<String, Attachment> map = new HashMap<String, Attachment>();
            while (this.attIter.hasNext()) {
                AttachmentPart ap = (AttachmentPart)this.attIter.next();
                map.put(ap.getContentId(), new SAAJAttachment(ap));
            }
            return map;
        }

        @Override
        public void add(Attachment att) {
            this.attMap.put('<' + att.getContentId() + '>', att);
        }
    }

    private class SAAJAttachment
    implements Attachment {
        final AttachmentPart ap;

        public SAAJAttachment(AttachmentPart part) {
            this.ap = part;
        }

        public String getContentId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public void writeTo(OutputStream os) throws IOException {
            os.write(this.asByteArray());
        }

        public void writeTo(SOAPMessage saaj) {
            saaj.addAttachmentPart(this.ap);
        }

        AttachmentPart asAttachmentPart() {
            return this.ap;
        }
    }
}

