/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.MultipleDTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.impl.MultipleDTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataCollector;
import org.netbeans.modules.dlight.dtrace.collector.support.ProcessLineCallback;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleDtraceDataCollector
extends IndicatorDataProvider<MultipleDTDCConfiguration>
implements DataCollector<MultipleDTDCConfiguration>,
DtraceDataCollector.IndicatorDataProvideHandler {
    private DtraceDataCollector collector;
    private Map<String, DtraceDataCollector> slaveCollectors;
    private DtraceDataCollector lastSlaveCollector;

    public MultipleDtraceDataCollector() {
    }

    public MultipleDtraceDataCollector(MultipleDTDCConfiguration multipleDTDCConfiguration) {
        this.collector = new DtraceDataCollector(new DTDCConfiguration(null, Collections.<DataTableMetadata>emptyList()));
        this.collector.setProcessLineCallback(new ProcessLineCallbackImpl());
        this.slaveCollectors = new HashMap<String, DtraceDataCollector>();
        this.lastSlaveCollector = null;
        this.addConfiguration(multipleDTDCConfiguration);
    }

    public String getName() {
        return this.collector.getName();
    }

    public void addConfiguration(MultipleDTDCConfiguration multipleDTDCConfiguration) {
        DtraceDataCollector dtraceDataCollector = new DtraceDataCollector(MultipleDTDCConfigurationAccessor.getDefault().getDTDCConfiguration(multipleDTDCConfiguration));
        dtraceDataCollector.setSlave(true);
        dtraceDataCollector.setIndicatorDataProviderHanlder(this);
        this.slaveCollectors.put(MultipleDTDCConfigurationAccessor.getDefault().getOutputPrefix(multipleDTDCConfiguration), dtraceDataCollector);
    }

    public List<DataStorageType> getSupportedDataStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql"));
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> arrayList = new ArrayList<DataTableMetadata>(this.slaveCollectors.size());
        for (DtraceDataCollector dtraceDataCollector : this.slaveCollectors.values()) {
            arrayList.addAll(dtraceDataCollector.getDataTablesMetadata());
        }
        return arrayList;
    }

    public void init(DataStorage dataStorage, DLightTarget dLightTarget) {
        for (DtraceDataCollector dtraceDataCollector : this.slaveCollectors.values()) {
            dtraceDataCollector.init(dataStorage, dLightTarget);
        }
        this.collector.setLocalScriptPath(this.mergeScripts().getAbsolutePath());
        this.collector.init(dataStorage, dLightTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File mergeScripts() {
        try {
            File file = File.createTempFile("dlight", ".d");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write("#!/usr/sbin/dtrace -ZCs\n");
                for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
                    DtraceDataCollector dtraceDataCollector = entry.getValue();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(dtraceDataCollector.getLocalScriptPath()));
                    try {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            if (!string.startsWith("#!")) {
                                bufferedWriter.write(string.replaceAll("(printf\\(\")", "$1" + entry.getKey()));
                                bufferedWriter.write(10);
                            }
                            string = bufferedReader.readLine();
                        }
                        bufferedWriter.write(10);
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
            }
            finally {
                bufferedWriter.close();
            }
            return file;
        }
        catch (IOException iOException) {
            DLightLogger.getLogger(MultipleDtraceDataCollector.class).log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public boolean isAttachable() {
        return this.collector.isAttachable();
    }

    public String getCmd() {
        return this.collector.getCmd();
    }

    public String[] getArgs() {
        return this.collector.getArgs();
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        return this.collector.validate(dLightTarget, (Validateable)this, true);
    }

    public void invalidate() {
        this.collector.invalidate();
    }

    public ValidationStatus getValidationStatus() {
        return this.collector.getValidationStatus();
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.collector.addValidationListener(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.collector.removeValidationListener(validationListener);
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        this.collector.targetStateChanged(dLightTargetChangeEvent);
        for (DtraceDataCollector dtraceDataCollector : this.slaveCollectors.values()) {
            dtraceDataCollector.targetStateChanged(dLightTargetChangeEvent);
        }
    }

    @Override
    public void notify(List<DataRow> list) {
        this.notifyIndicators(list);
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }

    private class ProcessLineCallbackImpl
    implements ProcessLineCallback {
        private ProcessLineCallbackImpl() {
        }

        public void processLine(String string) {
            DtraceDataCollector dtraceDataCollector = MultipleDtraceDataCollector.this.lastSlaveCollector;
            for (Map.Entry entry : MultipleDtraceDataCollector.this.slaveCollectors.entrySet()) {
                String string2 = (String)entry.getKey();
                if (!string.startsWith(string2)) continue;
                string = string.substring(string2.length());
                dtraceDataCollector = (DtraceDataCollector)((Object)entry.getValue());
                break;
            }
            if (dtraceDataCollector != null) {
                dtraceDataCollector.getProcessLineCallback().processLine(string);
            }
            MultipleDtraceDataCollector.this.lastSlaveCollector = dtraceDataCollector;
        }
    }
}

