/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceParser;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DtraceDataAndStackParser
extends DtraceParser {
    private static final boolean TRACE = Boolean.getBoolean("dlight.dns.parser.trace");
    private static PrintStream traceStream;
    private State state;
    List<String> currData;
    long currTimeStamp;
    long currSampleDuration;
    private List<CharSequence> currStack = new ArrayList<CharSequence>(32);
    private List<String> colNames;
    private int colCount;
    private final boolean isProfiler;

    public DtraceDataAndStackParser(DataTableMetadata dataTableMetadata) {
        super(dataTableMetadata);
        this.state = State.WAITING_DATA;
        this.colNames = new ArrayList<String>(dataTableMetadata.getColumnsCount());
        for (DataTableMetadata.Column column : dataTableMetadata.getColumns()) {
            this.colNames.add(column.getColumnName());
        }
        this.colCount = dataTableMetadata.getColumnsCount();
        this.isProfiler = dataTableMetadata.getName().equals("CallStack");
    }

    protected List<String> processDataLine(String string) {
        return super.parse(string, this.colCount - 1);
    }

    @Override
    public DataRow process(String string) {
        if (TRACE) {
            traceStream.printf("%s\t%s\n", new Object[]{string, this.state});
            traceStream.flush();
        }
        switch (this.state) {
            case WAITING_DATA: {
                if (string.length() == 0) {
                    return null;
                }
                DLightLogger.assertTrue((boolean)this.currStack.isEmpty());
                DLightLogger.assertFalse((boolean)Character.isWhitespace(string.charAt(0)), (String)"Data row shouldn't start with ' '");
                if (this.isProfiler) {
                    try {
                        this.currSampleDuration = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        DLightLogger.instance.log(Level.WARNING, "error parsing line " + string, numberFormatException);
                    }
                } else {
                    this.currData = this.processDataLine(string);
                    DLightLogger.assertTrue((this.currData != null ? 1 : 0) != 0, (String)("could not parse line " + string));
                }
                this.state = State.WAITING_STACK;
                return null;
            }
            case WAITING_STACK: {
                if (string.length() == 0) {
                    this.state = State.WAITING_DATA;
                    return null;
                }
                String[] stringArray = string.split("[ \t]+");
                DLightLogger.assertTrue((stringArray.length == 3 ? 1 : 0) != 0, (String)"stack marker should consist of CPU-id, thread-id and timestamp");
                if (this.isProfiler) {
                    this.currData = this.processDataLine(string);
                }
                this.state = State.IN_STACK;
                return null;
            }
            case IN_STACK: {
                if (string.length() > 0) {
                    DLightLogger.assertTrue((boolean)Character.isWhitespace(string.charAt(0)), (String)"Stack row should start with ' '");
                    string = string.trim();
                    if (this.isProfiler || !string.startsWith("libc.so.")) {
                        this.currStack.add(string);
                    }
                    return null;
                }
                StackDataStorage stackDataStorage = (StackDataStorage)DataStorageManager.getInstance().getDataStorage(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
                DLightLogger.assertTrue((stackDataStorage != null ? 1 : 0) != 0);
                Collections.reverse(this.currStack);
                int n = stackDataStorage.putStack(this.currStack, this.currSampleDuration);
                this.currStack.clear();
                this.state = State.WAITING_DATA;
                this.currData.add(Integer.toString(n));
                return new DataRow(this.colNames, this.currData);
            }
        }
        return null;
    }

    static {
        if (TRACE) {
            String string = null;
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                string = hostInfo.getTempDir();
            }
            catch (IOException iOException) {
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (string == null) {
                string = System.getProperty("java.io.tmpdir");
            }
            try {
                traceStream = new PrintStream(string + "/dsp.log");
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                traceStream = System.err;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WAITING_DATA,
        WAITING_STACK,
        IN_STACK;

    }
}

