/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTDCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    public static final String DTRACE_KERNEL = "dtrace_kernel";
    public static final String DTRACE_USER = "dtrace_user";
    public static final String DTRACE_PROC = "dtrace_proc";
    static final String DTDC_CONFIGURATION_ID = "DtraceDataCollectorConfigurationId";
    private String scriptPath;
    private String args;
    private List<DataTableMetadata> datatableMetadata;
    private DtraceParser parser;
    private List<String> requiredPrivileges;
    private boolean stackSupportEnabled = false;
    private int indicatorFiringFactor;

    public DTDCConfiguration(String string, List<DataTableMetadata> list) {
        this.scriptPath = string;
        this.datatableMetadata = list;
        this.args = null;
        this.parser = null;
        this.requiredPrivileges = null;
        this.indicatorFiringFactor = 1;
    }

    public void setScriptArgs(String string) {
        this.args = string;
    }

    public void setDtraceParser(DtraceParser dtraceParser) {
        this.parser = dtraceParser;
    }

    DTDCConfiguration setParser(DtraceParser dtraceParser) {
        this.parser = dtraceParser;
        return this;
    }

    public void setIndicatorFiringFactor(int n) {
        this.indicatorFiringFactor = n;
    }

    public void setRequiredDTracePrivileges(List<String> list) {
        this.requiredPrivileges = list;
    }

    public void setStackSupportEnabled(boolean bl) {
        this.stackSupportEnabled = bl;
    }

    int getIndicatorFiringFactor() {
        return this.indicatorFiringFactor;
    }

    String getArgs() {
        return this.args;
    }

    List<DataTableMetadata> getDatatableMetadata() {
        return this.datatableMetadata;
    }

    DtraceParser getParser() {
        return this.parser;
    }

    List<String> getRequiredPrivileges() {
        return this.requiredPrivileges;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    boolean isStackSupportEnabled() {
        return this.stackSupportEnabled;
    }

    public String getID() {
        return DTDC_CONFIGURATION_ID;
    }

    static {
        DTDCConfigurationAccessor.setDefault(new DTDCConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DTDCConfigurationAccessorImpl
    extends DTDCConfigurationAccessor {
        private DTDCConfigurationAccessorImpl() {
        }

        @Override
        public String getArgs(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getArgs();
        }

        @Override
        public List<DataTableMetadata> getDatatableMetadata(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getDatatableMetadata();
        }

        @Override
        public DtraceParser getParser(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getParser();
        }

        @Override
        public List<String> getRequiredPrivileges(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getRequiredPrivileges();
        }

        @Override
        public String getScriptPath(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getScriptPath();
        }

        @Override
        public String getID() {
            return DTDCConfiguration.DTDC_CONFIGURATION_ID;
        }

        @Override
        public boolean isStackSupportEnabled(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.isStackSupportEnabled();
        }

        @Override
        public int getIndicatorFiringFactor(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getIndicatorFiringFactor();
        }
    }
}

