/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.wizards.CloneDestinationDirectoryWizardPanel;
import org.netbeans.modules.mercurial.ui.wizards.ClonePathsWizardPanel;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class CloneWizardAction
extends CallableSystemAction
implements ChangeListener {
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private static CloneWizardAction instance;
    private WizardDescriptor wizardDescriptor;
    private CloneRepositoryWizardPanel cloneRepositoryWizardPanel;
    private CloneDestinationDirectoryWizardPanel cloneDestinationDirectoryWizardPanel;
    private ClonePathsWizardPanel clonePathsWizardPanel;
    private PanelsIterator wizardIterator;
    private String errorMessage;

    public static synchronized CloneWizardAction getInstance() {
        if (instance == null) {
            instance = new CloneWizardAction();
        }
        return instance;
    }

    public void performAction() {
        boolean bl;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CloneWizardAction.class, (String)"CTL_Clone"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = this.wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            HgURL hgURL = (HgURL)this.wizardDescriptor.getProperty("repository");
            File file = (File)this.wizardDescriptor.getProperty("directory");
            String string = (String)this.wizardDescriptor.getProperty("cloneName");
            HgURL hgURL2 = (HgURL)this.wizardDescriptor.getProperty("defaultPullPath");
            HgURL hgURL3 = (HgURL)this.wizardDescriptor.getProperty("defaultPushPath");
            File file2 = new File(file, string);
            CloneAction.performClone(hgURL, file2, true, null, hgURL2, hgURL3);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizardIterator == null) {
            return;
        }
        WizardDescriptor.Panel panel = this.wizardIterator.current();
        if (panel == null) {
            return;
        }
        if (panel == this.cloneRepositoryWizardPanel) {
            this.errorMessage = this.cloneRepositoryWizardPanel.getErrorMessage();
        } else if (panel != this.clonePathsWizardPanel && panel == this.cloneDestinationDirectoryWizardPanel) {
            this.errorMessage = this.cloneDestinationDirectoryWizardPanel.getErrorMessage();
        }
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage);
        }
    }

    public String getName() {
        return "Start Sample Wizard";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CloneWizardAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    static /* synthetic */ WizardDescriptor.Panel[] access$302(CloneWizardAction cloneWizardAction, WizardDescriptor.Panel[] panelArray) {
        cloneWizardAction.panels = panelArray;
        return panelArray;
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            CloneWizardAction.this.cloneRepositoryWizardPanel = new CloneRepositoryWizardPanel();
            CloneWizardAction.this.clonePathsWizardPanel = new ClonePathsWizardPanel();
            CloneWizardAction.this.cloneDestinationDirectoryWizardPanel = new CloneDestinationDirectoryWizardPanel();
            CloneWizardAction.access$302(CloneWizardAction.this, new WizardDescriptor.Panel[]{CloneWizardAction.this.cloneRepositoryWizardPanel, CloneWizardAction.this.clonePathsWizardPanel, CloneWizardAction.this.cloneDestinationDirectoryWizardPanel});
            for (int i = 0; i < CloneWizardAction.this.panels.length; ++i) {
                CloneWizardAction.this.panels[i].addChangeListener((ChangeListener)CloneWizardAction.this);
            }
            String[] stringArray = new String[CloneWizardAction.this.panels.length];
            for (int i = 0; i < CloneWizardAction.this.panels.length; ++i) {
                Component component = CloneWizardAction.this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return CloneWizardAction.this.panels;
        }
    }
}

