/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.update.Update;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpdateAction
extends ContextAction {
    private final VCSContext context;
    private static String HG_TIP = "tip";

    public UpdateAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        UpdateAction.update(this.context);
    }

    public static void update(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        File[] fileArray = vCSContext != null ? vCSContext.getFiles().toArray(new File[0]) : null;
        String string = null;
        Update update = new Update(file, fileArray);
        if (!update.showDialog()) {
            return;
        }
        string = update.getSelectionRevision();
        if (string == null) {
            string = HG_TIP;
        }
        final boolean bl = update.isForcedUpdateRequested();
        final String string2 = string;
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                boolean bl2 = true;
                OutputLogger outputLogger = this.getLogger();
                try {
                    Object object;
                    Object object2;
                    outputLogger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE_SEP"));
                    outputLogger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_INFO_SEP", (Object)string2, (Object)file.getAbsolutePath()));
                    if (bl) {
                        object2 = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM_QUERY"));
                        object2.setTitle(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM"));
                        object2.setMessageType(2);
                        object2.setOptionType(0);
                        object = DialogDisplayer.getDefault().notify((NotifyDescriptor)object2);
                        if (object == NotifyDescriptor.NO_OPTION) {
                            outputLogger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CANCELED", (Object)file.getAbsolutePath()));
                            outputLogger.output("");
                            return;
                        }
                        outputLogger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_FORCED", (Object)file.getAbsolutePath()));
                    }
                    if ((object2 = HgCommand.doUpdateAll(file, bl, string2)) != null && !object2.isEmpty()) {
                        bl2 = HgCommand.isNoUpdates((String)object2.get(0));
                        outputLogger.output((List<String>)object2);
                        outputLogger.output("");
                    }
                    object = FileUtil.toFileObject((File)file);
                    try {
                        object.getFileSystem().refresh(true);
                    }
                    catch (Exception exception) {}
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                }
                if (!bl2) {
                    HgUtils.forceStatusRefreshProject(vCSContext);
                }
                outputLogger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_DONE"));
                outputLogger.output("");
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

