/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.rollback.Backout;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BackoutAction
extends ContextAction {
    private final VCSContext context;
    private static final String HG_BACKOUT_REVISION_REPLACE = "\\{revision}";
    public static final String HG_BACKOUT_REVISION = " {revision}";
    private static String HG_TIP = "tip";

    public BackoutAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        BackoutAction.backout(this.context);
    }

    public static void backout(VCSContext vCSContext) {
        BackoutAction.backout(vCSContext, null);
    }

    public static void backout(RepositoryRevision repositoryRevision) {
        BackoutAction.backout(null, repositoryRevision);
    }

    public static void backout(final VCSContext vCSContext, final RepositoryRevision repositoryRevision) {
        File file;
        File[] fileArray;
        File[] fileArray2 = fileArray = vCSContext != null ? vCSContext.getFiles().toArray(new File[0]) : null;
        if (repositoryRevision != null) {
            file = repositoryRevision.getRepositoryRoot();
            if (file == null || file.getPath().equals("")) {
                return;
            }
        } else {
            file = HgUtils.getRootFile(vCSContext);
        }
        if (file == null) {
            return;
        }
        String string = null;
        String string2 = null;
        Backout backout = new Backout(file, repositoryRevision, fileArray);
        if (!backout.showDialog()) {
            return;
        }
        string = backout.getSelectionRevision();
        if (string == null) {
            string = HG_TIP;
        }
        string2 = backout.getCommitMessage();
        final String string3 = string;
        final String string4 = string2 = string2.replaceAll(HG_BACKOUT_REVISION_REPLACE, string3);
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                OutputLogger outputLogger;
                block18: {
                    block20: {
                        block19: {
                            outputLogger = this.getLogger();
                            try {
                                try {
                                    FileObject fileObject;
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE"));
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE_SEP"));
                                    outputLogger.output(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_INFO_SEP", (Object)string3, (Object)file.getAbsolutePath()));
                                    List<String> list = HgCommand.doBackout(file, string3, false, string4, outputLogger);
                                    if (list == null || list.isEmpty()) break block18;
                                    boolean bl = HgCommand.isBackoutMergeNeededMsg(list.get(list.size() - 1));
                                    if (bl) {
                                        list.remove(list.size() - 1);
                                        list.remove(list.size() - 1);
                                    }
                                    outputLogger.output(list);
                                    if (HgCommand.isUncommittedChangesBackout(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_UNCOMMITTED_CHANGES_BACKOUT"));
                                        Object var8_6 = null;
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                        outputLogger.output("");
                                        Mercurial.getInstance().versionedFilesChanged();
                                        return;
                                    }
                                    if (HgCommand.isMergeChangesetBackout(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_MERGE_CSET_BACKOUT", (Object)string3));
                                        break block19;
                                    }
                                    if (HgCommand.isNoRevStrip(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_NO_REV_BACKOUT", (Object)string3));
                                        break block20;
                                    }
                                    boolean bl2 = false;
                                    if (bl) {
                                        bl2 = HgUtils.confirmDialog(BackoutAction.class, "MSG_BACKOUT_MERGE_CONFIRM_TITLE", "MSG_BACKOUT_MERGE_CONFIRM_QUERY");
                                    }
                                    if (bl2) {
                                        outputLogger.output("");
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_MERGE_DO"));
                                        MergeAction.doMergeAction(file, null, outputLogger);
                                    } else {
                                        fileObject = HgCommand.getHeadRevisions(file);
                                        if (fileObject != null && fileObject.size() > 1) {
                                            MergeAction.printMergeWarning(fileObject, outputLogger);
                                        }
                                    }
                                    if (vCSContext != null) {
                                        HgUtils.forceStatusRefreshProject(vCSContext);
                                    } else if (repositoryRevision != null) {
                                        HgUtils.forceStatusRefresh(file);
                                    }
                                    fileObject = FileUtil.toFileObject((File)file);
                                    try {
                                        fileObject.getFileSystem().refresh(true);
                                    }
                                    catch (Exception exception) {
                                    }
                                    break block18;
                                }
                                catch (HgException hgException) {
                                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                                    Object var8_10 = null;
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                    outputLogger.output("");
                                    Mercurial.getInstance().versionedFilesChanged();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                outputLogger.output("");
                                Mercurial.getInstance().versionedFilesChanged();
                                throw throwable;
                            }
                        }
                        Object var8_7 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                        outputLogger.output("");
                        Mercurial.getInstance().versionedFilesChanged();
                        return;
                    }
                    Object var8_8 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                    outputLogger.output("");
                    Mercurial.getInstance().versionedFilesChanged();
                    return;
                }
                Object var8_9 = null;
                outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                outputLogger.output("");
                Mercurial.getInstance().versionedFilesChanged();
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

