/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FetchAction
extends ContextAction {
    private final VCSContext context;

    public FetchAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                FetchAction.performFetch(file, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_PROGRESS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void performFetch(File file, OutputLogger outputLogger) {
        block10: {
            block9: {
                try {
                    try {
                        HgURL hgURL;
                        outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE_SEP"));
                        outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_LAUNCH_INFO", (Object)file.getAbsolutePath()));
                        String string = new HgConfigFiles(file).getDefaultPull(true);
                        if (string == null) {
                            Object var6_4 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                            outputLogger.output("");
                            break block9;
                        }
                        try {
                            hgURL = new HgURL(string);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Mercurial.LOG.log(Level.INFO, null, uRISyntaxException);
                            Object var6_5 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                            outputLogger.output("");
                            Mercurial.getInstance().getRequestProcessor().post(new Runnable(file){
                                final /* synthetic */ File val$root;
                                {
                                    this.val$root = file;
                                }

                                public void run() {
                                    FileUtil.refreshFor((File[])new File[]{this.val$root});
                                }
                            });
                            return;
                        }
                        List<String> list = HgCommand.doFetch(file, hgURL, outputLogger);
                        if (list != null && !list.isEmpty()) {
                            outputLogger.output(HgUtils.replaceHttpPassword(list));
                            MergeAction.handleMergeOutput(file, list, false, outputLogger);
                        }
                        break block10;
                    }
                    catch (HgException hgException) {
                        NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                        Object var6_7 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                        outputLogger.output("");
                        Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                    outputLogger.output("");
                    Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        Object var6_6 = null;
        outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
        outputLogger.output("");
        Mercurial.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

