/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.util.HgCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgLogMessage {
    public static char HgModStatus = (char)77;
    public static char HgAddStatus = (char)65;
    public static char HgDelStatus = (char)82;
    public static char HgCopyStatus = (char)67;
    private List<HgLogMessageChangedPath> paths;
    private String rev;
    private String author;
    private String desc;
    private Date date;
    private String id;
    private String timeZoneOffset;
    private String parentOneRev;
    private String parentTwoRev;
    private boolean bMerged;
    private String rootURL;
    private OutputLogger logger;

    public HgLogMessage(String string) {
    }

    private void updatePaths(List<String> list, String string, List<String> list2, char c) {
        if (list2.isEmpty()) {
            this.paths.add(new HgLogMessageChangedPath(string, c));
            if (list != null) {
                list.add(string);
            }
        } else {
            this.paths.add(new HgLogMessageChangedPath(string, c));
            if (list != null) {
                list.add(string);
            }
        }
    }

    public HgLogMessage(String string, List<String> list, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        String[] stringArray;
        Object object;
        String[] stringArray2;
        this.rootURL = string;
        this.rev = string2;
        this.author = string3;
        this.desc = string4;
        this.id = string6;
        this.date = new Date(Long.parseLong(string5.split(" ")[0]) * 1000L);
        String[] stringArray3 = stringArray2 = string7 != null ? string7.split(" ") : null;
        if (stringArray2 != null && stringArray2.length == 2) {
            object = stringArray2[0].split(":");
            this.parentOneRev = object != null && ((String[])object).length >= 1 ? object[0] : null;
            stringArray = stringArray2[1].split(":");
            this.parentTwoRev = stringArray != null && stringArray.length >= 1 ? stringArray[0] : null;
        }
        this.bMerged = this.parentOneRev != null && this.parentTwoRev != null && !this.parentOneRev.equals("-1") && !this.parentTwoRev.equals("-1");
        this.paths = new ArrayList<HgLogMessageChangedPath>();
        object = new ArrayList();
        stringArray = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string11 != null && !string11.equals("")) {
            for (String object2 : string11.split(" ")) {
                this.updatePaths(arrayList, object2, list, HgCopyStatus);
            }
        }
        if (string9 != null && !string9.equals("")) {
            for (String string12 : string9.split(" ")) {
                if (arrayList.contains(string12)) continue;
                this.updatePaths((List<String>)object, string12, list, HgAddStatus);
            }
        }
        if (string10 != null && !string10.equals("")) {
            for (String string13 : string10.split(" ")) {
                this.updatePaths((List<String>)stringArray, string13, list, HgDelStatus);
            }
        }
        if (string8 != null && !string8.equals("")) {
            for (String string14 : string8.split(" ")) {
                if (object.contains(string14) || stringArray.contains(string14) || arrayList.contains(string14)) continue;
                this.updatePaths(null, string14, list, HgModStatus);
            }
        }
        if (string9 == null && string11 == null && string10 == null && string8 == null) {
            for (String string12 : list) {
                this.paths.add(new HgLogMessageChangedPath(string12, ' '));
            }
        }
    }

    HgLogMessageChangedPath[] getChangedPaths() {
        return this.paths.toArray(new HgLogMessageChangedPath[this.paths.size()]);
    }

    public String getRevision() {
        return this.rev;
    }

    public long getRevisionAsLong() {
        long l;
        try {
            l = Long.parseLong(this.rev);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return l;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCSetShortID() {
        return this.id;
    }

    public String getAncestor() {
        if (this.bMerged) {
            try {
                return HgCommand.getCommonAncestor(this.rootURL, this.parentOneRev, this.parentTwoRev, this.getLogger());
            }
            catch (HgException hgException) {
                return null;
            }
        }
        int n = -1;
        try {
            n = Integer.parseInt(this.rev);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n = n > -1 ? n - 1 : -1;
        return Integer.toString(n);
    }

    private OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Mercurial.getInstance().getLogger(this.rootURL);
        }
        return this.logger;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String string) {
        this.timeZoneOffset = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rev: ");
        stringBuffer.append(this.rev);
        stringBuffer.append("\nauthor: ");
        stringBuffer.append(this.author);
        stringBuffer.append("\ndesc: ");
        stringBuffer.append(this.desc);
        stringBuffer.append("\ndate: ");
        stringBuffer.append(this.date);
        stringBuffer.append("\nid: ");
        stringBuffer.append(this.id);
        stringBuffer.append("\npaths: ");
        stringBuffer.append(this.paths);
        return stringBuffer.toString();
    }
}

