/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputLogger {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;
    private boolean empty;
    private boolean writable;
    private static final RequestProcessor rp = new RequestProcessor("MercurialOutput", 1);
    public static final int MAX_LINES_TO_PRINT = 500;
    private static final String MSG_TOO_MANY_LINES = "The number of output lines is greater than 500; see message log for complete output";
    private static final HashSet<String> openedWindows = new HashSet(5);

    public static OutputLogger getLogger(String string) {
        if (string != null) {
            return new OutputLogger(string);
        }
        return new NullLogger();
    }

    private OutputLogger(String string) {
        this.repositoryRootString = string;
    }

    private OutputLogger() {
    }

    private InputOutput getLog() {
        this.writable = true;
        if (this.log == null) {
            Mercurial.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            if (!openedWindows.contains(this.repositoryRootString)) {
                this.writable = HgModuleConfig.getDefault().getAutoOpenOutput();
                openedWindows.add(this.repositoryRootString);
                if (!this.writable) {
                    this.log.closeInputOutput();
                }
            }
        }
        if (this.log.isClosed()) {
            if (HgModuleConfig.getDefault().getAutoOpenOutput()) {
                Mercurial.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
                this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
                try {
                    this.log.getOut().reset();
                }
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.SEVERE, null, iOException);
                }
            } else {
                this.writable = false;
            }
        }
        return this.log;
    }

    public void closeLog() {
        rp.post(new Runnable(){

            public void run() {
                if (OutputLogger.this.log != null && OutputLogger.this.writable) {
                    OutputLogger.this.log.getOut().close();
                    OutputLogger.this.log.getErr().close();
                }
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.getLog();
                if (OutputLogger.this.writable) {
                    OutputLogger.this.getLog().getOut().flush();
                    OutputLogger.this.getLog().getErr().flush();
                }
            }
        });
    }

    public void output(final List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputWriter outputWriter = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    for (String string : list) {
                        outputWriter.println(string);
                    }
                    outputWriter.flush();
                }
            }
        });
    }

    public void output(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputWriter outputWriter = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    outputWriter.println(string);
                    outputWriter.flush();
                }
            }
        });
    }

    public void outputInRed(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputWriter outputWriter = OutputLogger.this.getLog().getErr();
                if (OutputLogger.this.writable) {
                    outputWriter.println(string);
                    outputWriter.flush();
                }
            }
        });
    }

    public void outputLink(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                try {
                    OutputWriter outputWriter = OutputLogger.this.getLog().getOut();
                    if (OutputLogger.this.writable) {
                        OutputListener outputListener = new OutputListener(){

                            public void outputLineAction(OutputEvent outputEvent) {
                                try {
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }

                            public void outputLineSelected(OutputEvent outputEvent) {
                            }

                            public void outputLineCleared(OutputEvent outputEvent) {
                            }
                        };
                        outputWriter.println(string, outputListener, true);
                        outputWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void clearOutput() {
        rp.post(new Runnable(){

            public void run() {
                OutputWriter outputWriter = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    try {
                        outputWriter.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    outputWriter.flush();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        @Override
        public void closeLog() {
        }

        @Override
        public void flushLog() {
        }

        @Override
        public void output(List<String> list) {
        }

        @Override
        public void output(String string) {
        }

        @Override
        public void outputInRed(String string) {
        }

        @Override
        public void outputLink(String string) {
        }

        @Override
        public void clearOutput() {
        }
    }
}

