/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.ExceptionHandler;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;

public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private ConcurrentLinkedQueue<File> filesToRefresh = new ConcurrentLinkedQueue();
    private RequestProcessor.Task refreshTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRefresh", 1, true);

    public MercurialInterceptor() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask());
    }

    public boolean beforeDelete(File file) {
        Mercurial.LOG.fine("beforeDelete " + file);
        if (file == null) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        return !HgUtils.isIgnored(file, false);
    }

    public void doDelete(File file) throws IOException {
        Mercurial.LOG.fine("doDelete " + file);
        if (file == null) {
            return;
        }
        Mercurial mercurial = Mercurial.getInstance();
        File file2 = mercurial.getRepositoryRoot(file);
        try {
            file.delete();
            HgCommand.doRemove(file2, file, null);
        }
        catch (HgException hgException) {
            Mercurial.LOG.log(Level.FINE, "doDelete(): File: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
        }
    }

    public void afterDelete(final File file) {
        Mercurial.LOG.fine("afterDelete " + file);
        if (file == null) {
            return;
        }
        if (HgUtils.isIgnored(file, false)) {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINE, "skipping afterDelete(): File: {0} is ignored", new Object[]{file.getAbsolutePath()});
            }
            return;
        }
        Mercurial mercurial = Mercurial.getInstance();
        final File file2 = mercurial.getRepositoryRoot(file);
        rp.post(new Runnable(){

            public void run() {
                if (file.isDirectory()) {
                    try {
                        Map<File, FileInformation> map = HgCommand.getInterestingStatus(file2, file);
                        FileInformation fileInformation = map.get(file);
                        MercurialInterceptor.this.cache.refreshFileStatus(file, fileInformation, map);
                    }
                    catch (HgException hgException) {
                        Mercurial.LOG.log(Level.FINE, "fileDeletedImpl(): File: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
                    }
                } else {
                    MercurialInterceptor.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public boolean beforeMove(File file, File file2) {
        Mercurial.LOG.fine("beforeMove " + file + "->" + file2);
        if (file == null || file2 == null || file2.exists()) {
            return true;
        }
        Mercurial mercurial = Mercurial.getInstance();
        if (mercurial.isManaged(file)) {
            return mercurial.isManaged(file2);
        }
        return super.beforeMove(file, file2);
    }

    public void doMove(final File file, final File file2) throws IOException {
        Mercurial.LOG.fine("doMove " + file + "->" + file2);
        if (file == null || file2 == null || file2.exists()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mercurial.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        MercurialInterceptor.this.hgMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Mercurial.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.hgMoveImplementation(file, file2);
        }
    }

    private void hgMoveImplementation(final File file, final File file2) throws IOException {
        Mercurial mercurial = Mercurial.getInstance();
        final File file3 = mercurial.getRepositoryRoot(file);
        final File file4 = mercurial.getRepositoryRoot(file2);
        if (file3 == null) {
            return;
        }
        RequestProcessor requestProcessor = mercurial.getRequestProcessor(file3);
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{file, file2});
        file.renameTo(file2);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OutputLogger outputLogger = OutputLogger.getLogger(file3.getAbsolutePath());
                try {
                    if (file3.equals(file4)) {
                        HgCommand.doRenameAfter(file3, file, file2, outputLogger);
                    }
                }
                catch (HgException hgException) {
                    Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                }
                finally {
                    outputLogger.closeLog();
                }
            }
        };
        requestProcessor.post(runnable);
    }

    public void afterMove(final File file, final File file2) {
        Mercurial.LOG.fine("afterMove " + file + "->" + file2);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileMovedImpl(file, file2);
            }
        });
    }

    private void fileMovedImpl(File file, File file2) {
        if (file == null || file2 == null || !file2.exists()) {
            return;
        }
        if (file2.isDirectory()) {
            return;
        }
        File file3 = file.getParentFile();
        if (file3 != null && !HgUtils.isIgnored(file3, false)) {
            this.reScheduleRefresh(100, file3);
        }
    }

    public boolean beforeCreate(final File file, boolean bl) {
        FileInformation fileInformation;
        Mercurial.LOG.fine("beforeCreate " + file + " " + bl);
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!bl && !file.exists() && (fileInformation = this.cache.getCachedStatus(file)) != null && fileInformation.getStatus() == 256) {
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
            Mercurial mercurial = Mercurial.getInstance();
            final File file2 = mercurial.getRepositoryRoot(file);
            if (file2 == null) {
                return false;
            }
            final OutputLogger outputLogger = Mercurial.getInstance().getLogger(file2.getAbsolutePath());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.add(file);
                        HgCommand.doRevert(file2, arrayList, null, false, outputLogger);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Mercurial.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), throwableArray[0].toString()});
            }
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
            outputLogger.closeLog();
            file.delete();
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
        Mercurial.LOG.fine("doCreate " + file + " " + bl);
        super.doCreate(file, bl);
    }

    public void afterCreate(final File file) {
        Mercurial.LOG.fine("afterCreate " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileCreatedImpl(file);
            }
        });
    }

    private void fileCreatedImpl(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "fileCreatedImpl {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(100, file.getParentFile());
        }
    }

    public void afterChange(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileChangedImpl(file);
            }
        });
    }

    public Object getAttribute(final File file, String string) {
        if ("ProvidedExtensions.RemoteLocation".equals(string)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(string)) {
            return new Runnable(){

                public void run() {
                    try {
                        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
                        if (file2 == null) {
                            return;
                        }
                        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
                        fileStatusCache.refreshCached(file);
                        StatusAction.refreshFile(file, file2, null, fileStatusCache);
                    }
                    catch (HgException hgException) {
                        ExceptionHandler exceptionHandler = new ExceptionHandler(hgException);
                        exceptionHandler.notifyException();
                    }
                }
            };
        }
        return super.getAttribute(file, string);
    }

    private String getRemoteRepository(File file) {
        if (file == null) {
            return null;
        }
        String string = HgRepositoryContextCache.getInstance().getPullDefault(file);
        if (string == null || string.trim().equals("")) {
            Mercurial.LOG.log(Level.FINE, "No defalt pull available for managed file : [" + file + "]");
            string = HgRepositoryContextCache.getInstance().getPushDefault(file);
            Mercurial.LOG.log(Level.WARNING, "No defalt pull or push available for managed file : [" + file + "]");
        }
        if (string != null) {
            string = string.trim();
            if ((string = HgUtils.removeHttpCredentials(string)).equals("")) {
                string = null;
            }
        }
        return string;
    }

    private void fileChangedImpl(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "fileChangedImpl(): File: {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(100, file.getParentFile());
        }
    }

    public Boolean isRefreshScheduled(File file) {
        return this.filesToRefresh.contains(file);
    }

    private void reScheduleRefresh(int n, File file) {
        if (!this.filesToRefresh.contains(file) && !this.filesToRefresh.offer(file)) {
            Mercurial.LOG.log(Level.FINE, "reScheduleRefresh failed to add to filesToRefresh queue {0}", file);
        }
        this.refreshTask.schedule(n);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            Thread.interrupted();
            File file = (File)MercurialInterceptor.this.filesToRefresh.poll();
            if (file != null) {
                Mercurial.LOG.log(Level.FINE, "RefreshTask called refreshAll {0}", file);
                MercurialInterceptor.this.cache.refreshAll(file);
                file = (File)MercurialInterceptor.this.filesToRefresh.peek();
                if (file != null) {
                    MercurialInterceptor.this.refreshTask.schedule(0);
                }
            }
        }
    }
}

