/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.ExceptionHandler;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class HgProgressSupport
implements Runnable,
Cancellable {
    private Cancellable delegate;
    private volatile boolean canceled;
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName = "";
    private OutputLogger logger;
    private HgURL repositoryRoot;
    private RequestProcessor.Task task;

    public HgProgressSupport() {
    }

    public HgProgressSupport(String string, JButton jButton) {
        this.displayName = string;
        if (jButton != null) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HgProgressSupport.this.cancel();
                }
            });
        }
    }

    public RequestProcessor.Task start(RequestProcessor requestProcessor, String string) {
        return this.start(requestProcessor, new File(""), string);
    }

    public RequestProcessor.Task start(RequestProcessor requestProcessor, File file, String string) {
        HgURL hgURL = file != null ? new HgURL(file) : null;
        return this.start(requestProcessor, hgURL, string);
    }

    public RequestProcessor.Task start(RequestProcessor requestProcessor, HgURL hgURL, String string) {
        this.setDisplayName(string);
        this.repositoryRoot = hgURL;
        this.startProgress();
        this.setProgressQueued();
        this.task = requestProcessor.post((Runnable)this);
        this.task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                HgProgressSupport.this.delegate = null;
            }
        });
        return this.task;
    }

    public RequestProcessor.Task start(RequestProcessor requestProcessor) {
        this.startProgress();
        this.task = requestProcessor.post((Runnable)this);
        return this.task;
    }

    public JComponent getProgressComponent() {
        return ProgressHandleFactory.createProgressComponent((ProgressHandle)this.getProgressHandle());
    }

    public void setRepositoryRoot(HgURL hgURL) {
        this.repositoryRoot = hgURL;
        this.logger = null;
    }

    protected HgURL getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void run() {
        this.setProgress();
        this.performIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIntern() {
        try {
            HgProgressSupport.log("Start - " + this.displayName);
            if (!this.canceled) {
                this.perform();
            }
        }
        finally {
            HgProgressSupport.log("End - " + this.displayName);
            this.finnishProgress();
            this.getLogger().closeLog();
        }
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        if (this.delegate != null && !this.delegate.cancel()) {
            return false;
        }
        if (this.canceled) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        Mercurial.getInstance().clearRequestProcessor(this.repositoryRoot);
        this.getProgressHandle().finish();
        this.canceled = true;
        return true;
    }

    public void setCancellableDelegate(Cancellable cancellable) {
        this.delegate = cancellable;
    }

    public void setDisplayName(String string) {
        if (this.originalDisplayName.equals("")) {
            this.originalDisplayName = string;
        }
        this.logChangedDisplayName(this.displayName, string);
        this.displayName = string;
        this.setProgress();
    }

    private void setProgressQueued() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage(HgProgressSupport.class, (String)"LBL_Queued", (Object)this.displayName));
        }
    }

    private void setProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.displayName);
        }
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this);
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
    }

    protected void finnishProgress() {
        this.getProgressHandle().finish();
    }

    public OutputLogger getLogger() {
        if (this.logger == null) {
            String string = this.repositoryRoot != null ? this.repositoryRoot.toHgCommandUrlStringWithoutUserInfo() : null;
            this.logger = Mercurial.getInstance().getLogger(string);
        }
        return this.logger;
    }

    public void annotate(HgException hgException) {
        ExceptionHandler exceptionHandler = new ExceptionHandler(hgException);
        if (this.isCanceled()) {
            exceptionHandler.notifyException(false);
        } else {
            exceptionHandler.notifyException();
        }
    }

    private static void log(String string) {
        HgUtils.logT9Y(string);
        Mercurial.LOG.log(Level.FINE, string);
    }

    private void logChangedDisplayName(String string, String string2) {
        if (string != null && !string.equals(string2) && !string.equals("")) {
            HgProgressSupport.log("End - " + string);
            HgProgressSupport.log("Start - " + string2);
        }
    }
}

