/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.openide.util.Exceptions;

public class WrappedTextView
extends View {
    private JTextComponent comp;
    private int charsPerLine = 80;
    private int fontDescent = 4;
    private static final Segment SEGMENT = new Segment();
    private int width = 0;
    private boolean changed = true;
    private int charWidth = 12;
    private int charHeight = 7;
    static final int[] ln = new int[3];
    private boolean aa = false;
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final Color arrowColor = new Color(80, 162, 80);
    private static Map hintsMap = null;
    float viewWidth = -1.0f;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    public WrappedTextView(Element element, JTextComponent jTextComponent) {
        super(element);
        this.comp = jTextComponent;
    }

    public float getPreferredSpan(int n) {
        OutputDocument outputDocument = this.odoc();
        float f = 0.0f;
        if (outputDocument != null) {
            this.updateWidth();
            switch (n) {
                case 0: {
                    f = this.charsPerLine;
                    break;
                }
                case 1: {
                    f = outputDocument.getLines().getLogicalLineCountIfWrappedAt(this.charsPerLine) * this.charHeight + this.fontDescent;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(n));
                }
            }
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        if (this.viewWidth != f) {
            this.viewWidth = f;
            this.updateMetrics();
        }
    }

    void updateMetrics() {
        Font font = this.comp.getFont();
        FontMetrics fontMetrics = this.comp.getFontMetrics(font);
        this.charWidth = fontMetrics.charWidth('m');
        this.charHeight = fontMetrics.getHeight();
        this.fontDescent = fontMetrics.getMaxDescent();
        Graphics2D graphics2D = (Graphics2D)this.comp.getGraphics();
        if (graphics2D != null) {
            this.aa = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        this.updateWidth();
    }

    private OutputDocument odoc() {
        Document document = this.comp.getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    private void updateWidth() {
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.comp.getParent();
            this.width = jViewport.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        if (this.width < 0) {
            this.width = 0;
        }
        this.charsPerLine = this.width / this.charWidth;
    }

    private static int margin() {
        return 9;
    }

    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(WrappedTextView.getHints());
        this.comp.getHighlighter().paint(graphics);
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.y = Math.max(0, rectangle.y - this.charHeight);
            rectangle.height += this.charHeight * 2;
            int n = outputDocument.getElementCount();
            if (n == 0) {
                return;
            }
            WrappedTextView.ln[0] = rectangle.y / this.charHeight;
            Lines lines = outputDocument.getLines();
            lines.toPhysicalLineIndex(ln, this.charsPerLine);
            int n2 = ln[0];
            graphics.setColor(this.comp.getForeground());
            Segment segment = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int n3 = this.comp.getSelectionStart();
            int n4 = this.comp.getSelectionEnd();
            int n5 = rectangle.y - rectangle.y % this.charHeight + this.charHeight;
            int n6 = (rectangle.height + this.charHeight - 1) / this.charHeight * this.charsPerLine;
            try {
                for (int i = n2; i < n; ++i) {
                    int n7 = outputDocument.getLineStart(i);
                    int n8 = outputDocument.getLineEnd(i);
                    int n9 = n8 - n7;
                    graphics.setColor(lines.getColorForLine(i));
                    int n10 = n9 <= this.charsPerLine ? 1 : (this.charsPerLine == 0 ? n9 : (n9 + this.charsPerLine - 1) / this.charsPerLine);
                    int n11 = i == n2 && n10 > 0 && ln[1] > 0 ? ln[1] : 0;
                    n9 = Math.min(n6, n8 - (n7 += n11 * this.charsPerLine));
                    outputDocument.getText(n7, n9, segment);
                    int n12 = 0;
                    while (n11 < n10) {
                        int n13 = Math.min(this.charsPerLine, n9 - n12);
                        if (n13 > 0) {
                            this.drawLogicalLine(segment, n11, n10, graphics, n5, n7, n12, n3, n13, n4);
                            if (lines.isHyperlink(i)) {
                                this.underline(graphics, segment, n12, n13, n11, n5);
                            }
                        }
                        if ((n5 += this.charHeight) > rectangle.y + rectangle.height) {
                            return;
                        }
                        ++n11;
                        n12 += this.charsPerLine;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private void drawLogicalLine(Segment segment, int n, int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        if (n != n2 - 1) {
            this.drawArrow(graphics, n3, n == n2 - 2);
        }
        if (n6 != n8 && (n11 = Math.max(n6, n10 = n4 + n5)) < (n9 = Math.min(n8, n10 + n7))) {
            int n12 = WrappedTextView.margin() + (n11 - n10) * this.charWidth;
            int n13 = (n9 - n11) * this.charWidth;
            Color color = graphics.getColor();
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(n12, n3 + this.fontDescent - this.charHeight, n13, this.charHeight);
            graphics.setColor(color);
        }
        graphics.drawChars(segment.array, n5, n7, WrappedTextView.margin(), n3);
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = WrappedTextView.margin();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = n6 + fontMetrics.charsWidth(segment.array, n, n2);
        if (n3 == 0) {
            for (n5 = 0; n5 < n2 && Character.isWhitespace(segment.array[n + n5]); ++n5) {
                n6 += this.charWidth;
            }
        } else {
            n6 = WrappedTextView.margin();
        }
        n5 = fontMetrics.getDescent() - 1;
        graphics.drawLine(n6, n4 + n5, n7, n4 + n5);
    }

    private void drawArrow(Graphics graphics, int n, boolean bl) {
        int n2;
        Color color = graphics.getColor();
        graphics.setColor(WrappedTextView.arrowColor());
        int n3 = this.width + 15;
        n += 2;
        int n4 = n2 = this.aa ? 8 : 4;
        if (this.aa) {
            graphics.drawArc(n3 - n2, n - this.charHeight / 2, n2 + 1, this.charHeight, 265, 185);
            ++n3;
        } else {
            graphics.drawLine(n3 - n2, n - this.charHeight / 2, n3, n - this.charHeight / 2);
            graphics.drawLine(n3, n - this.charHeight / 2 + 1, n3, n + this.charHeight / 2 - 1);
            graphics.drawLine(n3 - n2, n + this.charHeight / 2, n3, n + this.charHeight / 2);
        }
        if (bl) {
            n2 = this.aa ? 7 : 8;
            int[] nArray = new int[]{n3 - n2, n3 - n2 + 5, n3 - n2 + 5};
            int[] nArray2 = new int[]{n + this.charHeight / 2, n + this.charHeight / 2 - 5, n + this.charHeight / 2 + 5};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        graphics.setColor(WrappedTextView.arrowColor());
        graphics.drawLine(1, n - this.charHeight / 2, 5, n - this.charHeight / 2);
        graphics.drawLine(1, n - this.charHeight / 2, 1, n + this.charHeight / 2);
        graphics.drawLine(1, n + this.charHeight / 2, 5, n + this.charHeight / 2);
        graphics.setColor(color);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(0, 0, this.charWidth, this.charHeight);
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n2 = Math.max(0, outputDocument.getElementIndex(n));
            int n3 = outputDocument.getLineStart(n2);
            int n4 = n - n3;
            int n5 = outputDocument.getLines().getLogicalLineCountAbove(n2, this.charsPerLine);
            if (n4 > this.charsPerLine && this.charsPerLine != 0) {
                n5 += n4 / this.charsPerLine;
                n4 %= this.charsPerLine;
            }
            rectangle.y = n5 * this.charHeight + this.fontDescent;
            rectangle.x = WrappedTextView.margin() + n4 * this.charWidth;
        }
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n = Math.max((int)f - WrappedTextView.margin(), 0);
            int n2 = (int)f2 - this.fontDescent;
            WrappedTextView.ln[0] = n2 / this.charHeight;
            outputDocument.getLines().toPhysicalLineIndex(ln, this.charsPerLine);
            int n3 = ln[0];
            int n4 = ln[2] - 1;
            int n5 = outputDocument.getElementCount();
            if (n5 == 0) {
                return 0;
            }
            if (n3 >= n5) {
                return outputDocument.getLength();
            }
            int n6 = outputDocument.getLineStart(n3);
            int n7 = n / this.charWidth;
            int n8 = outputDocument.getLineEnd(n3);
            if (n7 > n8) {
                n7 = n8;
            }
            int n9 = n4 > 0 ? Math.min(n8, n6 + ln[1] * this.charsPerLine + n7) : Math.min(n6 + n7, n8);
            n9 = Math.min(outputDocument.getLength(), n9);
            return n9;
        }
        return 0;
    }
}

