/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

final class OutputTab
extends AbstractOutputTab
implements IOContainer.CallBacks {
    private final NbIO io;
    private int firstNavigableListenerLine = -1;
    private boolean hasOutputListeners = false;
    boolean ignoreCaretChanges = false;
    private static String lastDir = null;
    FilteredOutput filtOut;
    AbstractOutputPane origPane;
    private static final int ACTION_COPY = 0;
    private static final int ACTION_WRAP = 1;
    private static final int ACTION_SAVEAS = 2;
    private static final int ACTION_CLOSE = 3;
    private static final int ACTION_NEXTERROR = 4;
    private static final int ACTION_PREVERROR = 5;
    private static final int ACTION_SELECTALL = 6;
    private static final int ACTION_FIND = 7;
    private static final int ACTION_FINDNEXT = 8;
    private static final int ACTION_NAVTOLINE = 9;
    private static final int ACTION_POSTMENU = 10;
    private static final int ACTION_FINDPREVIOUS = 11;
    private static final int ACTION_CLEAR = 12;
    private static final int ACTION_NEXTTAB = 13;
    private static final int ACTION_PREVTAB = 14;
    private static final int ACTION_LARGERFONT = 15;
    private static final int ACTION_SMALLERFONT = 16;
    private static final int ACTION_FONTTYPE = 17;
    private static final int ACTION_FILTER = 18;
    Action copyAction = new TabAction(0, "ACTION_COPY");
    Action wrapAction = new TabAction(1, "ACTION_WRAP");
    Action saveAsAction = new TabAction(2, "ACTION_SAVEAS");
    Action closeAction = new TabAction(3, "ACTION_CLOSE");
    Action nextErrorAction = new TabAction(4, "ACTION_NEXT_ERROR");
    Action prevErrorAction = new TabAction(5, "ACTION_PREV_ERROR");
    Action selectAllAction = new TabAction(6, "ACTION_SELECT_ALL");
    Action findAction = new TabAction(7, "ACTION_FIND");
    Action findNextAction = new TabAction(8, "ACTION_FIND_NEXT");
    Action findPreviousAction = new TabAction(11, "ACTION_FIND_PREVIOUS");
    Action filterAction = new TabAction(18, "ACTION_FILTER");
    Action largerFontAction = new TabAction(15, "ACTION_LARGER_FONT");
    Action smallerFontAction = new TabAction(16, "ACTION_SMALLER_FONT");
    Action fontTypeAction = new TabAction(17, "ACTION_FONT_TYPE");
    Action navToLineAction = new TabAction(9, "navToLine", KeyStroke.getKeyStroke(10, 0));
    Action postMenuAction = new TabAction(10, "postMenu", KeyStroke.getKeyStroke(121, 64));
    Action clearAction = new TabAction(12, "ACTION_CLEAR");
    Action nextTabAction = new TabAction(13, "NextViewAction", null);
    Action prevTabAction = new TabAction(14, "PreviousViewAction", null);
    private Object[] popupItems = new Object[]{this.copyAction, new JSeparator(), this.findAction, this.findNextAction, this.findPreviousAction, this.filterAction, new JSeparator(), this.wrapAction, this.largerFontAction, this.smallerFontAction, this.fontTypeAction, new JSeparator(), this.saveAsAction, this.clearAction, this.closeAction};

    OutputTab(NbIO nbIO) {
        this.io = nbIO;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + nbIO);
        }
        OutputDocument outputDocument = new OutputDocument(((NbWriter)nbIO.getOut()).out());
        this.setDocument(outputDocument);
        this.installKBActions();
        this.getActionMap().put("jumpPrev", this.prevErrorAction);
        this.getActionMap().put("jumpNext", this.nextErrorAction);
        this.getActionMap().put(FindAction.class.getName(), this.findAction);
        this.getActionMap().put("copy-to-clipboard", this.copyAction);
    }

    private void installKBActions() {
        this.installKeyboardAction(this.copyAction);
        this.installKeyboardAction(this.selectAllAction);
        this.installKeyboardAction(this.findAction);
        this.installKeyboardAction(this.findNextAction);
        this.installKeyboardAction(this.findPreviousAction);
        this.installKeyboardAction(this.wrapAction);
        this.installKeyboardAction(this.largerFontAction);
        this.installKeyboardAction(this.smallerFontAction);
        this.installKeyboardAction(this.saveAsAction);
        this.installKeyboardAction(this.closeAction);
        this.installKeyboardAction(this.copyAction);
        this.installKeyboardAction(this.navToLineAction);
        this.installKeyboardAction(this.postMenuAction);
        this.installKeyboardAction(this.clearAction);
        this.installKeyboardAction(this.filterAction);
    }

    public void setDocument(Document document) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        assert (SwingUtilities.isEventDispatchThread());
        OutputDocument outputDocument = this.getDocument();
        this.hasOutputListeners = false;
        this.firstNavigableListenerLine = -1;
        super.setDocument(document);
        if (outputDocument != null && outputDocument instanceof OutputDocument) {
            outputDocument.dispose();
        }
    }

    public void reset() {
        if (this.origPane != null) {
            this.setOutputPane(this.origPane);
        }
        this.setDocument(new OutputDocument(((NbWriter)this.io.getOut()).out()));
        this.io.setClosed(false);
    }

    public OutputDocument getDocument() {
        Document document = this.getOutputPane().getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    protected AbstractOutputPane createOutputPane() {
        return new OutputPane(this);
    }

    protected void inputSent(String string) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + string);
        }
        this.getOutputPane().lockScroll();
        NbIO.IOReader iOReader = this.io.in();
        if (iOReader != null) {
            if (Controller.LOG) {
                Controller.log("Sending input to " + iOReader);
            }
            iOReader.pushText(string + "\n");
            this.io.getOut().println(string);
        }
    }

    protected void inputEof() {
        NbIO.IOReader iOReader;
        if (Controller.LOG) {
            Controller.log("Input EOF");
        }
        if ((iOReader = this.io.in()) != null) {
            iOReader.eof();
        }
    }

    public void hasSelectionChanged(boolean bl) {
        if (this.isShowing()) {
            this.copyAction.setEnabled(bl);
            this.selectAllAction.setEnabled(!this.getOutputPane().isAllSelected());
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void requestActive() {
        this.io.getIOContainer().requestActive();
    }

    public void lineClicked(int n) {
        OutWriter outWriter = this.getOut();
        if (outWriter == null) {
            return;
        }
        OutputListener outputListener = outWriter.getLines().getListenerForLine(n);
        if (outputListener != null) {
            Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, outWriter, n);
            outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            this.getOutputPane().sendCaretToLine(n, true);
        }
    }

    boolean linePressed(int n, Point point) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            return outWriter.getLines().getListenerForLine(n) != null;
        }
        return false;
    }

    public int getFirstNavigableListenerLine() {
        if (this.firstNavigableListenerLine != -1) {
            return this.firstNavigableListenerLine;
        }
        int n = -1;
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            if (Controller.LOG) {
                Controller.log("Looking for first appropriate listener line to send the caret to");
            }
            n = outWriter.getLines().firstImportantListenerLine();
        }
        return n;
    }

    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged(OutputPane outputPane) {
        if (this.filtOut != null && outputPane == this.origPane) {
            this.filtOut.readFrom(this.io.out());
        }
        boolean bl = this.hasOutputListeners;
        boolean bl2 = this.hasOutputListeners = this.getOut() != null && this.getOut().getLines().firstListenerLine() >= 0;
        if (this.hasOutputListeners != bl) {
            this.hasOutputListenersChanged(this.hasOutputListeners);
        }
        IOContainer iOContainer = this.io.getIOContainer();
        if (this.io.isFocusTaken()) {
            iOContainer.select((JComponent)this);
            iOContainer.requestVisible();
        }
        Controller.getDefault().updateName(this);
        if (this == iOContainer.getSelected() && iOContainer.isActivated()) {
            this.updateActions();
        }
    }

    private void navigateToFirstErrorLine() {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int n = this.getFirstNavigableListenerLine();
            if (Controller.LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + n);
            }
            if (n > 0) {
                this.getOutputPane().sendCaretToLine(n, false);
                if (this.isSDI()) {
                    this.requestActive();
                }
            }
        }
    }

    private boolean isSDI() {
        Container container = this.getTopLevelAncestor();
        return container != WindowManager.getDefault().getMainWindow();
    }

    void hasOutputListenersChanged(boolean bl) {
        if (bl && this.getOutputPane().isScrollLocked()) {
            this.navigateToFirstErrorLine();
        }
    }

    public void activated() {
        this.updateActions();
    }

    public void closed() {
        this.io.setClosed(true);
        Controller.getDefault().removeTab(this.io);
        NbWriter nbWriter = this.io.writer();
        if (nbWriter != null && nbWriter.isClosed()) {
            this.setDocument(null);
        } else if (nbWriter != null) {
            this.getDocument().disposeQuietly();
        }
    }

    public void deactivated() {
    }

    public void selected() {
    }

    public boolean shouldRelock(int n) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null && !outWriter.isClosed()) {
            int n2 = Math.abs(outWriter.getLines().getCharCount() - n);
            return n2 < 100;
        }
        return false;
    }

    private OutputListener listenerForLine(int n) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            return outWriter.getLines().getListenerForLine(n);
        }
        return null;
    }

    void caretEnteredLine(int n) {
        OutputListener outputListener;
        if (!this.ignoreCaretChanges && (outputListener = this.listenerForLine(n)) != null) {
            Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, n);
            outputListener.outputLineSelected((OutputEvent)controllerOutputEvent);
        }
    }

    private void sendCaretToError(boolean bl) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int n;
            int n2 = this.getOutputPane().getCaretLine();
            if (!this.getOutputPane().isLineSelected(n2)) {
                n2 += bl ? 1 : -1;
            }
            if (n2 >= this.getOutputPane().getLineCount() - 1) {
                n2 = 0;
            }
            if ((n = outWriter.getLines().nearestListenerLine(n2, bl)) == n2) {
                if (!bl && n2 != this.getOutputPane().getLineCount()) {
                    n = outWriter.getLines().nearestListenerLine(n2 + 1, bl);
                } else if (bl && n2 > 0) {
                    n = outWriter.getLines().nearestListenerLine(n2 - 1, bl);
                } else {
                    return;
                }
            }
            if (n != -1) {
                this.getOutputPane().sendCaretToLine(n, true);
                if (!this.io.getIOContainer().isActivated()) {
                    OutputListener outputListener = outWriter.getLines().getListenerForLine(n);
                    Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, n);
                    outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
                }
            }
        }
    }

    private boolean find(boolean bl) {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int[] nArray;
            int n;
            String string = FindDialogPanel.result();
            if (string == null) {
                return false;
            }
            int n2 = n = bl ? this.getOutputPane().getSelectionStart() : this.getOutputPane().getCaretPos();
            if (n > this.getOutputPane().getLength() || n < 0) {
                n = 0;
            }
            boolean bl2 = FindDialogPanel.regExp();
            boolean bl3 = FindDialogPanel.matchCase();
            int[] nArray2 = nArray = bl ? outWriter.getLines().rfind(n, string, bl2, bl3) : outWriter.getLines().find(n, string, bl2, bl3);
            if (nArray != null) {
                this.getOutputPane().unlockScroll();
                this.getOutputPane().setSelection(nArray[0], nArray[1]);
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAs() {
        OutWriter outWriter = this.getOut();
        if (outWriter == null) {
            return;
        }
        File file = OutputTab.showFileChooser(this);
        if (file != null) {
            try {
                OutWriter outWriter2 = outWriter;
                synchronized (outWriter2) {
                    outWriter.getLines().saveAs(file.getPath());
                }
            }
            catch (IOException iOException) {
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(OutputTab.class, (String)"MSG_SaveAsFailed", (Object)file.getPath()), NbBundle.getMessage(OutputTab.class, (String)"LBL_SaveAsFailedTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
        }
    }

    private static File showFileChooser(JComponent jComponent) {
        Object object;
        Object object2;
        File file = null;
        String string = NbBundle.getMessage(Controller.class, (String)"TITLE_SAVE_DLG");
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (bl) {
            object2 = new FileDialog((Frame)jComponent.getTopLevelAncestor(), string, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                ((FileDialog)object2).setDirectory(lastDir);
            }
            ((Dialog)object2).setModal(true);
            ((Dialog)object2).setVisible(true);
            object = ((FileDialog)object2).getDirectory() + ((FileDialog)object2).getFile();
            file = new File((String)object);
            if (file.exists() && file.isDirectory()) {
                file = null;
            }
        } else {
            object2 = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && ((File)(object = new File(lastDir))).exists()) {
                ((JFileChooser)object2).setCurrentDirectory((File)object);
            }
            ((Component)object2).setName(string);
            ((JFileChooser)object2).setDialogTitle(string);
            if (((JFileChooser)object2).showSaveDialog(jComponent.getTopLevelAncestor()) == 0) {
                file = ((JFileChooser)object2).getSelectedFile();
            }
        }
        if (file != null && file.exists() && !bl) {
            object2 = NbBundle.getMessage(Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{file.getName()});
            object = NbBundle.getMessage(Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(jComponent.getTopLevelAncestor(), object2, (String)object, 2) != 0) {
                file = null;
            }
        }
        if (file != null) {
            lastDir = file.getParent();
        }
        return file;
    }

    private void openLineIfError() {
        OutWriter outWriter = this.getOut();
        if (outWriter != null) {
            int n = this.getOutputPane().getCaretLine();
            OutputListener outputListener = outWriter.getLines().getListenerForLine(n);
            if (outputListener != null) {
                this.ignoreCaretChanges = true;
                this.getOutputPane().sendCaretToLine(n, true);
                this.ignoreCaretChanges = false;
                Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.io, n);
                outputListener.outputLineAction((OutputEvent)controllerOutputEvent);
            }
        }
    }

    void postPopupMenu(Point point, Component component) {
        JComponent jComponent;
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        Action[] actionArray = this.getToolbarActions();
        if (actionArray.length > 0) {
            boolean bl = false;
            for (n = 0; n < actionArray.length; ++n) {
                if (actionArray[n].getValue("Name") == null) continue;
                jPopupMenu.add(new ProxyAction(actionArray[n]));
                bl = true;
            }
            if (bl) {
                jPopupMenu.add(new JSeparator());
            }
        }
        ArrayList<TabAction> arrayList = new ArrayList<TabAction>(this.popupItems.length);
        for (n = 0; n < this.popupItems.length; ++n) {
            if (this.popupItems[n] instanceof JSeparator) {
                jPopupMenu.add((JSeparator)this.popupItems[n]);
                continue;
            }
            if (this.popupItems[n] == this.wrapAction) {
                jComponent = new JCheckBoxMenuItem((Action)this.popupItems[n]);
                ((AbstractButton)jComponent).setSelected(this.getOutputPane().isWrapped());
                arrayList.add((TabAction)this.popupItems[n]);
                jPopupMenu.add((JMenuItem)jComponent);
                continue;
            }
            if (this.popupItems[n] == this.filterAction) {
                jComponent = new JCheckBoxMenuItem((Action)this.popupItems[n]);
                ((AbstractButton)jComponent).setSelected(this.origPane != null);
                arrayList.add((TabAction)this.popupItems[n]);
                jPopupMenu.add((JMenuItem)jComponent);
                continue;
            }
            if (this.popupItems[n] == this.closeAction && !this.io.getIOContainer().isCloseable((JComponent)this) || this.popupItems[n] == this.fontTypeAction && this.getOutputPane().isWrapped()) continue;
            jComponent = jPopupMenu.add((Action)this.popupItems[n]);
            arrayList.add((TabAction)this.popupItems[n]);
            if (this.popupItems[n] != this.findAction) continue;
            ((AbstractButton)jComponent).setMnemonic(70);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jComponent = this.getOutputPane().getTextView();
        Object object = jComponent.getInputMap().get(keyStroke);
        jComponent.getInputMap().remove(keyStroke);
        this.getInputMap(1).remove(keyStroke);
        jPopupMenu.addPopupMenuListener(new PMListener(arrayList, object));
        jPopupMenu.show(component, point.x, point.y);
    }

    void updateActions() {
        OutputPane outputPane = (OutputPane)this.getOutputPane();
        int n = outputPane.getLength();
        boolean bl = n > 0;
        OutWriter outWriter = this.getOut();
        this.saveAsAction.setEnabled(bl);
        this.selectAllAction.setEnabled(bl);
        this.copyAction.setEnabled(outputPane.hasSelection());
        boolean bl2 = outWriter == null ? false : outWriter.getLines().firstListenerLine() != -1;
        this.nextErrorAction.setEnabled(bl2);
        this.prevErrorAction.setEnabled(bl2);
    }

    private void showFontChooser() {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
        if (propertyEditor != null) {
            propertyEditor.setValue(this.getOutputPane().getViewFont());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), NbBundle.getMessage(OutputTab.class, (String)"LBL_Font_Chooser_Title"));
            String string = NbBundle.getMessage(OutputTab.class, (String)"BTN_Defaul_Font");
            dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION, string, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                Font font = (Font)propertyEditor.getValue();
                Controller.getDefault().changeFont(font);
            } else if (dialogDescriptor.getValue() == string) {
                Controller.getDefault().changeFont(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilter(String string, boolean bl, boolean bl2) {
        if (string == null) {
            assert (this.origPane != null);
            this.setOutputPane(this.origPane);
            this.origPane = null;
            this.filtOut.dispose();
            this.filtOut = null;
        } else {
            assert (this.origPane == null);
            this.origPane = this.getOutputPane();
            this.filtOut = new FilteredOutput(string, bl, bl2);
            this.setOutputPane(this.filtOut.getPane());
            try {
                this.waitCursor(true);
                this.filtOut.readFrom(this.io.out());
                this.installKBActions();
            }
            finally {
                this.waitCursor(false);
            }
        }
        this.validate();
        this.getOutputPane().repaint();
        this.requestFocus();
    }

    private void waitCursor(boolean bl) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        Cursor cursor = Cursor.getPredefinedCursor(bl ? 3 : 0);
        rootPaneContainer.getGlassPane().setCursor(cursor);
        rootPaneContainer.getGlassPane().setVisible(bl);
    }

    OutWriter getOut() {
        return this.origPane != null ? this.filtOut.getWriter() : this.io.out();
    }

    private void disableHtmlName() {
        String string;
        Controller.getDefault().removeFromUpdater(this);
        try {
            string = XMLUtil.toAttributeValue((String)(this.io.getName() + " "));
        }
        catch (CharConversionException charConversionException) {
            string = this.io.getName() + " ";
        }
        this.io.getIOContainer().setTitle((JComponent)this, string.replace("&apos;", "'"));
    }

    private boolean validRegExp(String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), NbBundle.getMessage(OutputTab.class, (String)"FMT_Invalid_RegExp", (Object)string), NbBundle.getMessage(OutputTab.class, (String)"LBL_Invalid_RegExp"), 0);
            return false;
        }
    }

    private String getFindDlgResult(String string, String string2, String string3, String string4) {
        String string5 = FindDialogPanel.getResult(string, string2, string3, string4);
        while (string5 != null && FindDialogPanel.regExp() && !this.validRegExp(string5)) {
            string5 = FindDialogPanel.getResult(string5, string2, string3, string4);
        }
        return string5;
    }

    private class FilteredOutput {
        String pattern;
        OutWriter out;
        OutputPane pane;
        OutputDocument doc;
        int readCount;
        Pattern compPattern;
        boolean regExp;
        boolean matchCase;

        public FilteredOutput(String string, boolean bl, boolean bl2) {
            this.pattern = bl || bl2 ? string : string.toLowerCase();
            this.regExp = bl;
            this.matchCase = bl2;
            this.out = new OutWriter();
            this.pane = new OutputPane(OutputTab.this);
            this.doc = new OutputDocument(this.out);
            this.pane.setDocument(this.doc);
        }

        boolean passFilter(String string) {
            if (this.regExp) {
                if (this.compPattern == null) {
                    this.compPattern = this.matchCase ? Pattern.compile(this.pattern) : Pattern.compile(this.pattern, 2);
                }
                return this.compPattern.matcher(string).find();
            }
            return this.matchCase ? string.contains(this.pattern) : string.toLowerCase().contains(this.pattern);
        }

        OutputPane getPane() {
            return this.pane;
        }

        OutWriter getWriter() {
            return this.out;
        }

        synchronized void readFrom(OutWriter outWriter) {
            AbstractLines abstractLines = (AbstractLines)outWriter.getLines();
            while (this.readCount < abstractLines.getLineCount()) {
                try {
                    int n;
                    ++this.readCount;
                    String string = abstractLines.getLine(n);
                    if (!this.passFilter(string)) continue;
                    OutputListener outputListener = abstractLines.getListenerForLine(n);
                    Color color = abstractLines.getLineColor(n);
                    boolean bl = abstractLines.isImportantHyperlink(n);
                    boolean bl2 = abstractLines.isErr(n);
                    if (outputListener != null || color != null) {
                        this.out.print(string, outputListener, bl, color, false);
                    } else {
                        this.out.print(string);
                    }
                    if (!bl2) continue;
                    ((AbstractLines)this.out.getLines()).markErr();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        void dispose() {
            this.out.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PMListener
    implements PopupMenuListener {
        private List<TabAction> popupItems;
        private Object handle;

        PMListener(List<TabAction> list, Object object) {
            this.popupItems = list;
            this.handle = object;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            jPopupMenu.removeAll();
            jPopupMenu.setInvoker(null);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            JTextComponent jTextComponent = OutputTab.this.getOutputPane().getTextView();
            jTextComponent.getInputMap().put(keyStroke, this.handle);
            OutputTab.this.getInputMap(1).put(keyStroke, this.handle);
            jPopupMenu.removePopupMenuListener(this);
            for (TabAction tabAction : this.popupItems) {
                tabAction.clearListeners();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupMenuWillBecomeInvisible(popupMenuEvent);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action action) {
            this.orig = action;
        }

        public Object getValue(String string) {
            if ("SmallIcon".equals(string)) {
                return null;
            }
            return this.orig.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.orig.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.orig.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.orig.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.orig.actionPerformed(actionEvent);
        }
    }

    class TabAction
    extends AbstractAction {
        private int id;

        TabAction(int n, String string) {
            if (string != null) {
                String string2 = NbBundle.getMessage(OutputTab.class, (String)string);
                KeyStroke keyStroke = this.getAcceleratorFor(string);
                this.id = n;
                this.putValue("Name", string2);
                this.putValue("AcceleratorKey", keyStroke);
            }
        }

        TabAction(int n, String string, KeyStroke keyStroke) {
            this.id = n;
            this.putValue("Name", string);
            this.putValue("AcceleratorKey", keyStroke);
        }

        void clearListeners() {
            PropertyChangeListener[] propertyChangeListenerArray = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                this.removePropertyChangeListener(propertyChangeListenerArray[i]);
            }
        }

        private KeyStroke getAcceleratorFor(String string) {
            String string2 = string + ".accel";
            if (Utilities.isMac()) {
                string2 = string2 + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage(OutputTab.class, (String)string2));
        }

        public int getID() {
            return this.id;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.id) {
                case 0: {
                    OutputTab.this.getOutputPane().copy();
                    break;
                }
                case 1: {
                    boolean bl = OutputTab.this.getOutputPane().isWrapped();
                    OutputTab.this.getOutputPane().setWrapped(!bl);
                    break;
                }
                case 2: {
                    OutputTab.this.saveAs();
                    break;
                }
                case 3: {
                    OutputTab.this.io.getIOContainer().remove((JComponent)OutputTab.this);
                    break;
                }
                case 4: {
                    OutputTab.this.sendCaretToError(false);
                    break;
                }
                case 5: {
                    OutputTab.this.sendCaretToError(true);
                    break;
                }
                case 6: {
                    OutputTab.this.getOutputPane().selectAll();
                    break;
                }
                case 7: {
                    String string = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Find_Title", "LBL_Find_What", "BTN_Find");
                    if (string == null || !OutputTab.this.find(false)) break;
                    OutputTab.this.findNextAction.setEnabled(true);
                    OutputTab.this.findPreviousAction.setEnabled(true);
                    OutputTab.this.requestFocus();
                    break;
                }
                case 8: {
                    OutputTab.this.find(false);
                    break;
                }
                case 11: {
                    OutputTab.this.find(true);
                    break;
                }
                case 9: {
                    OutputTab.this.openLineIfError();
                    break;
                }
                case 10: {
                    OutputTab.this.postPopupMenu(new Point(0, 0), OutputTab.this);
                    break;
                }
                case 12: {
                    NbWriter nbWriter = OutputTab.this.io.writer();
                    if (nbWriter == null) break;
                    try {
                        nbWriter.reset();
                        OutputTab.this.disableHtmlName();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    break;
                }
                case 16: {
                    Controller.getDefault().changeFontSizeBy(-1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case 15: {
                    Controller.getDefault().changeFontSizeBy(1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case 17: {
                    OutputTab.this.showFontChooser();
                    break;
                }
                case 18: {
                    if (OutputTab.this.origPane != null) {
                        OutputTab.this.setFilter(null, false, false);
                        break;
                    }
                    String string = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Filter_Title", "LBL_Filter_What", "BTN_Filter");
                    if (string == null) break;
                    OutputTab.this.setFilter(string, FindDialogPanel.regExp(), FindDialogPanel.matchCase());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }
}

