/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteCopySupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerSetup {
    private static Logger log = Logger.getLogger("cnd.remote.logger");
    private static final String REMOTE_SCRIPT_DIR = ".netbeans/6.7/cnd2/scripts/";
    private static final String LOCAL_SCRIPT_DIR = "src/scripts/";
    private static final String GET_SCRIPT_INFO = "grep VERSION= .netbeans/6.7/cnd2/scripts/* /dev/null 2> /dev/null";
    private static final String DOS2UNIX_CMD = "dos2unix .netbeans/6.7/cnd2/scripts/";
    private static final String GET_LIB_INFO = "ls -1 2>&1 ";
    public static final String REMOTE_LIB_DIR = ".netbeans/6.7/cnd2/lib/";
    private final Map<String, Double> scriptSetupMap;
    private final Map<String, String> binarySetupMap;
    private final Map<ExecutionEnvironment, List<String>> updateMap;
    private final ExecutionEnvironment executionEnvironment;
    private boolean cancelled;
    private boolean failed;
    private String reason;

    protected RemoteServerSetup(ExecutionEnvironment executionEnvironment) {
        Map map;
        this.executionEnvironment = executionEnvironment;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(SetupProvider.class));
        Collection collection = result.allInstances();
        SetupProvider[] setupProviderArray = collection.toArray(new SetupProvider[collection.size()]);
        this.scriptSetupMap = new HashMap<String, Double>();
        this.scriptSetupMap.put("getCompilerSets.bash", 0.9);
        for (SetupProvider setupProvider : setupProviderArray) {
            map = setupProvider.getScriptFiles();
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                this.scriptSetupMap.put((String)entry.getKey(), (Double)entry.getValue());
            }
        }
        this.binarySetupMap = new HashMap<String, String>();
        for (SetupProvider setupProvider : setupProviderArray) {
            map = setupProvider.getBinaryFiles();
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                this.binarySetupMap.put(REMOTE_LIB_DIR + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.updateMap = new HashMap<ExecutionEnvironment, List<String>>();
    }

    protected boolean needsSetupOrUpdate() {
        List<String> list = new ArrayList<String>();
        this.updateMap.clear();
        list = this.getScriptUpdates(list);
        if (!this.isFailedOrCanceled()) {
            list = this.getBinaryUpdates(list);
        }
        if (!list.isEmpty()) {
            this.updateMap.put(this.executionEnvironment, list);
            return true;
        }
        return false;
    }

    protected void setup() {
        List<String> list = this.updateMap.remove(this.executionEnvironment);
        boolean bl = false;
        for (String string : list) {
            Object object;
            if (string.equals(REMOTE_SCRIPT_DIR)) {
                log.fine("RSS.setup: Creating ~/.netbeans/6.7/cnd2/scripts/");
                int n = RemoteCommandSupport.run(this.executionEnvironment, "mkdir -p .netbeans/6.7/cnd2/scripts/");
                if (n == 0) {
                    bl = true;
                    for (String string2 : this.scriptSetupMap.keySet()) {
                        log.fine("RSS.setup: Copying " + string + " to " + this.executionEnvironment);
                        object = InstalledFileLocator.getDefault().locate(LOCAL_SCRIPT_DIR + string2, null, false);
                        if (object != null && ((File)object).exists() && RemoteCopySupport.copyTo(this.executionEnvironment, ((File)object).getAbsolutePath(), REMOTE_SCRIPT_DIR + ((File)object).getName()) && RemoteCommandSupport.run(this.executionEnvironment, DOS2UNIX_CMD + string2 + ' ' + REMOTE_SCRIPT_DIR + string2) == 0) continue;
                        this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment.toString(), (Object)string2);
                    }
                    continue;
                }
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_DirectorySetupFailure", (Object)this.executionEnvironment.toString(), (Object)n);
                continue;
            }
            if (string.equals(REMOTE_LIB_DIR)) {
                log.fine("RSS.setup: Creating ~/.netbeans/6.7/cnd2/lib/");
                int n = RemoteCommandSupport.run(this.executionEnvironment, "mkdir -p .netbeans/6.7/cnd2/lib/");
                if (n == 0) {
                    bl = true;
                    for (String string2 : this.binarySetupMap.keySet()) {
                        object = this.binarySetupMap.get(string2);
                        log.fine("RSS.setup: Copying" + (String)object + " to " + this.executionEnvironment);
                        File file = InstalledFileLocator.getDefault().locate((String)object, null, false);
                        if (file != null && file.exists() && RemoteCopySupport.copyTo(this.executionEnvironment, file.getAbsolutePath(), REMOTE_LIB_DIR + file.getName())) continue;
                        this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment.toString(), (Object)string2);
                    }
                    continue;
                }
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_DirectorySetupFailure", (Object)this.executionEnvironment.toString(), (Object)n);
                continue;
            }
            log.fine("RSS.setup: Updating \"" + string + "\" on " + this.executionEnvironment);
            if (this.binarySetupMap.containsKey(string)) {
                bl = true;
                String string3 = this.binarySetupMap.get(string);
                File file = InstalledFileLocator.getDefault().locate(string3, null, false);
                if (file != null && file.exists() && RemoteCopySupport.copyTo(this.executionEnvironment, file.getAbsolutePath(), REMOTE_LIB_DIR + file.getName())) continue;
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment, (Object)string);
                continue;
            }
            File file = InstalledFileLocator.getDefault().locate(LOCAL_SCRIPT_DIR + string, null, false);
            if (file != null && file.exists() && RemoteCopySupport.copyTo(this.executionEnvironment, file.getAbsolutePath(), REMOTE_SCRIPT_DIR + file.getName()) && RemoteCommandSupport.run(this.executionEnvironment, DOS2UNIX_CMD + string + ' ' + REMOTE_SCRIPT_DIR + string) == 0) continue;
            this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment.toString(), (Object)string);
        }
        if (bl) {
            RemoteCommandSupport.run(this.executionEnvironment, "chmod 755 .netbeans/6.7/cnd2/scripts/*.bash .netbeans/6.7/cnd2/lib/*.so");
        }
    }

    private List<String> getScriptUpdates(List<String> list) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, GET_SCRIPT_INFO);
        remoteCommandSupport.run();
        if (!remoteCommandSupport.isFailed()) {
            log.fine("RSS.needsSetupOrUpdate: GET_SCRIPT_INFO returned " + remoteCommandSupport.getExitStatus());
            if (remoteCommandSupport.getExitStatus() == 0) {
                String string = remoteCommandSupport.getOutput();
                for (String string2 : string.split("\n")) {
                    try {
                        int n = string2.indexOf(58);
                        if (n > 0 && string2.length() > 0) {
                            String string3 = string2.substring(REMOTE_SCRIPT_DIR.length(), n);
                            Double d = Double.valueOf(string2.substring(n + 9));
                            Double d2 = this.scriptSetupMap.get(string3);
                            if (d2 == null || !(d2 > d)) continue;
                            log.fine("RSS.getScriptUpdates: Need to update " + string3);
                            list.add(string3);
                            continue;
                        }
                        log.warning("RSS.getScriptUpdates: Grep returned [" + string2 + "]");
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warning("RSS.getScriptUpdates: Bad response from remote grep comand (NFE parsing version)");
                    }
                    catch (Exception exception) {
                        log.warning("RSS.getScriptUpdates: Bad response from remote grep comand: " + exception.getClass().getName());
                    }
                }
            } else if (!remoteCommandSupport.isCancelled()) {
                log.fine("RSS.getScriptUpdates: Need to create ~/.netbeans/6.7/cnd2/scripts/");
                list.add(REMOTE_SCRIPT_DIR);
            } else if (remoteCommandSupport.isCancelled()) {
                this.cancelled = true;
            } else {
                log.warning("RSS.getScriptUpdates: Unexpected  exit code [" + remoteCommandSupport.getExitStatus() + "]");
            }
        } else {
            this.failed = true;
            this.reason = remoteCommandSupport.getFailureReason();
        }
        return list;
    }

    private List<String> getBinaryUpdates(List<String> list) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, GET_LIB_INFO + this.getBinarySetupFiles());
        remoteCommandSupport.run();
        if (!remoteCommandSupport.isFailed()) {
            log.fine("RSS.getBinaryUpdates: GET_LIB_INFO returned " + remoteCommandSupport.getExitStatus());
            if (remoteCommandSupport.isCancelled()) {
                this.cancelled = true;
            } else {
                String string = remoteCommandSupport.getOutput();
                int n = 0;
                for (String string2 : string.split("\n")) {
                    int n2;
                    int n3 = string2.indexOf(58);
                    if (n3 <= 0) continue;
                    if (n++ == 0) {
                        list.add(REMOTE_LIB_DIR);
                    }
                    if ((n2 = string2.indexOf(58, n3 + 1)) <= 0) continue;
                    list.add(string2.substring(n3 + 1, n2).trim());
                }
            }
        } else {
            this.failed = true;
            this.reason = remoteCommandSupport.getFailureReason();
        }
        return list;
    }

    public String getReason() {
        return this.reason;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    private boolean isFailedOrCanceled() {
        return this.failed || this.cancelled;
    }

    private String getBinarySetupFiles() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.binarySetupMap.keySet()) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

