/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.CenteredZoomAnimator;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.EdgeWidget;
import org.netbeans.modules.maven.graph.FixVersionConflictPanel;
import org.netbeans.modules.maven.graph.FruchtermanReingoldLayout;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphScene
extends GraphScene<ArtifactGraphNode, ArtifactGraphEdge> {
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private ArtifactGraphNode rootNode;
    private final AllActionsProvider allActionsP = new AllActionsProvider();
    private WidgetAction moveAction = ActionFactory.createMoveAction(null, (MoveProvider)this.allActionsP);
    private WidgetAction popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)this.allActionsP);
    private WidgetAction zoomAction = ActionFactory.createMouseCenteredZoomAction((double)1.1);
    private WidgetAction panAction = ActionFactory.createPanAction();
    private WidgetAction editAction = ActionFactory.createEditAction((EditProvider)this.allActionsP);
    WidgetAction hoverAction = ActionFactory.createHoverAction((TwoStateHoverProvider)new HoverController());
    Action sceneZoomToFitAction = new SceneZoomToFitAction();
    Action highlitedZoomToFitAction = new HighlitedZoomToFitAction();
    private FruchtermanReingoldLayout layout;
    private int maxDepth = 0;
    private final MavenProject project;
    private final Project nbProject;
    private final DependencyGraphTopComponent tc;
    private FitToViewLayout fitViewL;
    private static Set<ArtifactGraphNode> EMPTY_SELECTION = new HashSet<ArtifactGraphNode>();
    private POMModel model;

    DependencyGraphScene(MavenProject mavenProject, Project project, DependencyGraphTopComponent dependencyGraphTopComponent, POMModel pOMModel) {
        this.project = mavenProject;
        this.nbProject = project;
        this.tc = dependencyGraphTopComponent;
        this.model = pOMModel;
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.getActions().addAction(this.hoverAction);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.allActionsP));
        this.getActions().addAction(this.zoomAction);
        this.getActions().addAction(this.panAction);
        this.getActions().addAction(this.editAction);
        this.getActions().addAction(this.popupMenuAction);
    }

    void cleanLayout(JScrollPane jScrollPane) {
        this.layout = new FruchtermanReingoldLayout(this, jScrollPane);
        this.layout.invokeLayout();
    }

    ArtifactGraphNode getRootGraphNode() {
        return this.rootNode;
    }

    int getMaxNodeDepth() {
        return this.maxDepth;
    }

    Project getNbProject() {
        return this.nbProject;
    }

    MavenProject getMavenProject() {
        return this.project;
    }

    boolean isAnimated() {
        return true;
    }

    ArtifactGraphNode getGraphNodeRepresentant(DependencyNode dependencyNode) {
        for (ArtifactGraphNode artifactGraphNode : this.getNodes()) {
            if (!artifactGraphNode.represents(dependencyNode)) continue;
            return artifactGraphNode;
        }
        throw new IllegalStateException();
    }

    protected Widget attachNodeWidget(ArtifactGraphNode artifactGraphNode) {
        if (artifactGraphNode.getPrimaryLevel() > this.maxDepth) {
            this.maxDepth = artifactGraphNode.getPrimaryLevel();
        }
        ArtifactWidget artifactWidget = new ArtifactWidget(this, artifactGraphNode);
        this.mainLayer.addChild((Widget)artifactWidget);
        artifactGraphNode.setWidget(artifactWidget);
        if (this.rootNode == null) {
            this.rootNode = artifactGraphNode;
        }
        artifactWidget.setOpaque(true);
        artifactWidget.getActions().addAction(this.createObjectHoverAction());
        artifactWidget.getActions().addAction(this.createSelectAction());
        artifactWidget.getActions().addAction(this.moveAction);
        artifactWidget.getActions().addAction(this.editAction);
        artifactWidget.getActions().addAction(this.popupMenuAction);
        return artifactWidget;
    }

    protected Widget attachEdgeWidget(ArtifactGraphEdge artifactGraphEdge) {
        EdgeWidget edgeWidget = new EdgeWidget(this, artifactGraphEdge);
        this.connectionLayer.addChild((Widget)edgeWidget);
        return edgeWidget;
    }

    protected void attachEdgeSourceAnchor(ArtifactGraphEdge artifactGraphEdge, ArtifactGraphNode artifactGraphNode, ArtifactGraphNode artifactGraphNode2) {
        ((ConnectionWidget)this.findWidget(artifactGraphEdge)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(artifactGraphNode2)));
    }

    protected void attachEdgeTargetAnchor(ArtifactGraphEdge artifactGraphEdge, ArtifactGraphNode artifactGraphNode, ArtifactGraphNode artifactGraphNode2) {
        ArtifactWidget artifactWidget = (ArtifactWidget)this.findWidget(artifactGraphNode2);
        ((ConnectionWidget)this.findWidget(artifactGraphEdge)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)artifactWidget));
    }

    void highlightRelated(ArtifactGraphNode artifactGraphNode) {
        Object object;
        Object object22;
        ArrayList<ArtifactGraphNode> arrayList = new ArrayList<ArtifactGraphNode>();
        ArrayList<ArtifactGraphEdge> arrayList2 = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphEdge> arrayList3 = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphNode> arrayList4 = new ArrayList<ArtifactGraphNode>();
        ArrayList arrayList5 = new ArrayList();
        arrayList.add(artifactGraphNode);
        List list = artifactGraphNode.getArtifact().getChildren();
        for (Object object22 : list) {
            arrayList4.add(this.getGraphNodeRepresentant((DependencyNode)object22));
        }
        arrayList5.addAll(this.findNodeEdges(artifactGraphNode, true, false));
        this.addPathToRoot(artifactGraphNode, arrayList3, arrayList);
        ArrayList<DependencyNode> arrayList6 = new ArrayList<DependencyNode>(artifactGraphNode.getDuplicatesOrConflicts());
        object22 = arrayList6.iterator();
        while (object22.hasNext()) {
            object = (DependencyNode)object22.next();
            this.addPathToRoot((DependencyNode)object, object.getParent(), arrayList2, arrayList);
        }
        for (Object object3 : this.getEdges()) {
            object22 = (EdgeWidget)this.findWidget(object3);
            if (arrayList3.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(4);
                continue;
            }
            if (arrayList2.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(3);
                continue;
            }
            if (arrayList5.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(1);
                continue;
            }
            ((EdgeWidget)((Object)object22)).setState(0);
        }
        for (ArtifactGraphNode artifactGraphNode2 : this.getNodes()) {
            object = (ArtifactWidget)this.findWidget(artifactGraphNode2);
            if (arrayList.contains(artifactGraphNode2)) {
                ((ArtifactWidget)object).setPaintState(2);
                ((ArtifactWidget)object).setReadable(true);
                continue;
            }
            if (arrayList4.contains(artifactGraphNode2)) {
                ((ArtifactWidget)object).setPaintState(2);
                ((ArtifactWidget)object).setReadable(true);
                continue;
            }
            ((ArtifactWidget)object).setPaintState(0);
            ((ArtifactWidget)object).setReadable(false);
        }
    }

    private void addPathToRoot(ArtifactGraphNode artifactGraphNode, List<ArtifactGraphEdge> list, List<ArtifactGraphNode> list2) {
        DependencyNode dependencyNode = artifactGraphNode.getArtifactParent();
        this.addPathToRoot(artifactGraphNode.getArtifact(), dependencyNode, list, list2);
    }

    private void addPathToRoot(DependencyNode dependencyNode, DependencyNode dependencyNode2, List<ArtifactGraphEdge> list, List<ArtifactGraphNode> list2) {
        while (dependencyNode2 != null) {
            ArtifactGraphNode artifactGraphNode = this.getGraphNodeRepresentant(dependencyNode2);
            list.addAll(this.findEdgesBetween(artifactGraphNode, this.getGraphNodeRepresentant(dependencyNode)));
            list2.add(artifactGraphNode);
            dependencyNode = dependencyNode2;
            dependencyNode2 = artifactGraphNode.getArtifactParent();
        }
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (!objectState.isSelected() && objectState2.isSelected()) {
            this.tc.depthHighlight();
        }
    }

    private FitToViewLayout getFitToViewLayout() {
        if (this.fitViewL == null) {
            this.fitViewL = new FitToViewLayout(this);
        }
        return this.fitViewL;
    }

    boolean isEditable() {
        return this.model != null;
    }

    static boolean isFixCandidate(ArtifactGraphNode artifactGraphNode) {
        Set<DependencyNode> set = artifactGraphNode.getDuplicatesOrConflicts();
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion());
        for (DependencyNode dependencyNode : set) {
            if (dependencyNode.getState() != 2 || defaultArtifactVersion.compareTo((Object)new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion())) >= 0) continue;
            return true;
        }
        return false;
    }

    static ArtifactVersion findNewest(ArtifactGraphNode artifactGraphNode, boolean bl) {
        Set<DependencyNode> set = artifactGraphNode.getDuplicatesOrConflicts();
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion());
        DefaultArtifactVersion defaultArtifactVersion2 = null;
        for (DependencyNode dependencyNode : set) {
            if (!bl && dependencyNode.getState() != 2 || defaultArtifactVersion.compareTo((Object)(defaultArtifactVersion2 = new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion()))) >= 0) continue;
            defaultArtifactVersion = defaultArtifactVersion2;
        }
        return defaultArtifactVersion;
    }

    void invokeFixConflict(ArtifactGraphNode artifactGraphNode) {
        new FixVersionConflictAction(artifactGraphNode).actionPerformed(null);
    }

    private class HoverController
    implements TwoStateHoverProvider {
        private HoverController() {
        }

        public void unsetHovering(Widget widget) {
            ArtifactWidget artifactWidget = this.findArtifactW(widget);
            if (widget != null) {
                artifactWidget.bulbUnhovered();
            }
        }

        public void setHovering(Widget widget) {
            ArtifactWidget artifactWidget = this.findArtifactW(widget);
            if (artifactWidget != null) {
                artifactWidget.bulbHovered();
            }
        }

        private ArtifactWidget findArtifactW(Widget widget) {
            while (widget != null && !(widget instanceof ArtifactWidget)) {
                widget = widget.getParentWidget();
            }
            return (ArtifactWidget)widget;
        }
    }

    private class FixVersionConflictAction
    extends AbstractAction
    implements Runnable {
        private ArtifactGraphNode node;
        private Artifact nodeArtif;

        public FixVersionConflictAction(ArtifactGraphNode artifactGraphNode) {
            this.node = artifactGraphNode;
            this.nodeArtif = artifactGraphNode.getArtifact().getArtifact();
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_FixVersionConflict"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FixVersionConflictPanel fixVersionConflictPanel = new FixVersionConflictPanel(DependencyGraphScene.this, this.node);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fixVersionConflictPanel, NbBundle.getMessage(DependencyGraphScene.class, (String)"TIT_FixConflict"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.OK_OPTION) {
                FixVersionConflictPanel.FixDescription fixDescription = fixVersionConflictPanel.getResult();
                this.fixDependency(fixDescription);
                this.updateGraph(fixDescription);
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        public void run() {
            try {
                Utilities.saveChanges((AbstractDocumentModel)DependencyGraphScene.this.model);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fixDependency(FixVersionConflictPanel.FixDescription fixDescription) {
            try {
                DependencyGraphScene.this.model.startTransaction();
                if (fixDescription.isSet && fixDescription.version2Set != null) {
                    Dependency dependency = ModelUtils.checkModelDependency((POMModel)DependencyGraphScene.this.model, (String)this.nodeArtif.getGroupId(), (String)this.nodeArtif.getArtifactId(), (boolean)true);
                    dependency.setVersion(fixDescription.version2Set.toString());
                }
                if (fixDescription.isExclude) {
                    for (Artifact artifact : fixDescription.exclusionTargets) {
                        Exclusion exclusion;
                        Dependency dependency = DependencyGraphScene.this.model.getProject().findDependencyById(artifact.getGroupId(), artifact.getArtifactId(), null);
                        if (dependency == null) {
                            org.apache.maven.model.Profile profile2;
                            exclusion = new ArrayList();
                            NbMavenProject nbMavenProject = (NbMavenProject)DependencyGraphScene.this.nbProject.getLookup().lookup(NbMavenProject.class);
                            for (org.apache.maven.model.Profile profile2 : nbMavenProject.getMavenProject().getActiveProfiles()) {
                                exclusion.add(profile2.getId());
                            }
                            profile2 = exclusion.iterator();
                            while (profile2.hasNext()) {
                                String string = (String)profile2.next();
                                Profile profile3 = DependencyGraphScene.this.model.getProject().findProfileById(string);
                                if (profile3 == null || (dependency = profile3.findDependencyById(artifact.getGroupId(), artifact.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dependency == null) {
                            dependency = DependencyGraphScene.this.model.getFactory().createDependency();
                            dependency.setArtifactId(artifact.getArtifactId());
                            dependency.setGroupId(artifact.getGroupId());
                            dependency.setType(artifact.getType());
                            dependency.setVersion(artifact.getVersion());
                            DependencyGraphScene.this.model.getProject().addDependency(dependency);
                        }
                        if ((exclusion = dependency.findExclusionById(this.nodeArtif.getGroupId(), this.nodeArtif.getArtifactId())) != null) continue;
                        exclusion = DependencyGraphScene.this.model.getFactory().createExclusion();
                        exclusion.setArtifactId(this.nodeArtif.getArtifactId());
                        exclusion.setGroupId(this.nodeArtif.getGroupId());
                        dependency.addExclusion(exclusion);
                    }
                }
            }
            finally {
                DependencyGraphScene.this.model.endTransaction();
            }
        }

        private void updateGraph(FixVersionConflictPanel.FixDescription fixDescription) {
            Object object4;
            Object object2;
            Object object3;
            Collection<Object> collection;
            boolean bl = false;
            if (fixDescription.isSet) {
                this.node.getArtifact().getArtifact().setVersion(fixDescription.version2Set.toString());
                collection = DependencyGraphScene.this.findNodeEdges(this.node, false, true);
                object3 = collection.iterator();
                while (object3.hasNext()) {
                    object2 = (ArtifactGraphEdge)object3.next();
                    object4 = (EdgeWidget)DependencyGraphScene.this.findWidget(object2);
                    if (object4 == null) continue;
                    object4.modelChanged();
                }
                this.node.getWidget().modelChanged();
                if (DependencyGraphScene.this.findEdgesBetween(DependencyGraphScene.this.rootNode, this.node).isEmpty()) {
                    object3 = new ArtifactGraphEdge(DependencyGraphScene.this.rootNode.getArtifact(), this.node.getArtifact());
                    ((ArtifactGraphEdge)object3).setLevel(1);
                    ((ArtifactGraphEdge)object3).setPrimaryPath(true);
                    DependencyGraphScene.this.addEdge(object3);
                    DependencyGraphScene.this.setEdgeTarget(object3, this.node);
                    DependencyGraphScene.this.setEdgeSource(object3, DependencyGraphScene.this.rootNode);
                    this.node.setPrimaryLevel(1);
                    this.node.setArtifactParent(DependencyGraphScene.this.rootNode.getArtifact());
                    DependencyGraphScene.this.rootNode.getArtifact().addChild(this.node.getArtifact());
                    bl = true;
                }
            }
            if (fixDescription.isExclude) {
                collection = new HashSet();
                block1: for (Object object4 : this.node.getDuplicatesOrConflicts()) {
                    if (object4.getState() != 2) continue;
                    for (object3 = object4.getParent(); object3 != null; object3 = object3.getParent()) {
                        if (!fixDescription.exclusionTargets.contains(object3.getArtifact())) continue;
                        collection.add(object4);
                        continue block1;
                    }
                }
                object2 = new ArrayList();
                object4 = DependencyGraphScene.this.findNodeEdges(this.node, false, true);
                ArtifactGraphNode artifactGraphNode = null;
                boolean bl2 = false;
                block3: for (Object object5 : object4) {
                    artifactGraphNode = (ArtifactGraphNode)DependencyGraphScene.this.getEdgeSource(object5);
                    if (artifactGraphNode == null) continue;
                    for (Object object6 : fixDescription.conflictParents) {
                        if (artifactGraphNode.getArtifact().equals(object6)) {
                            bl2 = true;
                        }
                        if (!artifactGraphNode.represents((DependencyNode)object6)) continue;
                        object2.add(object5);
                        continue block3;
                    }
                }
                this.node.getDuplicatesOrConflicts().removeAll(collection);
                ArtifactVersion artifactVersion = object2.iterator();
                while (artifactVersion.hasNext()) {
                    Object object5;
                    object5 = (ArtifactGraphEdge)artifactVersion.next();
                    DependencyGraphScene.this.removeEdge(object5);
                    ((ArtifactGraphEdge)object5).getSource().removeChild(((ArtifactGraphEdge)object5).getTarget());
                    bl = true;
                }
                object4 = DependencyGraphScene.this.findNodeEdges(this.node, false, true);
                if (bl2) {
                    artifactVersion = DependencyGraphScene.findNewest(this.node, true);
                    this.node.getArtifact().getArtifact().setVersion(artifactVersion.toString());
                    for (Object object7 : object4) {
                        Object object6;
                        object6 = (EdgeWidget)DependencyGraphScene.this.findWidget(object7);
                        if (object6 == null) continue;
                        object6.modelChanged();
                    }
                }
                if (object4.isEmpty()) {
                    DependencyGraphScene.this.removeNodeWithEdges(this.node);
                    bl = true;
                } else {
                    this.node.getWidget().modelChanged();
                }
            }
            if (bl) {
                DependencyGraphScene.this.validate();
            }
        }
    }

    private class HighlitedZoomToFitAction
    extends AbstractAction {
        public HighlitedZoomToFitAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_ZoomToFit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = DependencyGraphScene.this.getNodes();
            ArrayList<ArtifactWidget> arrayList = new ArrayList<ArtifactWidget>();
            ArtifactWidget artifactWidget = null;
            for (ArtifactGraphNode artifactGraphNode : collection) {
                artifactWidget = artifactGraphNode.getWidget();
                int n = artifactWidget.getPaintState();
                if (n == 0 || n == 1) continue;
                arrayList.add(artifactWidget);
            }
            FitToViewLayout fitToViewLayout = DependencyGraphScene.this.getFitToViewLayout();
            fitToViewLayout.setWidgetsToFit(arrayList);
            fitToViewLayout.invokeLayout();
        }
    }

    private class SceneZoomToFitAction
    extends AbstractAction {
        public SceneZoomToFitAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_ZoomToFit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FitToViewLayout fitToViewLayout = DependencyGraphScene.this.getFitToViewLayout();
            fitToViewLayout.setWidgetsToFit(null);
            fitToViewLayout.invokeLayout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FitToViewLayout
    extends SceneLayout {
        private List<? extends Widget> widgets = null;
        private DependencyGraphScene depScene;

        public FitToViewLayout(DependencyGraphScene dependencyGraphScene) {
            super((Scene)dependencyGraphScene);
            this.depScene = dependencyGraphScene;
        }

        public void setWidgetsToFit(List<? extends Widget> list) {
            this.widgets = list;
        }

        protected void performLayout() {
            Object object2;
            Rectangle rectangle = null;
            List list = this.widgets != null ? this.widgets : this.depScene.getChildren();
            for (Object object2 : list) {
                if (rectangle == null) {
                    rectangle = object2.convertLocalToScene(object2.getBounds());
                    continue;
                }
                rectangle = rectangle.union(object2.convertLocalToScene(object2.getBounds()));
            }
            if (this.widgets == null) {
                rectangle.grow(5, 5);
            } else {
                rectangle.grow(25, 25);
            }
            Dimension dimension = rectangle.getSize();
            object2 = this.depScene.tc.getScrollPane().getViewportBorderBounds().getSize();
            double d = Math.min((double)object2.width / (double)dimension.width, (double)object2.height / (double)dimension.height);
            if (this.depScene.isAnimated()) {
                if (this.widgets == null) {
                    this.depScene.getSceneAnimator().animateZoomFactor(d);
                } else {
                    CenteredZoomAnimator centeredZoomAnimator = new CenteredZoomAnimator(this.depScene.getSceneAnimator());
                    centeredZoomAnimator.setZoomFactor(d, new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY()));
                }
            } else {
                this.depScene.setZoomFactor(d);
            }
        }
    }

    private class AllActionsProvider
    implements PopupMenuProvider,
    MoveProvider,
    EditProvider,
    SelectProvider {
        private Point moveStart;

        private AllActionsProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point point) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (widget == DependencyGraphScene.this) {
                jPopupMenu.add(DependencyGraphScene.this.sceneZoomToFitAction);
            } else {
                ArtifactGraphNode artifactGraphNode = (ArtifactGraphNode)DependencyGraphScene.this.findObject(widget);
                if (DependencyGraphScene.this.isEditable() && DependencyGraphScene.isFixCandidate(artifactGraphNode)) {
                    jPopupMenu.add(new FixVersionConflictAction(artifactGraphNode));
                }
                jPopupMenu.add(DependencyGraphScene.this.highlitedZoomToFitAction);
                if (!artifactGraphNode.isRoot()) {
                    Action action = CommonArtifactActions.createViewArtifactDetails((Artifact)artifactGraphNode.getArtifact().getArtifact(), (List)DependencyGraphScene.this.project.getRemoteArtifactRepositories());
                    action.putValue("PANEL_HINT", "grf");
                    action.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_Show_Graph"));
                    jPopupMenu.add(action);
                }
            }
            return jPopupMenu;
        }

        public void movementStarted(Widget widget) {
            widget.bringToFront();
            this.moveStart = widget.getLocation();
        }

        public void movementFinished(Widget widget) {
            Object object;
            Point point = widget.getLocation();
            if (this.moveStart.distance(point) < 5.0 && (object = DependencyGraphScene.this.findObject(widget)) instanceof ArtifactGraphNode) {
                DependencyGraphScene.this.highlightRelated((ArtifactGraphNode)object);
            }
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point point) {
            widget.setPreferredLocation(point);
        }

        public void edit(Widget widget) {
            if (DependencyGraphScene.this == widget) {
                DependencyGraphScene.this.sceneZoomToFitAction.actionPerformed(null);
            } else {
                DependencyGraphScene.this.highlitedZoomToFitAction.actionPerformed(null);
            }
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bl) {
            DependencyGraphScene.this.setSelectedObjects(EMPTY_SELECTION);
            DependencyGraphScene.this.tc.depthHighlight();
        }
    }
}

