/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class ProjectClassPathModifier {
    private ProjectClassPathModifier() {
    }

    public static boolean addLibraries(Library[] libraryArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(libraryArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean bl = false;
        for (Library library : libraryArray) {
            bl |= extensible.pcpe.addLibrary(library);
        }
        return bl;
    }

    public static boolean removeLibraries(Library[] libraryArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeLibraries(libraryArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove libraries using " + extensible);
    }

    public static boolean addRoots(URL[] uRLArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addRoots(uRLArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean bl = false;
        for (URL uRL : uRLArray) {
            FileObject fileObject2;
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            if ((fileObject2 = URLMapper.findFileObject((URL)uRL)) == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            bl |= extensible.pcpe.addArchiveFile(fileObject2);
        }
        return bl;
    }

    public static boolean addRoots(URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addRoots(uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean bl = false;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        for (URI uRI : uRIArray) {
            FileObject fileObject2;
            URI uRI2 = LibrariesSupport.getArchiveFile((URI)uRI);
            if (uRI2 == null) {
                uRI2 = uRI;
            }
            if (uRI2.isAbsolute()) {
                fileObject2 = FileUtil.toFileObject((File)new File(uRI2));
            } else {
                File file2 = PropertyUtils.resolveFile((File)file, (String)LibrariesSupport.convertURIToFilePath((URI)uRI2));
                fileObject2 = FileUtil.toFileObject((File)file2);
            }
            if (fileObject2 == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            bl |= extensible.pcpe.addArchiveFile(fileObject2);
        }
        return bl;
    }

    public static boolean removeRoots(URL[] uRLArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(uRLArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean removeRoots(URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        assert (antArtifactArray.length == uRIArray.length);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(antArtifactArray, uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean bl = false;
        for (int i = 0; i < antArtifactArray.length; ++i) {
            bl |= extensible.pcpe.addAntArtifact(antArtifactArray[i], uRIArray[i]);
        }
        return bl;
    }

    public static boolean addProjects(Project[] projectArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addProjects(projectArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot add project as dependency. Missing ProjectClassPathModifierImplementation service in project type.");
    }

    public static boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, FileObject fileObject, String string) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(fileObject, string);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeAntArtifacts(antArtifactArray, uRIArray, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove artifacts from " + extensible);
    }

    private static Extensible findExtensible(FileObject fileObject, String string) throws UnsupportedOperationException {
        assert (fileObject != null);
        assert (string != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            throw new UnsupportedOperationException("No project found to correspond to " + FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        ProjectClassPathModifierImplementation projectClassPathModifierImplementation = (ProjectClassPathModifierImplementation)project.getLookup().lookup(ProjectClassPathModifierImplementation.class);
        if (projectClassPathModifierImplementation != null) {
            SourceGroup[] sourceGroupArray = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(projectClassPathModifierImplementation);
            assert (sourceGroupArray != null) : "Class: " + projectClassPathModifierImplementation.getClass() + " returned null as source groups.";
            for (SourceGroup sourceGroup : sourceGroupArray) {
                if (fileObject != sourceGroup.getRootFolder() && !FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
                String[] stringArray = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(projectClassPathModifierImplementation, sourceGroup);
                assert (stringArray != null) : "Class: " + projectClassPathModifierImplementation.getClass() + " returned null as classpath types.";
                for (String string2 : stringArray) {
                    if (!string.equals(string2)) continue;
                    String string3 = "ProjectClassPathModifierImplementation for " + string + " on " + FileUtil.getFileDisplayName((FileObject)sourceGroup.getRootFolder());
                    return new Extensible(projectClassPathModifierImplementation, sourceGroup, string2, string3);
                }
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathModifierImplementation but it will not handle " + string + " for " + FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (projectClassPathExtender != null) {
            if (string.equals("classpath/compile")) {
                return new Extensible(projectClassPathExtender, "ProjectClassPathExtender for " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathExtender in its lookup but no ProjectClassPathModifierImplementation to handle " + string);
        }
        throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has neither a ProjectClassPathModifierImplementation nor a ProjectClassPathExtender in its lookup");
    }

    private static final class Extensible {
        private final String classPathType;
        private final SourceGroup sg;
        private final ProjectClassPathModifierImplementation pcmi;
        private final ProjectClassPathExtender pcpe;
        private final String label;

        private Extensible(ProjectClassPathModifierImplementation projectClassPathModifierImplementation, SourceGroup sourceGroup, String string, String string2) {
            assert (projectClassPathModifierImplementation != null);
            assert (sourceGroup != null);
            assert (string != null);
            this.pcmi = projectClassPathModifierImplementation;
            this.sg = sourceGroup;
            this.classPathType = string;
            this.pcpe = null;
            this.label = string2;
        }

        private Extensible(ProjectClassPathExtender projectClassPathExtender, String string) {
            assert (projectClassPathExtender != null);
            this.pcpe = projectClassPathExtender;
            this.pcmi = null;
            this.sg = null;
            this.classPathType = "classpath/compile";
            this.label = string;
        }

        public String toString() {
            return this.label;
        }
    }
}

