/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientOptionsPanelGUI
extends JPanel
implements DocumentListener,
ActionListener {
    private static Project clientProject;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final ListCellRenderer CELL_RENDERER;
    private SourceGroup preselectedGroup;
    private JLabel clientNameLabel;
    private JTextField clientNameTextField;
    private JCheckBox createDataBindingCheckBox;
    private JLabel createdFileLabel;
    private JTextField createdFileTextField;
    private JCheckBox floatingPointCheckBox;
    private JCheckBox generateStubsCheckBox;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;

    public ClientOptionsPanelGUI() {
        this.initComponents();
        this.packageComboBox.setRenderer(CELL_RENDERER);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSN_Client_Options_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Options_Panel"));
        this.clientNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Name"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Project"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Package"));
        this.createdFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Client_Created_File"));
        this.generateStubsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Generate_Stubs"));
        this.floatingPointCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Floating_point"));
        this.createDataBindingCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"ACSD_Sample_MIDlet"));
    }

    public void setValues(Project project, String string, FileObject fileObject) {
        Object object;
        clientProject = project;
        this.clientNameTextField.setText(string);
        this.expectedExtension = "java".length() == 0 ? "" : ".java";
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (this.preselectedGroup == null) {
            this.preselectedGroup = this.getPreselectedGroup(sourceGroupArray, fileObject);
            if (this.preselectedGroup != null) {
                object = new ModelItem(this.preselectedGroup);
                ModelItem[] modelItemArray = ((ModelItem)object).getChildren();
                this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>(modelItemArray));
                ModelItem modelItem = this.getPreselectedPackage((ModelItem)object, fileObject);
                if (modelItem != null) {
                    this.packageComboBox.setSelectedItem(modelItem);
                }
            } else {
                this.packageComboBox.setModel(new DefaultComboBoxModel());
            }
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        object = this.packageComboBox.getEditor().getEditorComponent();
        ((JTextField)object).getDocument().addDocumentListener(this);
        this.clientNameTextField.getDocument().addDocumentListener(this);
        this.updateText();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
        this.fireChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
        }
    }

    public String getProjectName() {
        return this.projectTextField.getText();
    }

    public String getTargetName() {
        return this.clientNameTextField.getText().trim();
    }

    public boolean isGenerateStubs() {
        return this.generateStubsCheckBox.isSelected();
    }

    public boolean isFloatingPointUsed() {
        return this.floatingPointCheckBox.isSelected();
    }

    public boolean isDataBinded() {
        return this.createDataBindingCheckBox.isSelected();
    }

    public String getCreatedFile() {
        return this.createdFileTextField.getText();
    }

    final FileObject getRootFolder() {
        return this.preselectedGroup.getRootFolder();
    }

    final SourceGroup getSourceGroup() {
        return this.preselectedGroup;
    }

    private void updateText() {
        File file = FileUtil.toFile((FileObject)clientProject.getProjectDirectory());
        if (file != null) {
            String string = this.clientNameTextField.getText().trim();
            if (string.length() == 0) {
                this.createdFileTextField.setText("");
            } else {
                File file2 = this.getFolder();
                if (file2 != null) {
                    File file3 = new File(file2, string + this.expectedExtension);
                    this.createdFileTextField.setText(file3.getAbsolutePath());
                } else {
                    this.createdFileTextField.setText("");
                }
            }
        } else {
            this.createdFileTextField.setText("");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.clientNameLabel = new JLabel();
        this.clientNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.createdFileLabel = new JLabel();
        this.createdFileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.generateStubsCheckBox = new JCheckBox();
        this.floatingPointCheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.createDataBindingCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setPreferredSize(new Dimension(560, 350));
        this.setLayout(new GridBagLayout());
        this.clientNameLabel.setLabelFor(this.clientNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.clientNameLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_ClientName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.clientNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.clientNameTextField, gridBagConstraints);
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.createdFileLabel.setLabelFor(this.createdFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFileLabel, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Client_Created_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.createdFileLabel, gridBagConstraints);
        this.createdFileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdFileTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.generateStubsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateStubsCheckBox, (String)NbBundle.getBundle(ClientOptionsPanelGUI.class).getString("LBL_Generate_Stubs"));
        this.generateStubsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generateStubsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.generateStubsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientOptionsPanelGUI.this.generateStubsCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.generateStubsCheckBox, gridBagConstraints);
        this.floatingPointCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.floatingPointCheckBox, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Floating_Point"));
        this.floatingPointCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.floatingPointCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.floatingPointCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createDataBindingCheckBox, (String)NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_Create_Sample_MIDlet"));
        this.createDataBindingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createDataBindingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createDataBindingCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void generateStubsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        if (fileObject != null) {
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return sourceGroupArray[i];
            }
        }
        return sourceGroupArray.length >= 0 ? sourceGroupArray[0] : null;
    }

    private ModelItem getPreselectedPackage(ModelItem modelItem, FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ModelItem[] modelItemArray = modelItem.getChildren();
        FileObject fileObject2 = modelItem.group.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        string = string == null ? "" : string.replace('/', '.');
        for (int i = 0; i < modelItemArray.length; ++i) {
            if (!modelItemArray[i].toString().equals(string)) continue;
            return modelItemArray[i];
        }
        return null;
    }

    public File getFolder() {
        FileObject fileObject = this.getRootFolder();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return new File(file, this.getPackageFileName());
    }

    public String getPackageFileName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        if (ModelItem.DEFAULT_PACKAGE_DISPLAY_NAME.equals(string)) {
            string = "";
        }
        return string.replace('.', '/');
    }

    static {
        CELL_RENDERER = new NodeCellRenderer();
    }

    private static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ModelItem) {
                ModelItem modelItem = (ModelItem)object;
                this.setText(modelItem.getDisplayName());
                this.setIcon(modelItem.getIcon());
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        public static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(ClientOptionsPanelGUI.class, (String)"LBL_MIDPTargetChooserPanelGUI_DefaultPackage");
        private Node node;
        protected SourceGroup group;
        private final Icon icon;
        private ModelItem[] children;

        public ModelItem(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.icon = sourceGroup.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String string = this.node.getName();
            return string.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node node = PackageView.createPackageView((SourceGroup)this.group);
                if (node == null) {
                    return null;
                }
                Children children = node.getChildren();
                if (children == null) {
                    return null;
                }
                Node[] nodeArray = children.getNodes(true);
                this.children = new ModelItem[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.children[i] = new ModelItem(nodeArray[i]);
                }
            }
            return this.children;
        }
    }
}

