/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WebJaxWsLookupProvider
implements LookupProvider {
    private String JAX_WS_XML_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml";
    private String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-web.xsl";
    private String JAXWS_EXTENSION = "jaxws";

    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            return null;
        }
        final JaxWsModel jaxWsModel = this.getJaxWsModel(project);
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(){
            private FileChangeListener jaxWsListener;
            private ChangeListener jaxWsCreationListener;
            private JaxWsModel.ServiceListener serviceListener;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void projectOpened() {
                if (jaxWsModel != null) {
                    this.serviceListener = new JaxWsModel.ServiceListener(){

                        public void serviceAdded(String string, String string2) {
                            WebServiceNotifier webServiceNotifier = (WebServiceNotifier)project.getLookup().lookup(WebServiceNotifier.class);
                            if (webServiceNotifier != null) {
                                webServiceNotifier.serviceAdded(string, string2);
                            }
                        }

                        public void serviceRemoved(String string) {
                            WebServiceNotifier webServiceNotifier = (WebServiceNotifier)project.getLookup().lookup(WebServiceNotifier.class);
                            if (webServiceNotifier != null) {
                                webServiceNotifier.serviceRemoved(string);
                            }
                        }
                    };
                    jaxWsModel.addServiceListener(this.serviceListener);
                    AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
                    if (antBuildExtender != null) {
                        AntBuildExtender.Extension extension;
                        boolean bl = false;
                        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                        int n = jaxWsModel.getClients().length;
                        int n2 = jaxWsModel.getServices().length;
                        int n3 = 0;
                        for (Service object : jaxWsModel.getServices()) {
                            if (object.getWsdlUrl() == null) continue;
                            ++n3;
                        }
                        Boolean bl2 = jaxWsModel.getJsr109();
                        int n4 = bl2 == null ? 1 : bl2;
                        try {
                            extension = antBuildExtender.getExtension(WebJaxWsLookupProvider.this.JAXWS_EXTENSION);
                            if (fileObject == null || extension == null) {
                                if (n2 + n > 0) {
                                    WebJaxWsLookupProvider.this.addJaxWsExtension(project, WebJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender, n2, n3, n, n4 != 0);
                                    ProjectManager.getDefault().saveProject(project);
                                    bl = true;
                                }
                            } else if (n2 + n == 0) {
                                WebJaxWsLookupProvider.this.removeJaxWsExtension(fileObject, antBuildExtender);
                                ProjectManager.getDefault().saveProject(project);
                                bl = true;
                            } else {
                                WebJaxWsLookupProvider.this.removeCompileDependencies(project, fileObject, antBuildExtender);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        extension = jaxWsModel.getJaxWsFile();
                        if (extension != null) {
                            this.jaxWsListener = new FileChangeAdapter(){

                                public void fileChanged(FileEvent fileEvent) {
                                    this.handleJaxsClientBuildScript();
                                }
                            };
                            extension.addFileChangeListener(this.jaxWsListener);
                        } else {
                            this.jaxWsCreationListener = new ChangeListener(){

                                public void stateChanged(ChangeEvent changeEvent) {
                                    FileObject fileObject = jaxWsModel.getJaxWsFile();
                                    if (fileObject != null) {
                                        jaxWsListener = (FileChangeListener)new FileChangeAdapter(){

                                            public void fileChanged(FileEvent fileEvent) {
                                                this.handleJaxsClientBuildScript();
                                            }
                                        };
                                        fileObject.addFileChangeListener(jaxWsListener);
                                    }
                                }
                            };
                            jaxWsModel.addChangeListener(this.jaxWsCreationListener);
                        }
                        if (extension != null && !bl) {
                            URL uRL = WebJaxWsLookupProvider.class.getResource(WebJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE);
                            assert (uRL != null);
                            try {
                                String string;
                                EditableProperties editableProperties;
                                boolean bl3 = false;
                                InputStream inputStream = uRL.openStream();
                                String string2 = null;
                                try {
                                    string2 = TransformerUtils.getCrc32(inputStream);
                                }
                                finally {
                                    inputStream.close();
                                }
                                if (string2 != null && (editableProperties = WSUtils.getEditableProperties(project, "nbproject/genfiles.properties")) != null && !string2.equals(string = editableProperties.getProperty("nbproject/jaxws-build.xml.stylesheet.CRC32"))) {
                                    editableProperties.setProperty("nbproject/jaxws-build.xml.stylesheet.CRC32", string2);
                                    WSUtils.storeEditableProperties(project, "nbproject/genfiles.properties", editableProperties);
                                    bl3 = true;
                                }
                                if (bl3) {
                                    TransformerUtils.transformClients(project.getProjectDirectory(), WebJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, true);
                                }
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "failed to generate jaxws-build.xml from stylesheet", iOException);
                            }
                        }
                    }
                }
            }

            protected void projectClosed() {
                if (jaxWsModel != null) {
                    jaxWsModel.removeChangeListener(this.jaxWsCreationListener);
                    FileObject fileObject = jaxWsModel.getJaxWsFile();
                    if (fileObject != null) {
                        fileObject.removeFileChangeListener(this.jaxWsListener);
                    }
                    jaxWsModel.removeServiceListener(this.serviceListener);
                }
            }

            private void handleJaxsClientBuildScript() {
                AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
                if (antBuildExtender != null) {
                    FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                    int n = jaxWsModel.getClients().length;
                    int n2 = jaxWsModel.getServices().length;
                    int n3 = 0;
                    for (Service service : jaxWsModel.getServices()) {
                        if (service.getWsdlUrl() == null) continue;
                        ++n3;
                    }
                    Boolean bl = jaxWsModel.getJsr109();
                    int n4 = bl == null ? 1 : bl;
                    try {
                        if (n + n2 == 0) {
                            WebJaxWsLookupProvider.this.removeJaxWsExtension(fileObject, antBuildExtender);
                        } else {
                            WebJaxWsLookupProvider.this.changeJaxWsExtension(project, WebJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender, n2, n3, n, n4 != 0);
                        }
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WebJaxWsLookupProvider.class.getName()).log(Level.WARNING, "Problems with generating jaxws-build.xml", iOException);
                    }
                }
            }
        };
        return Lookups.fixed((Object[])new Object[]{projectOpenedHook, jaxWsModel});
    }

    private JaxWsModel getJaxWsModel(Project project) {
        try {
            FileObject fileObject = this.findJaxWsFileObject(project);
            if (fileObject == null) {
                return JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream(this.JAX_WS_XML_RESOURCE));
            }
            JaxWsModel jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(fileObject);
            return jaxWsModel;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
    }

    private void addJaxWsExtension(Project project, String string, AntBuildExtender antBuildExtender, int n, int n2, int n3, boolean bl) throws IOException {
        TransformerUtils.transformClients(project.getProjectDirectory(), string, true);
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension == null) {
            extension = antBuildExtender.addExtension(this.JAXWS_EXTENSION, fileObject);
            if (n3 > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            }
            if (n2 > 0) {
                extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
            }
        }
    }

    private void changeJaxWsExtension(Project project, String string, AntBuildExtender antBuildExtender, int n, int n2, int n3, boolean bl) throws IOException {
        TransformerUtils.transformClients(project.getProjectDirectory(), string, true);
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        if (fileObject == null) {
            throw new IOException("Cannot generate jaxws-build.xml file");
        }
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        boolean bl2 = false;
        if (extension == null) {
            extension = antBuildExtender.addExtension(this.JAXWS_EXTENSION, fileObject);
            bl2 = true;
        }
        if (n3 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
        } else if (!bl2) {
            extension.removeDependency("-pre-pre-compile", "wsimport-client-generate");
        }
        if (n2 > 0) {
            extension.addDependency("-pre-pre-compile", "wsimport-service-generate");
        } else if (!bl2) {
            extension.removeDependency("-pre-pre-compile", "wsimport-service-generate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJaxWsExtension(FileObject fileObject, final AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    antBuildExtender.removeExtension(WebJaxWsLookupProvider.this.JAXWS_EXTENSION);
                }
            });
        }
        if (fileObject != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    private void removeCompileDependencies(Project project, FileObject fileObject, AntBuildExtender antBuildExtender) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.contains("wsimport-client-compile") && !string.contains("wsimport-service-compile") && !string.contains("wsgen-service-compile")) continue;
            bl = true;
            break;
        }
        bufferedReader.close();
        if (bl) {
            TransformerUtils.transformClients(project.getProjectDirectory(), this.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-ws-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                extension.removeDependency("-do-compile", "wsimport-service-compile");
                extension.removeDependency("-do-compile-single", "wsimport-service-compile");
                extension.removeDependency("-post-compile", "wsgen-service-compile");
                ProjectManager.getDefault().saveProject(project);
            }
        }
    }
}

