/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class AntBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final String ANT_MIME_TYPE = "text/x-ant+xml";
    private static final Set actions = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    EditorContextDispatcher context = EditorContextDispatcher.getDefault();

    public AntBreakpointActionProvider() {
        this.context.addPropertyChangeListener(ANT_MIME_TYPE, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public void doAction(Object object) {
        int n;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n2 = breakpointArray.length;
        for (n = 0; n < n2; ++n) {
            if (!(breakpointArray[n] instanceof AntBreakpoint) || !((AntBreakpoint)breakpointArray[n]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpointArray[n]);
            break;
        }
        if (n == n2) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new AntBreakpoint(line));
        }
    }

    public Set getActions() {
        return actions;
    }

    private static Line getCurrentLine() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!AntBreakpointActionProvider.isAntFile(fileObject)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isAntFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        return fileObject.getMIMEType().equals(ANT_MIME_TYPE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = AntBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

