/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.patch.ContextualPatch;
import org.netbeans.modules.bugtracking.patch.Patch;
import org.netbeans.modules.bugtracking.patch.PatchException;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.issue.PatchContextChooser;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelector;
import org.netbeans.modules.bugtracking.util.Scrambler;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class BugtrackingUtil {
    private static Logger METRICS_LOG = Logger.getLogger("org.netbeans.ui.metrics.bugtracking");
    public static final String USG_BUGTRACKING_AUTOMATIC_REFRESH = "USG_BUGTRACKING_AUTOMATIC_REFRESH";
    public static final String USG_BUGTRACKING_QUERY = "USG_BUGTRACKING_QUERY";
    private static FocusListener scrollingFocusListener;

    public static boolean show(JPanel jPanel, String string, String string2) {
        JButton jButton = new JButton(string2);
        jButton.getAccessibleContext().setAccessibleDescription(jButton.getText());
        JButton jButton2 = new JButton(NbBundle.getMessage(BugtrackingUtil.class, (String)"LBL_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(jButton2.getText());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(jPanel.getClass()), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton;
    }

    public static Issue[] getOpenIssues() {
        Set set = TopComponent.getRegistry().getOpened();
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        for (TopComponent topComponent : set) {
            if (!(topComponent instanceof IssueTopComponent)) continue;
            arrayList.add(((IssueTopComponent)topComponent).getIssue());
        }
        return arrayList.toArray(new Issue[arrayList.size()]);
    }

    public static Issue[] getByIdOrSummary(Issue[] issueArray, String string) {
        if (string == null) {
            return issueArray;
        }
        if ((string = string.trim()).equals("")) {
            return issueArray;
        }
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        for (Issue issue : issueArray) {
            if (!string.equals(issue.getID()) && issue.getSummary().indexOf(string) <= -1) continue;
            arrayList.add(issue);
        }
        return arrayList.toArray(new Issue[arrayList.size()]);
    }

    public static Repository createRepository() {
        RepositorySelector repositorySelector = new RepositorySelector();
        Repository repository = repositorySelector.create();
        return repository;
    }

    public static boolean editRepository(Repository repository, String string) {
        RepositorySelector repositorySelector = new RepositorySelector();
        return repositorySelector.edit(repository, string);
    }

    public static boolean editRepository(Repository repository) {
        return BugtrackingUtil.editRepository(repository, null);
    }

    public static Repository[] getKnownRepositories() {
        return BugtrackingManager.getInstance().getKnownRepositories();
    }

    public static BugtrackingConnector[] getBugtrackingConnectors() {
        return BugtrackingManager.getInstance().getConnectors();
    }

    public static Repository getKenaiBugtrackingRepository(KenaiProject kenaiProject) {
        return KenaiRepositories.getInstance().getRepository(kenaiProject);
    }

    public static String scramble(String string) {
        return Scrambler.getInstance().scramble(string);
    }

    public static String descramble(String string) {
        return Scrambler.getInstance().descramble(string);
    }

    public static Issue selectIssue(String string, Repository repository, JPanel jPanel) {
        QuickSearchComboBar quickSearchComboBar = new QuickSearchComboBar(jPanel);
        quickSearchComboBar.setRepository(repository);
        quickSearchComboBar.setAlignmentX(0.0f);
        quickSearchComboBar.setMaximumSize(new Dimension(Short.MAX_VALUE, quickSearchComboBar.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 3);
        jPanel2.setLayout(boxLayout);
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        jPanel2.add(jLabel);
        jLabel.setLabelFor(quickSearchComboBar.getCommand());
        LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
        int n = layoutStyle.getPreferredGap((JComponent)jLabel, (JComponent)quickSearchComboBar, 0, 5, (Container)jPanel2);
        jPanel2.add(Box.createVerticalStrut(n));
        jPanel2.add(quickSearchComboBar);
        jPanel2.add(Box.createVerticalStrut(n));
        ResourceBundle resourceBundle = NbBundle.getBundle(BugtrackingUtil.class);
        JLabel jLabel2 = new JLabel(resourceBundle.getString("MSG_SelectIssueHint"));
        jLabel2.setEnabled(false);
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(80));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap((JComponent)jPanel2, 1, null), layoutStyle.getContainerGap((JComponent)jPanel2, 7, null), 0, layoutStyle.getContainerGap((JComponent)jPanel2, 3, null)));
        jPanel2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_IssueSelector"));
        Issue issue = null;
        JButton jButton = new JButton(resourceBundle.getString("LBL_Select"));
        jButton.getAccessibleContext().setAccessibleDescription(jButton.getText());
        JButton jButton2 = new JButton(resourceBundle.getString("LBL_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(jButton2.getText());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel2, resourceBundle.getString("LBL_Issues"), true, 2, (Object)jButton, null);
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.bugtracking.issueChooser"));
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            issue = quickSearchComboBar.getIssue();
        }
        return issue;
    }

    public static File selectPatchContext() {
        PatchContextChooser patchContextChooser = new PatchContextChooser();
        ResourceBundle resourceBundle = NbBundle.getBundle(BugtrackingUtil.class);
        JButton jButton = new JButton(resourceBundle.getString("LBL_Apply"));
        JButton jButton2 = new JButton(resourceBundle.getString("LBL_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)patchContextChooser, resourceBundle.getString("LBL_ApplyPatch"), true, 2, (Object)jButton, null);
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.bugtracking.patchContextChooser"));
        File file = null;
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            file = patchContextChooser.getSelectedFile();
        }
        return file;
    }

    public static void applyPatch(File file, File file2) {
        try {
            ContextualPatch contextualPatch = ContextualPatch.create(file, file2);
            contextualPatch.patch(false);
        }
        catch (PatchException patchException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, patchException);
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                BugtrackingUtil.deleteRecursively(fileArray[i]);
            }
        }
        file.delete();
    }

    public static File getLargerContext() {
        File file;
        FileObject fileObject = BugtrackingUtil.getOpenFileObj();
        if (fileObject != null && (file = BugtrackingUtil.getLargerContext(fileObject)) != null) {
            return file;
        }
        return BugtrackingUtil.getContextFromProjects();
    }

    public static File getContextFromProjects() {
        OpenProjects openProjects = OpenProjects.getDefault();
        Project project = openProjects.getMainProject();
        if (project != null) {
            return BugtrackingUtil.getLargerContext(project);
        }
        Project[] projectArray = openProjects.getOpenProjects();
        if (projectArray != null && projectArray.length == 1) {
            return BugtrackingUtil.getLargerContext(projectArray[0]);
        }
        return null;
    }

    public static File getLargerContext(File file) {
        return BugtrackingUtil.getLargerContext(file, null);
    }

    public static File getLargerContext(FileObject fileObject) {
        return BugtrackingUtil.getLargerContext(null, fileObject);
    }

    public static File getLargerContext(File file, FileObject fileObject) {
        if (file == null && fileObject == null) {
            throw new IllegalArgumentException("both File and FileObject are null");
        }
        assert (file == null || fileObject == null || FileUtil.toFileObject((File)file).equals(fileObject));
        if (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)file);
        } else if (file == null) {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        if (fileObject == null) {
            return null;
        }
        if (!fileObject.isValid()) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            FileObject fileObject2 = project.getProjectDirectory();
            if (fileObject2.equals(fileObject) && file != null) {
                return file;
            }
            File file2 = FileUtil.toFile((FileObject)fileObject2);
            if (file2 != null) {
                return file2;
            }
        }
        if (fileObject.isFolder()) {
            return file;
        }
        fileObject = fileObject.getParent();
        assert (fileObject != null);
        return FileUtil.toFile((FileObject)fileObject);
    }

    public static File getLargerContext(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        assert (fileObject != null);
        return FileUtil.toFile((FileObject)fileObject);
    }

    private static FileObject getOpenFileObj() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dataObject == null || !dataObject.isValid()) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static void keepFocusedComponentVisible(JScrollPane jScrollPane) {
        BugtrackingUtil.keepFocusedComponentVisible(jScrollPane.getViewport().getView());
    }

    public static void keepFocusedComponentVisible(Component component) {
        FocusListener focusListener = BugtrackingUtil.getScrollingFocusListener();
        component.removeFocusListener(focusListener);
        component.addFocusListener(focusListener);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                BugtrackingUtil.keepFocusedComponentVisible(component2);
            }
        }
    }

    private static FocusListener getScrollingFocusListener() {
        if (scrollingFocusListener == null) {
            scrollingFocusListener = new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        Component component = focusEvent.getComponent();
                        Container container = component.getParent();
                        if (container instanceof JViewport) {
                            component = container;
                            container = container.getParent();
                        }
                        if (container instanceof JComponent) {
                            ((JComponent)container).scrollRectToVisible(component.getBounds());
                        }
                    }
                }
            };
        }
        return scrollingFocusListener;
    }

    public static void logQueryEvent(String string, String string2, int n, boolean bl, boolean bl2) {
        string2 = BugtrackingUtil.obfuscateQueryName(string2);
        BugtrackingUtil.logBugtrackingEvents(USG_BUGTRACKING_QUERY, new Object[]{string, string2, n, bl, bl2});
    }

    public static void logAutoRefreshEvent(String string, String string2, boolean bl, boolean bl2) {
        string2 = BugtrackingUtil.obfuscateQueryName(string2);
        BugtrackingUtil.logBugtrackingEvents(USG_BUGTRACKING_AUTOMATIC_REFRESH, new Object[]{string, string2, bl, bl2});
    }

    public static int getColumnWidthInPixels(int n, JComponent jComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("u");
        }
        return BugtrackingUtil.getColumnWidthInPixels(stringBuffer.toString(), jComponent);
    }

    public static int getColumnWidthInPixels(String string, JComponent jComponent) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        return fontMetrics.stringWidth(string);
    }

    private static void logBugtrackingEvents(String string, Object[] objectArray) {
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setParameters(objectArray);
        logRecord.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(logRecord);
    }

    private static String getMD5(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String obfuscateQueryName(String string) {
        string = string == null ? "Find Issues" : BugtrackingUtil.getMD5(string);
        return string;
    }

    public static void fixFocusTraversalKeys(JComponent jComponent) {
        Set<AWTKeyStroke> set = jComponent.getFocusTraversalKeys(0);
        set = new HashSet<AWTKeyStroke>(set);
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 640));
        jComponent.setFocusTraversalKeys(0, set);
    }

    public static void issue163946Hack(final JScrollPane jScrollPane) {
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (jScrollPane.getVerticalScrollBar().isShowing()) {
                    if (mouseWheelEvent.getSource() != jScrollPane) {
                        mouseWheelEvent.setSource(jScrollPane);
                        jScrollPane.dispatchEvent(mouseWheelEvent);
                    }
                } else {
                    jScrollPane.getParent().dispatchEvent(mouseWheelEvent);
                }
            }
        };
        jScrollPane.addMouseWheelListener(mouseWheelListener);
        jScrollPane.getViewport().getView().addMouseWheelListener(mouseWheelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPatch(FileObject fileObject) throws IOException {
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
        try {
            bl = Patch.parse(bufferedReader).length > 0;
        }
        finally {
            ((Reader)bufferedReader).close();
        }
        return bl;
    }
}

