/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPopup;
import org.openide.util.NbBundle;

public class QuickSearchComboBar
extends JPanel {
    QuickSearchPopup displayer;
    Color origForeground;
    private JPanel caller;
    private Issue issue;
    PropertyChangeSupport changeSupport;
    private boolean ignoreCommandChanges = false;
    public static String EVT_ISSUE_CHANGED = "QuickSearchComboBar.issue.changed";
    private JTextField command;

    public QuickSearchComboBar(JPanel jPanel) {
        this.caller = jPanel;
        this.displayer = new QuickSearchPopup(this);
        this.initComponents();
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.textChanged();
            }

            private void textChanged() {
                if (QuickSearchComboBar.this.ignoreCommandChanges) {
                    return;
                }
                if (QuickSearchComboBar.this.command.isFocusOwner()) {
                    QuickSearchComboBar.this.displayer.maybeEvaluate(QuickSearchComboBar.this.command.getText());
                }
                QuickSearchComboBar.this.setIssue(null);
            }
        });
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setRepository(Repository repository) {
        this.displayer.setRepository(repository);
    }

    void setIssue(Issue issue) {
        Issue issue2 = this.issue;
        this.issue = issue;
        if (this.issue != null) {
            this.ignoreCommandChanges = true;
            this.command.setText(PopupItem.IssueItem.getIssueDescription(this.issue));
            this.ignoreCommandChanges = false;
            this.displayer.setVisible(false);
        }
        if (issue2 != null || this.issue != null) {
            this.getChangeSupport().firePropertyChange(EVT_ISSUE_CHANGED, issue2, this.issue);
        }
    }

    private void initComponents() {
        this.command = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                QuickSearchComboBar.this.formFocusLost(focusEvent);
            }
        });
        this.command.setText(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.command.text"));
        this.command.setName("command");
        this.command.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                QuickSearchComboBar.this.commandKeyPressed(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.command, -1, 353, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.command, -2, -1, -2));
        this.command.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.command.AccessibleContext.accessibleName"));
        this.command.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.command.AccessibleContext.accessibleDescription"));
    }

    private void formFocusLost(FocusEvent focusEvent) {
        this.displayer.setVisible(false);
    }

    private void commandKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.displayer.selectNext();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 38) {
            this.displayer.selectPrev();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.invokeSelectedItem();
        } else if (keyEvent.getKeyCode() == 27) {
            this.returnFocus();
            this.displayer.clearModel();
            keyEvent.consume();
        }
    }

    private void returnFocus() {
        this.displayer.setVisible(false);
        if (this.caller != null) {
            this.caller.requestFocus();
        }
    }

    public void enableFields(boolean bl) {
        this.command.setEnabled(bl);
    }

    public void invokeSelectedItem() {
        JList jList = this.displayer.getList();
        if (jList.getModel().getSize() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JList jList = QuickSearchComboBar.this.displayer.getList();
                    if (jList.getSelectedIndex() == -1) {
                        jList.setSelectedIndex(jList.getModel().getSize() - 1);
                    }
                    QuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport;
    }

    public void setNoResults(boolean bl) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(this.command.getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(bl ? Color.RED : this.origForeground);
    }

    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public JTextField getCommand() {
        return this.command;
    }

    static Color getPopupBorderColor() {
        Color color = UIManager.getColor("controlShadow");
        return color != null ? color : Color.GRAY;
    }

    static Color getTextBackground() {
        Color color = UIManager.getColor("TextPane.background");
        return color != null ? color : Color.WHITE;
    }

    static Color getResultBackground() {
        return QuickSearchComboBar.getTextBackground();
    }
}

