/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query
implements Comparable<Query> {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public Filter FILTER_ALL = new AllFilter(this);
    public static Filter FILTER_NOT_SEEN = new NotSeenFilter();
    public Filter FILTER_NEW = new NewFilter(this);
    public Filter FILTER_OBSOLETE = new ObsoleteDateFilter(this);
    public Filter FILTER_ALL_BUT_OBSOLETE = new AllButObsoleteDateFilter(this);
    public static String EVENT_QUERY_ISSUES_CHANGED = "bugtracking.query.issues_changed";
    public static String EVENT_QUERY_SAVED = "bugtracking.query.saved";
    public static String EVENT_QUERY_REMOVED = "bugtracking.query.removed";
    private List<QueryNotifyListener> notifyListeners;
    private IssueTable issueTable;
    protected boolean saved;
    private long lastRefresh = -1L;

    public abstract String getDisplayName();

    public abstract String getTooltip();

    public abstract BugtrackingController getController();

    public Filter[] getFilters() {
        return new Filter[]{this.FILTER_ALL, this.FILTER_NEW, FILTER_NOT_SEEN, new ObsoleteDateFilter(this), this.FILTER_ALL_BUT_OBSOLETE};
    }

    public abstract Repository getRepository();

    public abstract boolean refresh();

    protected void setSaved(boolean bl) {
        this.saved = bl;
        this.fireQuerySaved();
        this.getIssueTable().initColumns();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public abstract Issue[] getIssues(int var1);

    public Issue[] getIssues() {
        return this.getIssues(-1);
    }

    public abstract boolean contains(Issue var1);

    public Issue[] getIssues(String string) {
        return BugtrackingUtil.getByIdOrSummary(this.getIssues(), string);
    }

    @Override
    public int compareTo(Query query) {
        if (query == null) {
            return 1;
        }
        return this.getDisplayName().compareTo(query.getDisplayName());
    }

    public JComponent getTableComponent() {
        return this.getIssueTable().getComponent();
    }

    public abstract ColumnDescriptor[] getColumnDescriptors();

    public void setFilter(Filter filter) {
        this.getIssueTable().setFilter(filter);
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public abstract int getIssueStatus(Issue var1);

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    protected void fireQuerySaved() {
        this.support.firePropertyChange(EVENT_QUERY_SAVED, null, null);
    }

    protected void fireQueryRemoved() {
        this.support.firePropertyChange(EVENT_QUERY_REMOVED, null, null);
    }

    protected void fireQueryIssuesChanged() {
        this.support.firePropertyChange(EVENT_QUERY_ISSUES_CHANGED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifyListener(QueryNotifyListener queryNotifyListener) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.add(queryNotifyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifyListener(QueryNotifyListener queryNotifyListener) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.remove(queryNotifyListener);
        }
    }

    protected void fireNotifyData(Issue issue) {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.notifyData(issue);
        }
    }

    protected void fireStarted() {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.started();
        }
    }

    protected void fireFinished() {
        QueryNotifyListener[] queryNotifyListenerArray;
        for (QueryNotifyListener queryNotifyListener : queryNotifyListenerArray = this.getListeners()) {
            queryNotifyListener.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(Runnable runnable) {
        this.fireStarted();
        try {
            runnable.run();
        }
        finally {
            this.fireFinished();
            this.fireQueryIssuesChanged();
            this.setLastRefresh(System.currentTimeMillis());
        }
    }

    protected void setLastRefresh(long l) {
        this.lastRefresh = l;
    }

    private IssueTable getIssueTable() {
        if (this.issueTable == null) {
            this.issueTable = new IssueTable(this);
        }
        return this.issueTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryNotifyListener[] getListeners() {
        QueryNotifyListener[] queryNotifyListenerArray;
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            queryNotifyListenerArray = list.toArray(new QueryNotifyListener[list.size()]);
        }
        return queryNotifyListenerArray;
    }

    private List<QueryNotifyListener> getNotifyListeners() {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList<QueryNotifyListener>();
        }
        return this.notifyListeners;
    }

    private static class AllButObsoleteDateFilter
    extends Filter {
        private final Query query;

        public AllButObsoleteDateFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_AllButObsoleteIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.contains(issue);
        }
    }

    private static class ObsoleteDateFilter
    extends Filter {
        private final Query query;

        public ObsoleteDateFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_ObsoleteIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return !this.query.contains(issue);
        }
    }

    private static class NewFilter
    extends Filter {
        private final Query query;

        public NewFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_NewIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.getIssueStatus(issue) == 4;
        }
    }

    private static class NotSeenFilter
    extends Filter {
        private NotSeenFilter() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_UnseenIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return !issue.wasSeen();
        }
    }

    private static class AllFilter
    extends Filter {
        private final Query query;

        public AllFilter(Query query) {
            this.query = query;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Query.class, (String)"LBL_AllIssuesFilter");
        }

        public boolean accept(Issue issue) {
            return this.query.contains(issue) || !issue.wasSeen();
        }
    }

    public static abstract class Filter {
        public abstract String getDisplayName();

        public abstract boolean accept(Issue var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        private int width;

        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3) {
            this(string, clazz, string2, string3, -1);
        }

        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3, int n) {
            super(string, clazz, string2, string3);
            this.width = n;
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

