/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.IssueStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IssueCache<T> {
    private Map<String, IssueEntry> cache;
    private Map<String, Map<String, String>> lastSeenAttributes;
    private String nameSpace;
    private final Object CACHE_LOCK = new Object();

    public IssueCache(String string) {
        this.nameSpace = string;
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = IssueCache.this.CACHE_LOCK;
                synchronized (object) {
                    IssueStorage.getInstance().cleanup(IssueCache.this.nameSpace);
                }
            }
        });
    }

    protected abstract Issue createIssue(T var1);

    protected abstract void setTaskData(Issue var1, T var2);

    public Issue setIssueData(String string, T t) throws IOException {
        return this.setIssueData(string, t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue setIssueData(String string, T t, Issue issue) throws IOException {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                issueEntry = this.createNewEntry(string);
            }
            if (issueEntry.issue == null) {
                if (issue != null) {
                    issueEntry.issue = issue;
                    BugtrackingManager.LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{string});
                    this.setTaskData(issueEntry.issue, t);
                } else {
                    issueEntry.issue = this.createIssue(t);
                    BugtrackingManager.LOG.log(Level.FINE, "created issue {0} ", new Object[]{string});
                    this.readIssue(issueEntry);
                }
            } else {
                BugtrackingManager.LOG.log(Level.FINE, "setting task data for issue {0} ", new Object[]{string});
                this.setTaskData(issueEntry.issue, t);
            }
            if (issueEntry.seenAttributes != null) {
                if (issueEntry.wasSeen()) {
                    BugtrackingManager.LOG.log(Level.FINE, " issue {0} was seen", new Object[]{string});
                    if (this.isChanged(issueEntry.seenAttributes, issueEntry.issue.getAttributes())) {
                        BugtrackingManager.LOG.log(Level.FINE, " issue {0} is changed", new Object[]{string});
                        this.storeIssue(issueEntry);
                        issueEntry.seen = false;
                        issueEntry.status = 8;
                    } else {
                        BugtrackingManager.LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{string});
                    }
                } else {
                    BugtrackingManager.LOG.log(Level.FINE, " issue {0} wasn't seen yet", new Object[]{string});
                    if (this.isChanged(issueEntry.seenAttributes, issueEntry.issue.getAttributes())) {
                        BugtrackingManager.LOG.log(Level.FINE, " issue {0} is changed", new Object[]{string});
                        issueEntry.seen = false;
                        issueEntry.status = 8;
                    } else {
                        BugtrackingManager.LOG.log(Level.FINE, " issue {0} isn't changed", new Object[]{string});
                        issueEntry.seenAttributes = null;
                        issueEntry.seen = false;
                        issueEntry.status = 4;
                    }
                }
            }
            return issueEntry.issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeen(String string, boolean bl) throws IOException {
        BugtrackingManager.LOG.log(Level.FINE, "setting seen {0} for issue {1}", new Object[]{bl, string});
        assert (!SwingUtilities.isEventDispatchThread());
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            assert (issueEntry != null);
            if (bl) {
                this.getLastSeenAttributes().put(string, issueEntry.seenAttributes);
                issueEntry.seenAttributes = issueEntry.issue.getAttributes();
            } else {
                issueEntry.seenAttributes = this.getLastSeenAttributes().get(string);
            }
            issueEntry.seen = bl;
            this.storeIssue(issueEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSeen(String string) {
        IssueEntry issueEntry;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                issueEntry = this.createNewEntry(string);
                this.readIssue(issueEntry);
            }
        }
        boolean bl = issueEntry != null ? issueEntry.seen : false;
        BugtrackingManager.LOG.log(Level.FINE, "returning seen {0} for issue {1}", new Object[]{bl, string});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSeenAttributes(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                assert (!SwingUtilities.isEventDispatchThread());
                issueEntry = this.createNewEntry(string);
                this.readIssue(issueEntry);
            }
            return issueEntry.seenAttributes != null ? issueEntry.seenAttributes : null;
        }
    }

    private IssueEntry createNewEntry(String string) {
        IssueEntry issueEntry = new IssueEntry();
        issueEntry.id = string;
        issueEntry.status = 4;
        this.getCache().put(string, issueEntry);
        return issueEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue getIssue(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            return this.getCache().get(string).issue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            IssueEntry issueEntry = this.getCache().get(string);
            if (issueEntry == null) {
                BugtrackingManager.LOG.log(Level.FINE, "returning UKNOWN status for issue {0}", new Object[]{string});
                return 0;
            }
            if (issueEntry.seen) {
                BugtrackingManager.LOG.log(Level.FINE, "returning SEEN status for issue {0}", new Object[]{string});
                return 2;
            }
            BugtrackingManager.LOG.log(Level.FINE, "returning status {0} for issue {1}", new Object[]{issueEntry.status, string});
            return issueEntry.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeQueryIssues(String string, String[] stringArray) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeQuery(this.nameSpace, string, stringArray);
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readQueryIssues(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                return IssueStorage.getInstance().readQuery(this.nameSpace, string);
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeArchivedQueryIssues(String string, String[] stringArray) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().storeArchivedQueryIssues(this.nameSpace, string, stringArray);
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readArchivedQueryIssues(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                Map<String, Long> map = IssueStorage.getInstance().readArchivedQueryIssues(this.nameSpace, string);
                return new ArrayList<String>(map.keySet());
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
                return new ArrayList<String>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String string) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            try {
                IssueStorage.getInstance().removeQuery(this.nameSpace, string);
            }
            catch (IOException iOException) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
            }
        }
    }

    private Map<String, IssueEntry> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, IssueEntry>();
        }
        return this.cache;
    }

    private Map<String, Map<String, String>> getLastSeenAttributes() {
        if (this.lastSeenAttributes == null) {
            this.lastSeenAttributes = new HashMap<String, Map<String, String>>();
        }
        return this.lastSeenAttributes;
    }

    private synchronized void readIssue(IssueEntry issueEntry) {
        try {
            IssueStorage.getInstance().readIssue(this.nameSpace, issueEntry);
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    private void storeIssue(IssueEntry issueEntry) throws IOException {
        IssueStorage.getInstance().storeIssue(this.nameSpace, issueEntry);
    }

    private boolean isChanged(Map<String, String> map, Map<String, String> map2) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = map2.get(entry.getKey());
            String string2 = entry.getValue();
            if (string == null && string2 == null || entry.getKey().equals("date.modification") || string != null && string.trim().equals(string2.trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssueEntry {
        private Issue issue;
        private Map<String, String> seenAttributes;
        private int status;
        private boolean seen = false;
        private String id;

        IssueEntry() {
        }

        IssueEntry(Issue issue, Map<String, String> map, int n, boolean bl) {
            this.issue = issue;
            this.id = issue.getID();
            this.seenAttributes = map;
            this.status = n;
            this.seen = bl;
        }

        public boolean wasSeen() {
            return this.seen;
        }

        public Map<String, String> getSeenAttributes() {
            return this.seenAttributes;
        }

        public int getStatus() {
            return this.status;
        }

        public void setSeen(boolean bl) {
            this.seen = bl;
        }

        public void setSeenAttributes(Map<String, String> map) {
            this.seenAttributes = map;
        }

        public String getId() {
            return this.id;
        }
    }
}

