/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.MessageFormat;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.NbBundle;

public class QueryResultHandleImpl
extends QueryResultHandle
implements ActionListener {
    private final Query query;
    private final String label;
    private Query.Filter filter;
    private static MessageFormat totalFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotal"));
    private static MessageFormat unseenFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseen"));
    private static MessageFormat newFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNew"));

    QueryResultHandleImpl(Query query, String string, Query.Filter filter) {
        this.query = query;
        this.label = string;
        this.filter = filter;
    }

    public String getText() {
        return this.label;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.query.setFilter(this.filter);
        QueryAction.openKenaiQuery(this.query, null);
    }

    static QueryResultHandleImpl forStatus(Query query, int n) {
        switch (n) {
            case 14: {
                Issue[] issueArray = query.getIssues(n);
                return new QueryResultHandleImpl(query, totalFormat.format(new Object[]{issueArray != null ? issueArray.length : 0}, new StringBuffer(), (FieldPosition)null).toString(), query.FILTER_ALL);
            }
            case 12: {
                int n2 = 0;
                Issue[] issueArray = query.getIssues(12);
                if (issueArray == null || issueArray.length == 0) {
                    return null;
                }
                n2 = issueArray.length;
                StringBuffer stringBuffer = new StringBuffer();
                unseenFormat.format(new Object[]{n2}, stringBuffer, (FieldPosition)null);
                return new QueryResultHandleImpl(query, stringBuffer.toString(), Query.FILTER_NOT_SEEN);
            }
            case 4: {
                int n3 = 0;
                Issue[] issueArray = query.getIssues(4);
                if (issueArray == null || issueArray.length == 0) {
                    return null;
                }
                n3 = issueArray.length;
                StringBuffer stringBuffer = new StringBuffer();
                newFormat.format(new Object[]{n3}, stringBuffer, (FieldPosition)null);
                return new QueryResultHandleImpl(query, stringBuffer.toString(), query.FILTER_NEW);
            }
        }
        throw new IllegalStateException("wrong status value [" + n + "]");
    }
}

