/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.FakeJiraSupport;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.QueryHandleImpl;
import org.netbeans.modules.bugtracking.kenai.QueryResultHandleImpl;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAccessorImpl
extends QueryAccessor
implements PropertyChangeListener {
    private final Map<String, ProjectHandleListener> projectListeners = new HashMap<String, ProjectHandleListener>();
    private final Map<String, KenaiRepositoryListener> kenaiRepoListeners = new HashMap<String, KenaiRepositoryListener>();
    private final Map<String, Map<String, QueryHandle>> queryHandles = new HashMap<String, Map<String, QueryHandle>>();

    public QueryAccessorImpl() {
        Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        Dashboard.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryHandle> getQueries(ProjectHandle projectHandle) {
        ProjectHandleListener projectHandleListener;
        Repository repository = KenaiRepositories.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return fakeJiraSupport.getQueries();
            }
            return Collections.emptyList();
        }
        KenaiRepositoryListener kenaiRepositoryListener = null;
        Object object = this.kenaiRepoListeners;
        synchronized (object) {
            kenaiRepositoryListener = this.kenaiRepoListeners.get(repository.getDisplayName());
            if (kenaiRepositoryListener == null) {
                kenaiRepositoryListener = new KenaiRepositoryListener(repository, projectHandle);
                repository.addPropertyChangeListener(kenaiRepositoryListener);
                this.kenaiRepoListeners.put(repository.getDisplayName(), kenaiRepositoryListener);
            }
        }
        object = this.getQueryHandles(repository, projectHandle, true);
        Map<String, ProjectHandleListener> map = this.projectListeners;
        synchronized (map) {
            projectHandleListener = this.projectListeners.get(projectHandle.getId());
        }
        if (projectHandleListener != null) {
            projectHandle.removePropertyChangeListener((PropertyChangeListener)projectHandleListener);
        }
        projectHandleListener = new ProjectHandleListener(projectHandle, (List<QueryHandle>)object);
        projectHandle.addPropertyChangeListener((PropertyChangeListener)projectHandleListener);
        map = this.projectListeners;
        synchronized (map) {
            this.projectListeners.put(projectHandle.getId(), projectHandleListener);
        }
        return Collections.unmodifiableList(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryHandle> getQueryHandles(Repository repository, ProjectHandle projectHandle, boolean bl) {
        Object object;
        Map<String, QueryHandle> map;
        Query[] queryArray = repository.getQueries();
        if (queryArray == null || queryArray.length == 0) {
            return Collections.emptyList();
        }
        Object object2 = this.queryHandles;
        synchronized (object2) {
            map = this.queryHandles.get(projectHandle.getId());
            if (map == null) {
                map = new HashMap<String, QueryHandle>();
                this.queryHandles.put(projectHandle.getId(), map);
            } else {
                Query[] queryArray2 = new ArrayList();
                Query[] queryArray3 = queryArray;
                int n = queryArray3.length;
                for (int i = 0; i < n; ++i) {
                    object = queryArray3[i];
                    queryArray2.add(((Query)object).getDisplayName());
                }
                map.keySet().retainAll((Collection<?>)queryArray2);
            }
        }
        object2 = new ArrayList();
        for (Query query : queryArray) {
            object = map.get(query.getDisplayName());
            if (object == null) {
                object = new QueryHandleImpl(query, bl);
                map.put(query.getDisplayName(), (QueryHandle)object);
            }
            object2.add(object);
        }
        return object2;
    }

    public List<QueryResultHandle> getQueryResults(QueryHandle queryHandle) {
        if (queryHandle instanceof QueryHandleImpl) {
            QueryHandleImpl queryHandleImpl = (QueryHandleImpl)queryHandle;
            queryHandleImpl.refreshIfNeeded();
            return Collections.unmodifiableList(queryHandleImpl.getQueryResults());
        }
        if (queryHandle instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            FakeJiraSupport.FakeJiraQueryHandle fakeJiraQueryHandle = (FakeJiraSupport.FakeJiraQueryHandle)queryHandle;
            return fakeJiraQueryHandle.getQueryResults();
        }
        return Collections.emptyList();
    }

    public ActionListener getFindIssueAction(ProjectHandle projectHandle) {
        final Repository repository = KenaiRepositories.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return fakeJiraSupport.getOpenProjectListener();
            }
            return null;
        }
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        QueryAction.openKenaiQuery(null, repository);
                    }
                });
            }
        };
    }

    public ActionListener getCreateIssueAction(ProjectHandle projectHandle) {
        final Repository repository = KenaiRepositories.getInstance().getRepository(projectHandle);
        if (repository == null) {
            FakeJiraSupport fakeJiraSupport = FakeJiraSupport.get(projectHandle);
            if (fakeJiraSupport != null) {
                return fakeJiraSupport.getCreateIssueListener();
            }
            return null;
        }
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        IssueAction.openIssue(repository);
                    }
                });
            }
        };
    }

    public ActionListener getOpenQueryResultAction(QueryResultHandle queryResultHandle) {
        if (queryResultHandle instanceof QueryResultHandleImpl || queryResultHandle instanceof FakeJiraSupport.FakeJiraQueryResultHandle) {
            return (ActionListener)queryResultHandle;
        }
        return null;
    }

    public ActionListener getDefaultAction(QueryHandle queryHandle) {
        if (queryHandle instanceof QueryHandleImpl || queryHandle instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            return (ActionListener)queryHandle;
        }
        return null;
    }

    void fireQueriesChanged(ProjectHandle projectHandle, List<QueryHandle> list) {
        this.fireQueryListChanged(projectHandle, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("refreshRequest")) {
            Map<String, Object> map = this.projectListeners;
            synchronized (map) {
                this.projectListeners.clear();
            }
            map = this.kenaiRepoListeners;
            synchronized (map) {
                this.kenaiRepoListeners.clear();
            }
            map = this.queryHandles;
            synchronized (map) {
                this.queryHandles.clear();
                return;
            }
        }
        if (!propertyChangeEvent.getPropertyName().equals("login") || propertyChangeEvent.getNewValue() != null) return;
        ProjectHandleListener[] projectHandleListenerArray = this.projectListeners;
        synchronized (this.projectListeners) {
            ProjectHandleListener[] projectHandleListenerArray2 = this.projectListeners.values().toArray(new ProjectHandleListener[this.projectListeners.values().size()]);
            // ** MonitorExit[var3_5] (shouldn't be in output)
            for (ProjectHandleListener projectHandleListener : projectHandleListenerArray2) {
                projectHandleListener.closeQueries();
            }
            return;
        }
    }

    private class KenaiRepositoryListener
    implements PropertyChangeListener {
        private final ProjectHandle ph;
        private Repository repo;

        public KenaiRepositoryListener(Repository repository, ProjectHandle projectHandle) {
            this.ph = projectHandle;
            this.repo = repository;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(Repository.EVENT_QUERY_LIST_CHANGED)) {
                QueryAccessorImpl.this.fireQueriesChanged(this.ph, QueryAccessorImpl.this.getQueryHandles(this.repo, this.ph, false));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectHandleListener
    implements PropertyChangeListener {
        private List<QueryHandle> queries;
        private ProjectHandle ph;

        public ProjectHandleListener(ProjectHandle projectHandle, List<QueryHandle> list) {
            this.queries = list;
            this.ph = projectHandle;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("close")) {
                this.closeQueries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeQueries() {
            for (QueryHandle queryHandle : this.queries) {
                QueryAction.closeQuery(((QueryHandleImpl)queryHandle).getQuery());
            }
            Map map = QueryAccessorImpl.this.projectListeners;
            synchronized (map) {
                this.ph.removePropertyChangeListener((PropertyChangeListener)this);
                QueryAccessorImpl.this.projectListeners.remove(this.ph.getId());
            }
        }
    }
}

