/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;

public class KenaiRepositories {
    private static KenaiRepositories instance;
    private Map<String, Repository> map = new HashMap<String, Repository>();

    private KenaiRepositories() {
    }

    public static KenaiRepositories getInstance() {
        if (instance == null) {
            instance = new KenaiRepositories();
        }
        return instance;
    }

    public Repository[] getRepositories() {
        ProjectHandle[] projectHandleArray = Dashboard.getDefault().getOpenProjects();
        if (projectHandleArray == null || projectHandleArray.length == 0) {
            return new Repository[0];
        }
        ArrayList<Repository> arrayList = new ArrayList<Repository>();
        for (ProjectHandle projectHandle : projectHandleArray) {
            Repository repository;
            if (projectHandle == null || (repository = this.getRepository(projectHandle)) == null) continue;
            arrayList.add(repository);
        }
        return arrayList.toArray(new Repository[arrayList.size()]);
    }

    public Repository getRepository(KenaiProject kenaiProject) {
        BugtrackingConnector[] bugtrackingConnectorArray;
        Repository repository = this.map.get(kenaiProject.getName());
        if (repository != null) {
            return repository;
        }
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = BugtrackingManager.getInstance().getConnectors()) {
            KenaiSupport kenaiSupport = bugtrackingConnector.getKenaiSupport();
            if (kenaiSupport == null || (repository = kenaiSupport.createRepository(kenaiProject)) == null) continue;
            this.map.put(kenaiProject.getName(), repository);
            return repository;
        }
        return null;
    }

    Repository getRepository(ProjectHandle projectHandle) {
        KenaiProject kenaiProject = KenaiRepositories.getKenaiProject(projectHandle);
        if (kenaiProject == null) {
            return null;
        }
        Repository repository = this.map.get(kenaiProject.getName());
        if (repository != null) {
            return repository;
        }
        repository = this.getRepository(kenaiProject);
        if (repository == null) {
            BugtrackingManager.LOG.info("No issue tracking repository available for project " + kenaiProject.getName());
            return null;
        }
        return repository;
    }

    static KenaiProject getKenaiProject(ProjectHandle projectHandle) {
        try {
            return Kenai.getDefault().getProject(projectHandle.getId());
        }
        catch (KenaiException kenaiException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, kenaiException);
            return null;
        }
    }
}

