/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

public final class BlockCompare {
    private static final int BEFORE = 1;
    private static final int AFTER = 2;
    private static final int INSIDE = 4;
    private static final int CONTAINS = 8;
    private static final int OVERLAP_START = 16;
    private static final int OVERLAP_END = 32;
    private static final int EMPTY_X = 64;
    private static final int EMPTY_Y = 128;
    private final int value;

    public static BlockCompare get(int n, int n2, int n3, int n4) {
        return new BlockCompare(BlockCompare.resolve(n, n2, n3, n4));
    }

    private BlockCompare(int n) {
        this.value = n;
    }

    public boolean before() {
        return (this.value & 1) != 0;
    }

    public boolean after() {
        return (this.value & 2) != 0;
    }

    public boolean inside() {
        return (this.value & 4) != 0;
    }

    public boolean insideStrict() {
        return (this.value & 0xC) == 4;
    }

    public boolean contains() {
        return (this.value & 8) != 0;
    }

    public boolean containsStrict() {
        return (this.value & 0xC) == 8;
    }

    public boolean equal() {
        return (this.value & 0xC) == 12;
    }

    public boolean overlap() {
        return (this.value & 0x30) != 0;
    }

    public boolean overlapStart() {
        return (this.value & 0x10) != 0;
    }

    public boolean overlapEnd() {
        return (this.value & 0x20) != 0;
    }

    public boolean emptyX() {
        return (this.value & 0x40) != 0;
    }

    public boolean emptyY() {
        return (this.value & 0x80) != 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        this.appendBit(stringBuilder, 1, "BEFORE");
        this.appendBit(stringBuilder, 2, "AFTER");
        this.appendBit(stringBuilder, 8, "CONTAINS");
        this.appendBit(stringBuilder, 4, "INSIDE");
        this.appendBit(stringBuilder, 16, "OVERLAP_START");
        this.appendBit(stringBuilder, 32, "OVERLAP_END");
        this.appendBit(stringBuilder, 64, "EMPTY_X");
        this.appendBit(stringBuilder, 128, "EMPTY_Y");
        return stringBuilder.toString();
    }

    private void appendBit(StringBuilder stringBuilder, int n, String string) {
        if ((this.value & n) != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(string);
        }
    }

    private static int resolve(int n, int n2, int n3, int n4) {
        int n5;
        assert (n <= n2) : "xStartOffset=" + n + " > xEndOffset=" + n2;
        assert (n3 <= n4) : "yStartOffset=" + n3 + " > yEndOffset=" + n4;
        if (n2 < n3) {
            n5 = 1;
            if (n == n2) {
                n5 |= 0x40;
            }
            if (n3 == n4) {
                n5 |= 0x80;
            }
        } else if (n2 == n3) {
            n5 = n == n2 ? (n3 == n4 ? 207 : 73) : (n3 == n4 ? 133 : 1);
        } else if (n > n4) {
            n5 = 2;
            if (n == n2) {
                n5 |= 0x40;
            }
            if (n3 == n4) {
                n5 |= 0x80;
            }
        } else if (n == n4) {
            n5 = n == n2 ? (n3 == n4 ? 207 : 74) : (n3 == n4 ? 143 : 10);
        } else {
            n5 = n < n3 ? (n2 < n4 ? 16 : 8) : (n == n3 ? (n2 < n4 ? 4 : (n2 == n4 ? 12 : 8)) : (n2 <= n4 ? 4 : 32));
            if (n == n2) {
                n5 |= 0x40;
            }
            if (n3 == n4) {
                n5 |= 0x80;
            }
        }
        return n5;
    }
}

